/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.feature;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.opengis.feature.FeatureCollection;
import org.opengis.feature.FeatureStoreListener;
import org.opengis.feature.FeatureType;
import org.opengis.feature.Query;
import org.opengis.feature.Transaction;
import org.opengis.filter.Filter;
import org.opengis.sld.FeatureStyle;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public interface FeatureStore {
    public URI getIcon();

    public InternationalString getDisplayName();

    public InternationalString getDescription();

    public List getTypeNames();

    public List getRootTypeNames();

    public FeatureType getFeatureType(GenericName var1);

    public FeatureCollection getFeatures(GenericName var1) throws IOException;

    public FeatureCollection getFeatures(GenericName var1, Filter var2) throws IOException;

    public FeatureCollection getFeatures(Query var1) throws IOException;

    public FeatureCollection getFeatures(Query var1, Transaction var2) throws IOException;

    public void registerFeatureCollection(FeatureCollection var1, GenericName var2);

    public void registerFeatureCollection(FeatureCollection var1, GenericName var2, Filter var3);

    public void registerFeatureCollection(FeatureCollection var1, Query var2);

    public void unregisterFeatureCollection(FeatureCollection var1);

    public FeatureStyle getDefaultStyle(GenericName var1);

    public void createType(FeatureType var1) throws UnsupportedOperationException, IllegalArgumentException, IOException;

    public void removeType(GenericName var1) throws UnsupportedOperationException, IOException;

    public void modifyType(FeatureType var1) throws UnsupportedOperationException, IOException;

    public void addFeatureStoreListener(FeatureStoreListener var1);

    public void removeFeatureStoreListener(FeatureStoreListener var1);
}

