/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.io.Serializable;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.gcs.Resources;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GeneralGridGeometry
implements GridGeometry,
Serializable {
    private static final long serialVersionUID = -3133087291728297383L;
    protected final GridRange gridRange;
    protected final MathTransform gridToCoordinateSystem;

    public GeneralGridGeometry(GridRange gridRange, MathTransform gridToCoordinateSystem) {
        this.gridRange = gridRange;
        this.gridToCoordinateSystem = gridToCoordinateSystem;
        if (gridRange != null && gridToCoordinateSystem != null) {
            int dimRange = gridRange.getDimension();
            int dimSource = gridToCoordinateSystem.getSourceDimensions();
            int dimTarget = gridToCoordinateSystem.getTargetDimensions();
            if (dimRange != dimSource) {
                throw new MismatchedDimensionException(GeneralGridGeometry.format(dimRange, dimSource));
            }
            if (dimRange != dimTarget) {
                throw new MismatchedDimensionException(GeneralGridGeometry.format(dimRange, dimTarget));
            }
        }
    }

    public GeneralGridGeometry(GridRange gridRange, Envelope userRange, boolean[] reverse) {
        this.gridRange = gridRange;
        int dimension = gridRange.getDimension();
        int userDim = userRange.getDimension();
        if (userDim != dimension) {
            throw new MismatchedDimensionException(GeneralGridGeometry.format(dimension, userDim));
        }
        if (reverse != null && reverse.length != dimension) {
            throw new MismatchedDimensionException(GeneralGridGeometry.format(dimension, reverse.length));
        }
        GeneralMatrix matrix = new GeneralMatrix(dimension + 1);
        for (int i = 0; i < dimension; ++i) {
            double trans;
            double scale = userRange.getLength(i) / (double)gridRange.getLength(i);
            if (reverse == null || !reverse[i]) {
                trans = userRange.getMinimum(i);
            } else {
                scale = -scale;
                trans = userRange.getMaximum(i);
            }
            matrix.setElement(i, i, scale);
            matrix.setElement(i, dimension, trans -= scale * ((double)gridRange.getLower(i) - 0.5));
        }
        this.gridToCoordinateSystem = ProjectiveTransform.create(matrix);
    }

    private static String format(int dim1, int dim2) {
        return org.geotools.resources.cts.Resources.format(98, new Integer(dim1), new Integer(dim2));
    }

    public int getDimension() {
        if (this.gridToCoordinateSystem != null) {
            return this.gridToCoordinateSystem.getSourceDimensions();
        }
        return this.getGridRange().getDimension();
    }

    public Envelope getEnvelope() throws InvalidGridGeometryException {
        int dimension = this.getDimension();
        GeneralEnvelope envelope = new GeneralEnvelope(dimension);
        for (int i = 0; i < dimension; ++i) {
            envelope.setRange(i, (double)this.gridRange.getLower(i) - 0.5, (double)this.gridRange.getUpper(i) - 0.5);
        }
        MathTransform gridToCoordinateSystem = this.getGridToCoordinateSystem();
        try {
            return CRSUtilities.transform(gridToCoordinateSystem, envelope);
        }
        catch (TransformException exception) {
            throw new InvalidGridGeometryException(Resources.format(44, Utilities.getShortClassName(gridToCoordinateSystem)), exception);
        }
    }

    public GridRange getGridRange() throws InvalidGridGeometryException {
        if (this.gridRange != null) {
            return this.gridRange;
        }
        throw new InvalidGridGeometryException(Resources.format(79));
    }

    public MathTransform getGridToCoordinateSystem() throws InvalidGridGeometryException {
        if (this.gridToCoordinateSystem != null) {
            return this.gridToCoordinateSystem;
        }
        throw new InvalidGridGeometryException();
    }

    final boolean[] areAxisInverted() {
        Matrix matrix;
        try {
            matrix = this.gridToCoordinateSystem.derivative(null);
        }
        catch (NullPointerException exception) {
            return null;
        }
        catch (Exception exception) {
            Utilities.unexpectedException("org.geotools.referencing", "MathTransform", "derivative", exception);
            return null;
        }
        int numCol = matrix.getNumCol();
        boolean[] inverse = new boolean[matrix.getNumRow()];
        for (int j = 0; j < inverse.length; ++j) {
            for (int i = 0; i < numCol; ++i) {
                double value = matrix.getElement(j, i);
                if (i == j) {
                    inverse[j] = value < 0.0;
                    continue;
                }
                if (value == 0.0) continue;
                return null;
            }
        }
        return inverse;
    }

    public int hashCode() {
        int code = 1044283993;
        if (this.gridToCoordinateSystem != null) {
            code += this.gridToCoordinateSystem.hashCode();
        }
        if (this.gridRange != null) {
            code += this.gridRange.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralGridGeometry that = (GeneralGridGeometry)object;
            return Utilities.equals(this.gridRange, that.gridRange) && Utilities.equals(this.gridToCoordinateSystem, that.gridToCoordinateSystem);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append('[');
        buffer.append(this.gridRange);
        buffer.append(", ");
        buffer.append(this.gridToCoordinateSystem);
        buffer.append(']');
        return buffer.toString();
    }
}

