/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class MaxFeatureReader
implements FeatureReader {
    protected final FeatureReader featureReader;
    protected final int maxFeatures;
    protected int counter = 0;

    public MaxFeatureReader(FeatureReader featureReader, int maxFeatures) {
        this.featureReader = featureReader;
        this.maxFeatures = maxFeatures;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            ++this.counter;
            return this.featureReader.next();
        }
        throw new NoSuchElementException("No such Feature exists");
    }

    public void close() throws IOException {
        this.featureReader.close();
    }

    public FeatureType getFeatureType() {
        return this.featureReader.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this.featureReader.hasNext() && this.counter < this.maxFeatures;
    }
}

