/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLUnpacker;

public class DefaultSQLBuilder
implements SQLBuilder {
    protected SQLEncoder encoder;

    public DefaultSQLBuilder() {
        this(new SQLEncoder());
    }

    public DefaultSQLBuilder(SQLEncoder encoder) {
        this.encoder = encoder;
    }

    public Filter getPostQueryFilter(Filter filter) {
        FilterCapabilities cap = this.encoder.getCapabilities();
        SQLUnpacker unpacker = new SQLUnpacker(cap);
        unpacker.unPackAND(filter);
        return unpacker.getUnSupported();
    }

    public Filter getPreQueryFilter(Filter filter) {
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackAND(filter);
        return unpacker.getSupported();
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(this.encoder.escapeName(typeName));
    }

    public void sqlWhere(StringBuffer sql, Filter preFilter) throws SQLEncoderException {
        if (preFilter != null && preFilter != Filter.NONE) {
            String where = this.encoder.encode(preFilter);
            sql.append(" ");
            sql.append(where);
        }
    }

    public String buildSQLQuery(String typeName, FIDMapper mapper, AttributeType[] attrTypes, Filter filter) throws SQLEncoderException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        this.sqlColumns(sqlBuffer, mapper, attrTypes);
        this.sqlFrom(sqlBuffer, typeName);
        this.encoder.setFIDMapper(mapper);
        this.sqlWhere(sqlBuffer, filter);
        String sqlStmt = sqlBuffer.toString();
        return sqlStmt;
    }

    public void sqlColumns(StringBuffer sql, FIDMapper mapper, AttributeType[] attributes) {
        int i;
        for (i = 0; i < mapper.getColumnCount(); ++i) {
            sql.append(this.encoder.escapeName(mapper.getColumnName(i)) + ", ");
        }
        for (i = 0; i < attributes.length; ++i) {
            if (attributes[i].isGeometry()) {
                this.sqlGeometryColumn(sql, attributes[i]);
            } else {
                sql.append(this.encoder.escapeName(attributes[i].getName()));
            }
            if (i >= attributes.length - 1) continue;
            sql.append(", ");
        }
    }

    public void sqlGeometryColumn(StringBuffer sql, AttributeType geomAttribute) {
        sql.append(this.encoder.escapeName(geomAttribute.getName()));
    }
}

