/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;

public abstract class JDBCPSFeatureWriter
extends JDBCFeatureWriter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    FIDMapper mapper = null;
    PreparedStatement insertStatement;
    PreparedStatement deleteStatement;
    PreparedStatement updateStatement;

    public JDBCPSFeatureWriter(FeatureReader fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
        this.mapper = queryData.getMapper();
    }

    protected void doInsert(MutableFIDFeature current) throws IOException, SQLException {
        LOGGER.fine("inserting into database feature " + current);
        if (this.insertStatement != null) {
            this.insertStatement = this.createInsertStatement(this.queryData.getConnection(), this.queryData.getFeatureType());
        }
        try {
            this.fillInsertParameters(this.insertStatement, current);
            this.insertStatement.executeUpdate();
            if (this.mapper.getColumnCount() > 0 && this.mapper.hasAutoIncrementColumns()) {
                current.setID(this.mapper.createID(this.queryData.getConnection(), current, this.insertStatement));
            }
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, sqle);
        }
    }

    private void fillInsertParameters(PreparedStatement statement, MutableFIDFeature feature) throws IOException, SQLException {
        int baseIndex = this.fillPrimayKeyParameters(statement, feature, 1);
        Object[] attributes = feature.getAttributes(null);
        AttributeType[] attributeTypes = feature.getFeatureType().getAttributeTypes();
        AttributeIO[] aios = this.queryData.getAttributeHandlers();
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        for (int i = 0; i < attributeTypes.length; ++i) {
            if (attributeTypes[i].isGeometry()) {
                String geomName = attributeTypes[i].getName();
                int srid = ftInfo.getSRID(geomName);
                aios[i].write(statement, baseIndex + i, attributes[i]);
                continue;
            }
            aios[i].write(statement, baseIndex + i, attributes[i]);
        }
    }

    protected PreparedStatement createInsertStatement(Connection conn, FeatureType featureType) throws SQLException {
        int i;
        AttributeType[] attributeTypes = featureType.getAttributeTypes();
        String tableName = featureType.getTypeName();
        StringBuffer statementSQL = new StringBuffer("INSERT INTO " + tableName + "(");
        if (!this.mapper.returnFIDColumnsAsAttributes()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                if (this.mapper.isAutoIncrement(i)) continue;
                statementSQL.append(this.mapper.getColumnName(i)).append(",");
            }
        }
        for (i = 0; i < attributeTypes.length; ++i) {
            statementSQL.append(attributeTypes[i].getName()).append(",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        statementSQL.append(" VALUES (");
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                statementSQL.append("?,");
            }
        }
        for (i = 0; i < attributeTypes.length; ++i) {
            if (attributeTypes[i].isGeometry()) {
                statementSQL.append("?");
            } else {
                statementSQL.append(this.getGeometryPlaceHolder(attributeTypes[i]));
            }
            statementSQL.append(",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        String sql = statementSQL.toString();
        return conn.prepareStatement(sql);
    }

    protected abstract String getGeometryPlaceHolder(AttributeType var1);

    protected void remove(MutableFIDFeature current) throws IOException, SQLException {
        LOGGER.fine("inserting into database feature " + current);
        if (this.deleteStatement != null) {
            this.deleteStatement = this.createDeleteStatement(this.queryData.getConnection(), this.queryData.getFeatureType());
        }
        try {
            this.fillDeleteParameters(this.deleteStatement, current);
            this.deleteStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, sqle);
        }
    }

    private void fillDeleteParameters(PreparedStatement statement, MutableFIDFeature feature) throws IOException, SQLException {
        this.fillPrimayKeyParameters(statement, feature, 1);
    }

    private int fillPrimayKeyParameters(PreparedStatement statement, Feature feature, int baseIndex) throws IOException, SQLException {
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            String FID = this.mapper.createID(this.queryData.getConnection(), feature, null);
            Object[] primaryKey = this.mapper.getPKAttributes(FID);
            for (int i = 0; i < primaryKey.length; ++i) {
                statement.setObject(i + 1, primaryKey[i]);
            }
            baseIndex += primaryKey.length;
        }
        return baseIndex;
    }

    protected PreparedStatement createDeleteStatement(Connection conn, FeatureType featureType) throws SQLException {
        AttributeType[] attributeTypes = featureType.getAttributeTypes();
        String tableName = featureType.getTypeName();
        StringBuffer statementSQL = new StringBuffer("DELETE " + tableName + "WHERE ");
        if (!this.mapper.returnFIDColumnsAsAttributes()) {
            for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
                if (this.mapper.isAutoIncrement(i)) continue;
                statementSQL.append(this.mapper.getColumnName(i)).append(" = ?");
                if (i >= this.mapper.getColumnCount() - 1) continue;
                statementSQL.append(" AND ");
            }
        }
        String sql = statementSQL.toString();
        return conn.prepareStatement(sql);
    }

    private void fillUpdateParameters(PreparedStatement statement, Feature current, Feature live) throws IOException, SQLException {
        Object[] attributes = current.getAttributes(null);
        AttributeType[] attributeTypes = current.getFeatureType().getAttributeTypes();
        AttributeIO[] aios = this.queryData.getAttributeHandlers();
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        for (int i = 0; i < attributeTypes.length; ++i) {
            if (attributeTypes[i].isGeometry()) {
                String geomName = attributeTypes[i].getName();
                int srid = ftInfo.getSRID(geomName);
                aios[i].write(statement, i + 1, attributes[i]);
                continue;
            }
            aios[i].write(statement, i + 1, attributes[i]);
        }
        int baseIndex = attributeTypes.length + 1;
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            baseIndex = this.fillPrimayKeyParameters(statement, current, baseIndex);
        }
        this.fillPrimayKeyParameters(statement, live, baseIndex + 1);
    }

    protected PreparedStatement createUpdateStatement(Connection conn, FeatureType featureType) throws SQLException {
        int i;
        AttributeType[] attributeTypes = featureType.getAttributeTypes();
        String tableName = featureType.getTypeName();
        StringBuffer statementSQL = new StringBuffer("UPDATE  " + tableName + " SET ");
        for (i = 0; i < attributeTypes.length; ++i) {
            statementSQL.append(attributeTypes[i].getName()).append(" = ");
            if (attributeTypes[i].isGeometry()) {
                statementSQL.append("?");
            } else {
                statementSQL.append(this.getGeometryPlaceHolder(attributeTypes[i]));
            }
            statementSQL.append(",");
        }
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                statementSQL.append(this.mapper.getColumnName(i)).append(" = ?,");
            }
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ' ');
        statementSQL.append(" WHERE ");
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                statementSQL.append(this.mapper.getColumnName(i)).append(" = ?");
                if (i >= this.mapper.getColumnCount() - 1) continue;
                statementSQL.append(" AND ");
            }
        }
        String sql = statementSQL.toString();
        return conn.prepareStatement(sql);
    }

    protected void doUpdate(Feature live, Feature current) throws IOException, SQLException {
        LOGGER.fine("updating postgis feature " + current);
        if (this.updateStatement != null) {
            this.updateStatement = this.createUpdateStatement(this.queryData.getConnection(), this.queryData.getFeatureType());
        }
        try {
            this.fillUpdateParameters(this.updateStatement, current, live);
            this.updateStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, sqle);
        }
    }

    protected boolean useQueryDataForInsert() {
        return false;
    }

    public void close() throws IOException {
        JDBCUtils.close(this.insertStatement);
        JDBCUtils.close(this.updateStatement);
        JDBCUtils.close(this.deleteStatement);
        super.close();
    }
}

