/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ActiveTypeEntry;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;

public class TypeDiffState
implements Transaction.State {
    Transaction transaction;
    Map diffMap = new HashMap();
    private ActiveTypeEntry entry;

    public TypeDiffState(ActiveTypeEntry typeEntry) {
        this.entry = typeEntry;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        } else {
            this.transaction = null;
            if (this.diffMap != null) {
                this.diffMap.clear();
            }
            this.entry = null;
        }
    }

    public Map diff() throws IOException {
        return this.diffMap;
    }

    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    public synchronized void commit() throws IOException {
        this.applyDiff(this.diffMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void applyDiff(Map diff) throws IOException {
        if (diff.isEmpty()) {
            return;
        }
        FeatureWriter writer = this.entry.createWriter();
        try {
            String fid;
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                fid = feature.getID();
                if (!diff.containsKey(fid)) continue;
                Feature update = (Feature)diff.remove(fid);
                if (update == null) {
                    writer.remove();
                    this.entry.listenerManager.fireFeaturesChanged(this.entry.getTypeName(), this.transaction, feature.getBounds(), true);
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes(null));
                    writer.write();
                    Envelope bounds = new Envelope();
                    bounds.expandToInclude(feature.getBounds());
                    bounds.expandToInclude(update.getBounds());
                    this.entry.listenerManager.fireFeaturesChanged(this.entry.getTypeName(), this.transaction, bounds, true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, e);
                }
            }
            Iterator i = diff.values().iterator();
            while (i.hasNext()) {
                Feature addedFeature = (Feature)i.next();
                i.remove();
                if (addedFeature == null) continue;
                fid = addedFeature.getID();
                SimpleFeature nextFeature = (SimpleFeature)writer.next();
                if (nextFeature == null) {
                    throw new DataSourceException("Could not add " + fid);
                }
                try {
                    nextFeature.setAttributes(addedFeature.getAttributes(null));
                    writer.write();
                    this.entry.listenerManager.fireFeaturesAdded(this.entry.getTypeName(), this.transaction, nextFeature.getBounds(), true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, e);
                    return;
                }
            }
        }
        finally {
            writer.close();
            this.entry.listenerManager.fireChanged(this.entry.getTypeName(), this.transaction, true);
        }
    }

    public synchronized void rollback() throws IOException {
        this.diffMap.clear();
        this.entry.listenerManager.fireChanged(this.entry.getTypeName(), this.transaction, false);
    }

    public synchronized FeatureReader reader() throws IOException {
        return new DiffFeatureReader(this.entry.reader(Query.ALL, this.transaction), this.diffMap);
    }

    public synchronized FeatureWriter writer() throws IOException {
        Map diff = null;
        FeatureReader reader = this.entry.createReader();
        return new DiffFeatureWriter(reader, diff){

            protected void fireNotification(int eventType, Envelope bounds) {
                switch (eventType) {
                    case 1: {
                        ((TypeDiffState)TypeDiffState.this).entry.listenerManager.fireFeaturesAdded(TypeDiffState.this.entry.getTypeName(), TypeDiffState.this.transaction, bounds, false);
                        break;
                    }
                    case 0: {
                        ((TypeDiffState)TypeDiffState.this).entry.listenerManager.fireFeaturesChanged(TypeDiffState.this.entry.getTypeName(), TypeDiffState.this.transaction, bounds, false);
                        break;
                    }
                    case -1: {
                        ((TypeDiffState)TypeDiffState.this).entry.listenerManager.fireFeaturesRemoved(TypeDiffState.this.entry.getTypeName(), TypeDiffState.this.transaction, bounds, false);
                    }
                }
            }
        };
    }
}

