/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.resources.Utilities;

public class FactoryCreator
extends FactoryRegistry {
    private static final Class[] HINTS_ARGUMENT = new Class[]{Hints.class};

    public FactoryCreator(Collection categories) {
        super(categories);
    }

    public Object getServiceProvider(Class category, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        try {
            return super.getServiceProvider(category, filter, hints, key);
        }
        catch (FactoryNotFoundException exception) {
            Class type;
            Object hint;
            FactoryNotFoundException notFound = exception;
            if (hints != null && key != null && (hint = hints.get(key)) != null && (type = hint instanceof Class[] ? ((Class[])hint)[0] : (Class)hint) != null && category.isAssignableFrom(type)) {
                return this.createServiceProvider(category, type, hints);
            }
            Iterator it = this.getServiceProviders(category);
            while (it.hasNext()) {
                Class<?> implementation = it.next().getClass();
                try {
                    implementation.getConstructor(HINTS_ARGUMENT);
                }
                catch (NoSuchMethodException exception2) {
                    continue;
                }
                return this.createServiceProvider(category, implementation, hints);
            }
            throw notFound;
        }
    }

    protected Object createServiceProvider(Class category, Class implementation, Hints hints) throws FactoryRegistryException {
        Throwable cause;
        try {
            try {
                return implementation.getConstructor(HINTS_ARGUMENT).newInstance(hints);
            }
            catch (NoSuchMethodException exception) {
                try {
                    return implementation.getConstructor(null).newInstance(null);
                }
                catch (NoSuchMethodException exception2) {
                    cause = exception2;
                }
            }
        }
        catch (IllegalAccessException exception) {
            cause = exception;
        }
        catch (InstantiationException exception) {
            cause = exception;
        }
        catch (InvocationTargetException exception) {
            cause = exception.getCause();
        }
        throw new FactoryRegistryException("Can't creates \"" + Utilities.getShortName(implementation) + "\" factory.", cause);
    }
}

