/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;

public class Collection_MinFunction
extends FunctionExpressionImpl
implements FunctionExpression {
    FeatureCollection fc = null;
    double min = 0.0;
    Expression expr;

    public String getName() {
        return "Collection_Min";
    }

    public int getArgCount() {
        return 1;
    }

    private void calculateMin() {
        FeatureIterator it = this.fc.features();
        this.min = Double.POSITIVE_INFINITY;
        while (it.hasNext()) {
            Feature f = it.next();
            double value = ((Number)this.expr.getValue(f)).doubleValue();
            if (!(value < this.min)) continue;
            this.min = value;
        }
    }

    public void setArgs(Expression[] args) {
        this.expr = args[0];
    }

    public Object getValue(Feature feature) {
        FeatureCollection coll = feature.getParent();
        if (!coll.equals(this.fc)) {
            this.fc = coll;
            this.calculateMin();
        }
        return new Double(this.min);
    }

    public void setExpression(Expression e) {
        this.expr = e;
        if (this.fc != null) {
            this.calculateMin();
        }
    }

    public Expression[] getArgs() {
        Expression[] ret = new Expression[]{this.expr};
        return ret;
    }

    public String toString() {
        return "Collection_Min( " + this.expr + ")";
    }
}

