/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;

public class StaticGeometry {
    public static Geometry geomFromWKT(String wkt) {
        WKTReader wktreader = new WKTReader();
        try {
            return wktreader.read(wkt);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad wkt");
        }
    }

    public static String toWKT(Geometry arg0) {
        Geometry _this = arg0;
        return _this.toString();
    }

    public static boolean contains(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.contains(arg1);
    }

    public static boolean isEmpty(Geometry arg0) {
        Geometry _this = arg0;
        return _this.isEmpty();
    }

    public static double geomLength(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getLength();
    }

    public static boolean intersects(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.intersects(arg1);
    }

    public static boolean isValid(Geometry arg0) {
        Geometry _this = arg0;
        return _this.isValid();
    }

    public static String geometryType(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getGeometryType();
    }

    public static int numPoints(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getNumPoints();
    }

    public static boolean isSimple(Geometry arg0) {
        Geometry _this = arg0;
        return _this.isSimple();
    }

    public static double distance(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.distance(arg1);
    }

    public static boolean isWithinDistance(Geometry arg0, Geometry arg1, double arg2) {
        Geometry _this = arg0;
        return _this.isWithinDistance(arg1, arg2);
    }

    public static double area(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getArea();
    }

    public static Geometry centroid(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getCentroid();
    }

    public static Geometry interiorPoint(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getInteriorPoint();
    }

    public static int dimension(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getDimension();
    }

    public static Geometry boundary(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getBoundary();
    }

    public static int boundaryDimension(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getBoundaryDimension();
    }

    public static Geometry envelope(Geometry arg0) {
        Geometry _this = arg0;
        return _this.getEnvelope();
    }

    public static boolean disjoint(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.disjoint(arg1);
    }

    public static boolean touches(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.touches(arg1);
    }

    public static boolean crosses(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.crosses(arg1);
    }

    public static boolean within(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.within(arg1);
    }

    public static boolean overlaps(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.overlaps(arg1);
    }

    public static boolean relatePattern(Geometry arg0, Geometry arg1, String arg2) {
        Geometry _this = arg0;
        return _this.relate(arg1, arg2);
    }

    public static String relate(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.relate(arg1).toString();
    }

    public static Geometry bufferWithSegments(Geometry arg0, double arg1, int arg2) {
        Geometry _this = arg0;
        return _this.buffer(arg1, arg2);
    }

    public static Geometry buffer(Geometry arg0, double arg1) {
        Geometry _this = arg0;
        return _this.buffer(arg1);
    }

    public static Geometry convexHull(Geometry arg0) {
        Geometry _this = arg0;
        return _this.convexHull();
    }

    public static Geometry intersection(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.intersection(arg1);
    }

    public static Geometry union(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.union(arg1);
    }

    public static Geometry difference(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.difference(arg1);
    }

    public static Geometry symDifference(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.symDifference(arg1);
    }

    public static boolean equalsExactTolerance(Geometry arg0, Geometry arg1, double arg2) {
        Geometry _this = arg0;
        return _this.equalsExact(arg1, arg2);
    }

    public static boolean equalsExact(Geometry arg0, Geometry arg1) {
        Geometry _this = arg0;
        return _this.equalsExact(arg1);
    }

    public static int numGeometries(Geometry arg0) {
        GeometryCollection _this = (GeometryCollection)arg0;
        return _this.getNumGeometries();
    }

    public static Geometry getGeometryN(Geometry arg0, int arg1) {
        GeometryCollection _this = (GeometryCollection)arg0;
        return _this.getGeometryN(arg1);
    }

    public static double getX(Geometry arg0) {
        Point _this = (Point)arg0;
        return _this.getX();
    }

    public static double getY(Geometry arg0) {
        Point _this = (Point)arg0;
        return _this.getY();
    }

    public static boolean isClosed(Geometry arg0) {
        LineString _this = (LineString)arg0;
        return _this.isClosed();
    }

    public static Geometry pointN(Geometry arg0, int arg1) {
        LineString _this = (LineString)arg0;
        return _this.getPointN(arg1);
    }

    public static Geometry startPoint(Geometry arg0) {
        LineString _this = (LineString)arg0;
        return _this.getStartPoint();
    }

    public static Geometry endPoint(Geometry arg0) {
        LineString _this = (LineString)arg0;
        return _this.getEndPoint();
    }

    public static boolean isRing(Geometry arg0) {
        LineString _this = (LineString)arg0;
        return _this.isRing();
    }

    public static Geometry exteriorRing(Geometry arg0) {
        Polygon _this = (Polygon)arg0;
        return _this.getExteriorRing();
    }

    public static int numInteriorRing(Geometry arg0) {
        Polygon _this = (Polygon)arg0;
        return _this.getNumInteriorRing();
    }

    public static Geometry interiorRingN(Geometry arg0, int arg1) {
        Polygon _this = (Polygon)arg0;
        return _this.getInteriorRingN(arg1);
    }

    public static String strConcat(String s1, String s2) {
        return s1 + s2;
    }

    public static boolean strEndsWith(String s1, String s2) {
        return s1.endsWith(s2);
    }

    public static boolean strStartsWith(String s1, String s2) {
        return s1.startsWith(s2);
    }

    public static boolean strEqualsIgnoreCase(String s1, String s2) {
        return s1.equalsIgnoreCase(s2);
    }

    public static int strIndexOf(String s1, String s2) {
        return s1.indexOf(s2);
    }

    public static int strLastIndexOf(String s1, String s2) {
        return s1.lastIndexOf(s2);
    }

    public static int strLength(String s1) {
        return s1.length();
    }

    public static boolean strMatches(String s1, String s2) {
        return s1.matches(s2);
    }

    public static String strSubstring(String s1, int beg, int end) {
        return s1.substring(beg, end);
    }

    public static String strSubstringStart(String s1, int beg) {
        return s1.substring(beg);
    }

    public static String strTrim(String s1) {
        return s1.trim();
    }

    public static double parseDouble(String s) {
        return Double.parseDouble(s);
    }

    public static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return (int)Math.round(Double.parseDouble(s));
        }
    }

    public static boolean parseBoolean(String s) {
        return !s.equalsIgnoreCase("") && !s.equalsIgnoreCase("f") && !s.equalsIgnoreCase("false") && !s.equalsIgnoreCase("0") && !s.equalsIgnoreCase("0.0");
    }

    public static int roundDouble(double d) {
        return (int)Math.round(d);
    }

    public static double int2ddouble(int i) {
        return i;
    }

    public static boolean int2bbool(int i) {
        return i == 0;
    }

    public static boolean double2bool(double d) {
        return d == 0.0;
    }

    public static Object if_then_else(boolean p, Object a, Object b) {
        if (p) {
            return a;
        }
        return b;
    }

    public static boolean equalTo(Object o1, Object o2) {
        if (o1.getClass() == o2.getClass()) {
            return o1.equals(o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return ((Number)o1).doubleValue() == ((Number)o2).doubleValue();
        }
        return o1.toString().equals(o2.toString());
    }

    public static boolean notEqualTo(Object o1, Object o2) {
        return !StaticGeometry.equalTo(o1, o2);
    }

    public static boolean lessThan(Object o1, Object o2) {
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return (Integer)o1 < (Integer)o2;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return ((Number)o1).doubleValue() < ((Number)o2).doubleValue();
        }
        return o1.toString().compareTo(o2.toString()) == 0;
    }

    public static boolean greaterThan(Object o1, Object o2) {
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return (Integer)o1 > (Integer)o2;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return ((Number)o1).doubleValue() > ((Number)o2).doubleValue();
        }
        return o1.toString().compareTo(o2.toString()) == 2;
    }

    public static boolean greaterEqualThan(Object o1, Object o2) {
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return (Integer)o1 >= (Integer)o2;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return ((Number)o1).doubleValue() >= ((Number)o2).doubleValue();
        }
        return o1.toString().compareTo(o2.toString()) == 2 || o1.toString().compareTo(o2.toString()) == 1;
    }

    public static boolean lessEqualThan(Object o1, Object o2) {
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return (Integer)o1 <= (Integer)o2;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return ((Number)o1).doubleValue() <= ((Number)o2).doubleValue();
        }
        return o1.toString().compareTo(o2.toString()) == 0 || o1.toString().compareTo(o2.toString()) == 1;
    }

    public static boolean isLike(String s1, String s2) {
        return s1.matches(s2);
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean between(Object o, Object o_low, Object o_high) {
        return StaticGeometry.greaterEqualThan(o, o_low) && StaticGeometry.lessEqualThan(o, o_high);
    }

    public static boolean not(boolean b) {
        return !b;
    }

    public static boolean in2(Object s, Object s1, Object s2) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2);
    }

    public static boolean in3(Object s, Object s1, Object s2, Object s3) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3);
    }

    public static boolean in4(Object s, Object s1, Object s2, Object s3, Object s4) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3) || StaticGeometry.equalTo(s, s4);
    }

    public static boolean in5(Object s, Object s1, Object s2, Object s3, Object s4, Object s5) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3) || StaticGeometry.equalTo(s, s4) || StaticGeometry.equalTo(s, s5);
    }

    public static boolean in6(Object s, Object s1, Object s2, Object s3, Object s4, Object s5, Object s6) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3) || StaticGeometry.equalTo(s, s4) || StaticGeometry.equalTo(s, s5) || StaticGeometry.equalTo(s, s6);
    }

    public static boolean in7(Object s, Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3) || StaticGeometry.equalTo(s, s4) || StaticGeometry.equalTo(s, s5) || StaticGeometry.equalTo(s, s6) || StaticGeometry.equalTo(s, s7);
    }

    public static boolean in8(Object s, Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3) || StaticGeometry.equalTo(s, s4) || StaticGeometry.equalTo(s, s5) || StaticGeometry.equalTo(s, s6) || StaticGeometry.equalTo(s, s7) || StaticGeometry.equalTo(s, s8);
    }

    public static boolean in9(Object s, Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3) || StaticGeometry.equalTo(s, s4) || StaticGeometry.equalTo(s, s5) || StaticGeometry.equalTo(s, s6) || StaticGeometry.equalTo(s, s7) || StaticGeometry.equalTo(s, s8) || StaticGeometry.equalTo(s, s9);
    }

    public static boolean in10(Object s, Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10) {
        return StaticGeometry.equalTo(s, s1) || StaticGeometry.equalTo(s, s2) || StaticGeometry.equalTo(s, s3) || StaticGeometry.equalTo(s, s4) || StaticGeometry.equalTo(s, s5) || StaticGeometry.equalTo(s, s6) || StaticGeometry.equalTo(s, s7) || StaticGeometry.equalTo(s, s8) || StaticGeometry.equalTo(s, s9) || StaticGeometry.equalTo(s, s10);
    }
}

