/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.resources.geometry.XRectangle2D;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.opengis.util.Cloneable;

public class GeneralEnvelope
implements Envelope,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralEnvelope(Envelope envelope) {
        if (envelope instanceof GeneralEnvelope) {
            GeneralEnvelope e = (GeneralEnvelope)envelope;
            this.ordinates = (double[])e.ordinates.clone();
            this.crs = e.crs;
        } else {
            DirectPosition lower = envelope.getLowerCorner();
            DirectPosition upper = envelope.getUpperCorner();
            this.crs = lower.getCoordinateReferenceSystem();
            int dimension = lower.getDimension();
            if (!Utilities.equals(this.crs, upper.getCoordinateReferenceSystem()) || dimension != upper.getDimension()) {
                throw new IllegalArgumentException("Malformed envelope");
            }
            this.ordinates = new double[2 * dimension];
            for (int i = 0; i < dimension; ++i) {
                this.ordinates[i] = lower.getOrdinate(i);
                this.ordinates[i + dimension] = upper.getOrdinate(i);
            }
            this.checkCoherence();
        }
    }

    public GeneralEnvelope(int dimension) {
        this.ordinates = new double[dimension * 2];
    }

    public GeneralEnvelope(double min, double max) {
        this.ordinates = new double[]{min, max};
        this.checkCoherence();
    }

    public GeneralEnvelope(double[] minCP, double[] maxCP) throws MismatchedDimensionException {
        if (minCP.length != maxCP.length) {
            throw new MismatchedDimensionException(Resources.format(98, new Integer(minCP.length), new Integer(maxCP.length)));
        }
        this.ordinates = new double[minCP.length + maxCP.length];
        System.arraycopy(minCP, 0, this.ordinates, 0, minCP.length);
        System.arraycopy(maxCP, 0, this.ordinates, minCP.length, maxCP.length);
        this.checkCoherence();
    }

    public GeneralEnvelope(GeneralDirectPosition minCP, GeneralDirectPosition maxCP) throws MismatchedDimensionException {
        this(minCP.ordinates, maxCP.ordinates);
    }

    public GeneralEnvelope(Rectangle2D rect) {
        this.ordinates = new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
        this.checkCoherence();
    }

    private void checkCoherence() throws IllegalArgumentException {
        int dimension = this.ordinates.length / 2;
        for (int i = 0; i < dimension; ++i) {
            if (this.ordinates[i] <= this.ordinates[dimension + i]) continue;
            throw new IllegalArgumentException(Resources.format(88, new Integer(i)));
        }
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        GeneralDirectPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    public final int getDimension() {
        return this.ordinates.length / 2;
    }

    public DirectPosition getLowerCorner() {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition position = new GeneralDirectPosition(dim);
        System.arraycopy(this.ordinates, 0, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    public DirectPosition getUpperCorner() {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition position = new GeneralDirectPosition(dim);
        System.arraycopy(this.ordinates, dim, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    public final double getMinimum(int dimension) {
        if (dimension < this.ordinates.length / 2) {
            return this.ordinates[dimension];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public final double getMaximum(int dimension) {
        if (dimension >= 0) {
            return this.ordinates[dimension + this.ordinates.length / 2];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public final double getCenter(int dimension) {
        return 0.5 * (this.ordinates[dimension] + this.ordinates[dimension + this.ordinates.length / 2]);
    }

    public final double getLength(int dimension) {
        return this.ordinates[dimension + this.ordinates.length / 2] - this.ordinates[dimension];
    }

    public void setRange(int dimension, double minimum, double maximum) {
        if (minimum > maximum) {
            minimum = maximum = 0.5 * (minimum + maximum);
        }
        if (dimension < 0) {
            throw new ArrayIndexOutOfBoundsException(dimension);
        }
        this.ordinates[dimension + this.ordinates.length / 2] = maximum;
        this.ordinates[dimension] = minimum;
    }

    public void add(GeneralDirectPosition position) throws MismatchedDimensionException {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition.ensureDimensionMatch("position", position.getDimension(), dim);
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (value < this.ordinates[i]) {
                this.ordinates[i] = value;
            }
            if (!(value > this.ordinates[i + dim])) continue;
            this.ordinates[i + dim] = value;
        }
    }

    public void add(GeneralEnvelope envelope) throws MismatchedDimensionException {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        for (int i = 0; i < dim; ++i) {
            double min = envelope.ordinates[i];
            double max = envelope.ordinates[i + dim];
            if (min < this.ordinates[i]) {
                this.ordinates[i] = min;
            }
            if (!(max > this.ordinates[i + dim])) continue;
            this.ordinates[i + dim] = max;
        }
    }

    public boolean contains(GeneralDirectPosition position) throws MismatchedDimensionException {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition.ensureDimensionMatch("point", position.getDimension(), dim);
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (!(value >= this.ordinates[i])) {
                return false;
            }
            if (value <= this.ordinates[i + dim]) continue;
            return false;
        }
        return true;
    }

    public void intersect(GeneralEnvelope envelope) throws MismatchedDimensionException {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        for (int i = 0; i < dim; ++i) {
            double max;
            double min = Math.max(this.ordinates[i], envelope.ordinates[i]);
            if (min > (max = Math.min(this.ordinates[i + dim], envelope.ordinates[i + dim]))) {
                min = max = 0.5 * (min + max);
            }
            this.ordinates[i] = min;
            this.ordinates[i + dim] = max;
        }
    }

    public boolean isEmpty() {
        int dimension = this.ordinates.length / 2;
        for (int i = 0; i < dimension; ++i) {
            if (this.ordinates[i] < this.ordinates[i + dimension]) continue;
            return true;
        }
        return false;
    }

    public GeneralEnvelope getSubEnvelope(int lower, int upper) throws IndexOutOfBoundsException {
        int curDim = this.ordinates.length / 2;
        int newDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(82, "lower", new Integer(lower)));
        }
        if (newDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(82, "upper", new Integer(upper)));
        }
        GeneralEnvelope envelope = new GeneralEnvelope(newDim);
        System.arraycopy(this.ordinates, lower, envelope.ordinates, 0, newDim);
        System.arraycopy(this.ordinates, lower + curDim, envelope.ordinates, newDim, newDim);
        return envelope;
    }

    public GeneralEnvelope getReducedEnvelope(int lower, int upper) throws IndexOutOfBoundsException {
        int curDim = this.ordinates.length / 2;
        int rmvDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(82, "lower", new Integer(lower)));
        }
        if (rmvDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(82, "upper", new Integer(upper)));
        }
        GeneralEnvelope envelope = new GeneralEnvelope(curDim - rmvDim);
        System.arraycopy(this.ordinates, 0, envelope.ordinates, 0, lower);
        System.arraycopy(this.ordinates, lower, envelope.ordinates, upper, curDim - upper);
        return envelope;
    }

    public Rectangle2D toRectangle2D() throws IllegalStateException {
        if (this.ordinates.length == 4) {
            return XRectangle2D.createFromExtremums(this.ordinates[0], this.ordinates[1], this.ordinates[2], this.ordinates[3]);
        }
        throw new IllegalStateException(Resources.format(108, new Integer(this.getDimension())));
    }

    public String toString() {
        return GeneralDirectPosition.toString(this, this.ordinates);
    }

    public int hashCode() {
        int code = GeneralDirectPosition.hashCode(this.ordinates) ^ 0x3B6EC1EC;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralEnvelope that = (GeneralEnvelope)object;
            return Arrays.equals(this.ordinates, that.ordinates) && Utilities.equals(this.crs, that.crs);
        }
        return false;
    }

    public Object clone() {
        try {
            GeneralEnvelope e = (GeneralEnvelope)super.clone();
            e.ordinates = (double[])e.ordinates.clone();
            return e;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

