/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Locale;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.image.io.InputStreamAdapter;
import org.geotools.image.io.LineReader;
import org.geotools.image.io.SimpleImageReader;
import org.geotools.io.LineFormat;
import org.geotools.resources.Utilities;
import org.geotools.resources.gcs.Resources;

public abstract class TextImageReader
extends SimpleImageReader {
    private final int rawImageType;
    private BufferedReader reader;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URLConnection;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$javax$imageio$stream$ImageInputStream;

    protected TextImageReader(ImageReaderSpi provider) {
        this(provider, 4);
    }

    protected TextImageReader(ImageReaderSpi provider, int rawImageType) {
        super(provider);
        this.rawImageType = rawImageType;
    }

    public int getRawDataType(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.rawImageType;
    }

    public Charset getCharset(InputStream input) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).charset : null;
    }

    public LineFormat getLineFormat(int imageIndex) throws IOException {
        Locale locale;
        if (this.originatingProvider instanceof Spi && (locale = ((Spi)this.originatingProvider).locale) != null) {
            return new LineFormat(locale);
        }
        return new LineFormat();
    }

    public double getPadValue(int imageIndex) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).padValue : Double.NaN;
    }

    protected final BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            Object input = this.getInput();
            if (input == null) {
                throw new IllegalStateException(Resources.format(62));
            }
            if (input instanceof BufferedReader) {
                this.reader = (BufferedReader)input;
                return this.reader;
            }
            if (input instanceof Reader) {
                this.reader = new LineReader((Reader)input);
                return this.reader;
            }
            if (input instanceof InputStream) {
                InputStream stream = (InputStream)input;
                this.reader = new LineReader(stream, this.getCharset(stream));
                return this.reader;
            }
            if (input instanceof File) {
                FileInputStream stream = new FileInputStream((File)input);
                this.reader = new LineReader(stream, this.getCharset(stream));
                return this.reader;
            }
            if (input instanceof URL) {
                InputStream stream = ((URL)input).openStream();
                this.reader = new LineReader(stream, this.getCharset(stream));
                return this.reader;
            }
            if (input instanceof URLConnection) {
                InputStream stream = ((URLConnection)input).getInputStream();
                this.reader = new LineReader(stream, this.getCharset(stream));
                return this.reader;
            }
            InputStreamAdapter stream = new InputStreamAdapter((ImageInputStream)input);
            this.reader = new LineReader(stream, this.getCharset(stream));
        }
        return this.reader;
    }

    private void close() {
        if ((this.input instanceof File || this.input instanceof URL) && this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException exception) {
                Utilities.unexpectedException("org.geotools.gcs", "TextImageReader", "close", exception);
            }
        }
        this.reader = null;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.close();
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    static long getStreamPosition(Reader reader) throws IOException {
        return reader instanceof LineReader ? ((LineReader)reader).getPosition() : -1L;
    }

    protected String getPositionString(String message) {
        Object input = this.getInput();
        String file = input instanceof File ? ((File)input).getName() : (input instanceof URL ? ((URL)input).getFile() : null);
        Integer line = this.reader instanceof LineNumberReader ? new Integer(((LineNumberReader)this.reader).getLineNumber()) : null;
        Resources resources = Resources.getResources(null);
        String position = file != null ? (line != null ? resources.getString(11, file, line) : resources.getString(10, file)) : (line != null ? resources.getString(18, line) : null);
        if (position != null) {
            if (message != null) {
                return position + ": " + message;
            }
            return position;
        }
        return message;
    }

    public void reset() {
        this.close();
        super.reset();
    }

    public static abstract class Spi
    extends ImageReaderSpi {
        private static final Class[] INPUT_TYPES = new Class[]{class$java$io$File == null ? (class$java$io$File = TextImageReader.class$("java.io.File")) : class$java$io$File, class$java$net$URL == null ? (class$java$net$URL = TextImageReader.class$("java.net.URL")) : class$java$net$URL, class$java$net$URLConnection == null ? (class$java$net$URLConnection = TextImageReader.class$("java.net.URLConnection")) : class$java$net$URLConnection, class$java$io$Reader == null ? (class$java$io$Reader = TextImageReader.class$("java.io.Reader")) : class$java$io$Reader, class$java$io$InputStream == null ? (class$java$io$InputStream = TextImageReader.class$("java.io.InputStream")) : class$java$io$InputStream, class$javax$imageio$stream$ImageInputStream == null ? (class$javax$imageio$stream$ImageInputStream = TextImageReader.class$("javax.imageio.stream.ImageInputStream")) : class$javax$imageio$stream$ImageInputStream};
        private static final String[] EXTENSIONS = new String[]{"txt", "asc", "dat"};
        protected Charset charset;
        protected Locale locale;
        protected double padValue = Double.NaN;

        public Spi(String name, String mime) {
            if (name != null) {
                this.names = new String[]{name};
            }
            if (mime != null) {
                this.MIMETypes = new String[]{mime};
            }
            this.suffixes = EXTENSIONS;
            this.inputTypes = INPUT_TYPES;
        }

        public boolean canDecodeInput(Object source) throws IOException {
            return this.canDecodeInput(source, 1024);
        }

        public boolean canDecodeInput(Object source, int readAheadLimit) throws IOException {
            Reader input;
            if (source instanceof Reader && (input = (Reader)source).markSupported()) {
                input.mark(readAheadLimit);
                boolean result = this.canDecodeReader(input, readAheadLimit);
                input.reset();
                return result;
            }
            if (source instanceof InputStream) {
                return this.canDecodeInput((InputStream)source, readAheadLimit, false);
            }
            if (source instanceof File) {
                return this.canDecodeInput(new FileInputStream((File)source), readAheadLimit, true);
            }
            if (source instanceof URL) {
                return this.canDecodeInput(((URL)source).openStream(), readAheadLimit, true);
            }
            if (source instanceof URLConnection) {
                return this.canDecodeInput(((URLConnection)source).getInputStream(), readAheadLimit, false);
            }
            if (source instanceof ImageInputStream) {
                return this.canDecodeInput(new InputStreamAdapter((ImageInputStream)source), readAheadLimit, false);
            }
            return false;
        }

        private boolean canDecodeInput(InputStream input, int readAheadLimit, boolean canClose) throws IOException {
            if (!canClose) {
                if (!input.markSupported()) {
                    return false;
                }
                input.mark(readAheadLimit);
            }
            InputStreamReader reader = this.charset != null ? new InputStreamReader(input, this.charset) : new InputStreamReader(input);
            boolean canDecode = this.canDecodeReader(reader, readAheadLimit);
            if (canClose) {
                input.close();
            } else {
                input.reset();
            }
            return canDecode;
        }

        private boolean canDecodeReader(Reader input, int readAheadLimit) throws IOException {
            int lower = 0;
            int upper = 0;
            boolean skipLF = false;
            char[] buffer = new char[readAheadLimit];
            while (upper < buffer.length) {
                int stop = upper + input.read(buffer, upper, Math.min(64, buffer.length - upper));
                if (stop <= upper) {
                    return false;
                }
                block5: do {
                    switch (buffer[upper]) {
                        default: {
                            skipLF = false;
                            continue block5;
                        }
                        case '\r': {
                            skipLF = true;
                            break;
                        }
                        case '\n': {
                            if (!skipLF) break;
                            ++lower;
                            continue block5;
                        }
                    }
                    Boolean canDecode = this.canDecodeLine(new String(buffer, lower, upper - lower));
                    if (canDecode != null) {
                        return canDecode;
                    }
                    lower = upper;
                } while (++upper < stop);
            }
            return false;
        }

        protected Boolean canDecodeLine(String line) {
            if (line.trim().length() != 0) {
                try {
                    LineFormat reader;
                    LineFormat lineFormat = reader = this.locale != null ? new LineFormat(this.locale) : new LineFormat();
                    if (reader.setLine(line) >= 1) {
                        return this.isValueCountAcceptable(reader.getValueCount());
                    }
                }
                catch (ParseException exception) {
                    return Boolean.FALSE;
                }
            }
            return null;
        }

        Boolean isValueCountAcceptable(int count) {
            return Boolean.TRUE;
        }
    }
}

