/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class Hysteresis
extends UntiledOpImage {
    private final double low;
    private final double high;
    private final double padValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Hysteresis(RenderedImage source, ImageLayout layout, Map map, double low, double high, double padValue) {
        super(source, map, layout);
        this.low = low;
        this.high = high;
        this.padValue = padValue;
    }

    protected void computeImage(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        if (!$assertionsDisabled && sources.length != 1) {
            throw new AssertionError();
        }
        Raster source = sources[0];
        Rectangle sourceRect = this.mapDestRect(destRect, 0);
        sourceRect = sourceRect.intersection(source.getBounds());
        RandomIter iter = RandomIterFactory.create((Raster)source, (Rectangle)sourceRect);
        int minX = destRect.x;
        int minY = destRect.y;
        int maxX = destRect.width + minX;
        int maxY = destRect.height + minY;
        int w = this.width - 1;
        int h = this.height - 1;
        boolean[] accepted = new boolean[destRect.width * destRect.height];
        boolean[] rejected = new boolean[destRect.width * destRect.height];
        int band = source.getNumBands();
        while (--band >= 0) {
            boolean changed;
            int index = 0;
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    double current = iter.getSampleDouble(x, y, band);
                    accepted[index] = !(current < this.high);
                    rejected[index] = !(current >= this.low);
                    ++index;
                }
            }
            if (!$assertionsDisabled && index != accepted.length) {
                throw new AssertionError();
            }
            int sign = 1;
            do {
                int stop;
                changed = false;
                if (sign >= 0) {
                    index = 0;
                    stop = accepted.length;
                } else {
                    index = accepted.length - 1;
                    stop = -1;
                }
                while (index != stop) {
                    if (!accepted[index] && !rejected[index]) {
                        int check;
                        int y = index / this.width;
                        int x = index % this.width;
                        if (x != 0 && (accepted[check = index - 1] && !rejected[check] || y != 0 && accepted[check = index - 1 - this.width] && !rejected[check] || y != h && accepted[check = index - 1 + this.width] && !rejected[check]) || x != w && (accepted[check = index + 1] && !rejected[check] || y != 0 && accepted[check = index + 1 - this.width] && !rejected[check] || y != h && accepted[check = index + 1 + this.width] && !rejected[check]) || y != 0 && accepted[check = index - this.width] && !rejected[check] || y != w && accepted[check = index + this.width] && !rejected[check]) {
                            accepted[index] = true;
                            changed = true;
                        }
                    }
                    index += sign;
                }
                sign = -sign;
            } while (changed);
            index = 0;
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    dest.setSample(x, y, band, accepted[index++] ? iter.getSampleDouble(x, y, band) : this.padValue);
                }
            }
            if (!$assertionsDisabled && index != accepted.length) {
                throw new AssertionError();
            }
        }
        iter.done();
    }

    static {
        $assertionsDisabled = !Hysteresis.class.desiredAssertionStatus();
    }
}

