/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import javax.swing.event.EventListenerList;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.map.event.MapLayerListener;
import org.geotools.styling.Style;

public class DefaultMapLayer
implements MapLayer {
    protected FeatureSource featureSource;
    protected Style style;
    protected Query query = Query.ALL;
    protected String title;
    protected boolean visible;
    protected EventListenerList listenerList = null;
    protected FeatureListener sourceListener = new FeatureListener(){

        public void changed(FeatureEvent featureEvent) {
            DefaultMapLayer.this.fireMapLayerListenerLayerChanged(new MapLayerEvent(DefaultMapLayer.this, 3));
        }
    };

    public DefaultMapLayer(FeatureSource featureSource, Style style, String title) {
        if (featureSource == null || style == null || title == null) {
            throw new NullPointerException();
        }
        featureSource.addFeatureListener(this.sourceListener);
        this.featureSource = featureSource;
        this.style = style;
        this.title = title;
        this.visible = true;
    }

    public DefaultMapLayer(FeatureSource featureSource, Style style) {
        this(featureSource, style, "");
    }

    public DefaultMapLayer(FeatureCollection collection, Style style, String title) {
        this(DataUtilities.source(collection), style, title);
    }

    public DefaultMapLayer(FeatureCollection collection, Style style) {
        this(DataUtilities.source(collection), style, "");
    }

    public FeatureSource getFeatureSource() {
        return this.featureSource;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException();
        }
        this.style = style;
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 4));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException();
        }
        this.title = title;
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 2));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        MapLayerEvent event = new MapLayerEvent(this, 1);
        if (visible) {
            this.fireMapLayerListenerLayerShown(event);
        } else {
            this.fireMapLayerListenerLayerHidden(event);
        }
    }

    public Query getQuery() {
        return this.query == Query.ALL ? this.query : new DefaultQuery(this.query.getTypeName(), this.query.getFilter(), this.query.getMaxFeatures(), this.query.getPropertyNames(), this.query.getHandle());
    }

    public void setQuery(Query query) {
        if (query == null) {
            throw new NullPointerException("must provide a Query. Do you mean Query.ALL?");
        }
        this.query = new DefaultQuery(query.getTypeName(), query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 5));
    }

    public synchronized void addMapLayerListener(MapLayerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(MapLayerListener.class, listener);
    }

    public synchronized void removeMapLayerListener(MapLayerListener listener) {
        this.listenerList.remove(MapLayerListener.class, listener);
    }

    private void fireMapLayerListenerLayerChanged(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapLayerListener == null ? DefaultMapLayer.class$("org.geotools.map.event.MapLayerListener") : class$org$geotools$map$event$MapLayerListener)) continue;
            ((MapLayerListener)listeners[i + 1]).layerChanged(event);
        }
    }

    private void fireMapLayerListenerLayerShown(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapLayerListener == null ? DefaultMapLayer.class$("org.geotools.map.event.MapLayerListener") : class$org$geotools$map$event$MapLayerListener)) continue;
            ((MapLayerListener)listeners[i + 1]).layerShown(event);
        }
    }

    private void fireMapLayerListenerLayerHidden(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapLayerListener == null ? DefaultMapLayer.class$("org.geotools.map.event.MapLayerListener") : class$org$geotools$map$event$MapLayerListener)) continue;
            ((MapLayerListener)listeners[i + 1]).layerHidden(event);
        }
    }
}

