/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import org.geotools.measure.AngleFormat;
import org.geotools.resources.ClassChanger;

public class Angle
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1158747349433104534L;
    private static Reference format;
    private final double theta;

    public Angle(double theta) {
        this.theta = theta;
    }

    public Angle(String string) throws NumberFormatException {
        try {
            Angle theta = (Angle)Angle.getAngleFormat().parseObject(string);
            if (!this.getClass().isAssignableFrom(theta.getClass())) {
                throw new NumberFormatException();
            }
            this.theta = theta.theta;
        }
        catch (ParseException exception) {
            NumberFormatException e = new NumberFormatException(exception.getLocalizedMessage());
            e.initCause(exception);
            throw e;
        }
    }

    public double degrees() {
        return this.theta;
    }

    public double radians() {
        return Math.toRadians(this.theta);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.theta);
        return (int)code ^ (int)(code >>> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            Angle that = (Angle)object;
            return Double.doubleToLongBits(this.theta) == Double.doubleToLongBits(that.theta);
        }
        return false;
    }

    public int compareTo(Object that) {
        return Double.compare(this.theta, ((Angle)that).theta);
    }

    public String toString() {
        return Angle.getAngleFormat().format(this, new StringBuffer(), null).toString();
    }

    private static synchronized Format getAngleFormat() {
        Format angleFormat;
        if (format != null && (angleFormat = (Format)format.get()) != null) {
            return angleFormat;
        }
        AngleFormat newFormat = new AngleFormat("D\ufffdMM.m'", Locale.US);
        format = new SoftReference<AngleFormat>(newFormat);
        return newFormat;
    }

    static {
        ClassChanger.register(new ClassChanger(Angle.class, Double.class){

            protected Number convert(Comparable o) {
                return new Double(((Angle)o).theta);
            }

            protected Comparable inverseConvert(Number value) {
                return new Angle(value.doubleValue());
            }
        });
    }
}

