/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.awt.geom.Rectangle2D;
import org.geotools.metadata.iso.extent.GeographicExtentImpl;
import org.opengis.metadata.extent.GeographicBoundingBox;

public class GeographicBoundingBoxImpl
extends GeographicExtentImpl
implements GeographicBoundingBox {
    private static final long serialVersionUID = -3278089380004172514L;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public GeographicBoundingBoxImpl() {
    }

    public GeographicBoundingBoxImpl(Rectangle2D bounds) {
        this(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    public GeographicBoundingBoxImpl(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        super(true);
        this.setWestBoundLongitude(westBoundLongitude);
        this.setEastBoundLongitude(eastBoundLongitude);
        this.setSouthBoundLatitude(southBoundLatitude);
        this.setNorthBoundLatitude(northBoundLatitude);
    }

    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public synchronized void setWestBoundLongitude(double newValue) {
        this.checkWritePermission();
        this.westBoundLongitude = newValue;
    }

    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public synchronized void setEastBoundLongitude(double newValue) {
        this.checkWritePermission();
        this.eastBoundLongitude = newValue;
    }

    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public synchronized void setSouthBoundLatitude(double newValue) {
        this.checkWritePermission();
        this.southBoundLatitude = newValue;
    }

    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public synchronized void setNorthBoundLatitude(double newValue) {
        this.checkWritePermission();
        this.northBoundLatitude = newValue;
    }

    protected void freeze() {
        super.freeze();
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            GeographicBoundingBoxImpl that = (GeographicBoundingBoxImpl)object;
            return Double.doubleToLongBits(this.southBoundLatitude) == Double.doubleToLongBits(that.southBoundLatitude) && Double.doubleToLongBits(this.northBoundLatitude) == Double.doubleToLongBits(that.northBoundLatitude) && Double.doubleToLongBits(this.eastBoundLongitude) == Double.doubleToLongBits(that.eastBoundLongitude) && Double.doubleToLongBits(this.westBoundLongitude) == Double.doubleToLongBits(that.westBoundLongitude);
        }
        return false;
    }

    public synchronized int hashCode() {
        long code = -3278089380004172514L;
        code ^= Double.doubleToLongBits(this.southBoundLatitude);
        code = 37L * code + Double.doubleToLongBits(this.northBoundLatitude);
        code = 37L * code + Double.doubleToLongBits(this.eastBoundLongitude);
        code = 37L * code + Double.doubleToLongBits(this.westBoundLongitude);
        return (int)code ^ (int)(code >>> 32);
    }

    public String toString() {
        return super.toString();
    }
}

