/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.Scope;

public class DataQualityImpl
extends MetadataEntity
implements DataQuality {
    private static final long serialVersionUID = 7964896551368382214L;
    private Scope scope;
    private Collection reports;
    private Lineage lineage;

    public DataQualityImpl() {
    }

    public DataQualityImpl(Scope scope) {
        this.setScope(scope);
    }

    public Scope getScope() {
        return this.scope;
    }

    public synchronized void setScope(Scope newValue) {
        this.checkWritePermission();
        this.scope = newValue;
    }

    public synchronized Collection getReports() {
        this.reports = this.nonNullCollection(this.reports, Element.class);
        return this.reports;
    }

    public synchronized void setReports(Collection newValues) {
        this.reports = this.copyCollection(newValues, this.reports, Element.class);
    }

    public Lineage getLineage() {
        return this.lineage;
    }

    public synchronized void setLineage(Lineage newValue) {
        this.checkWritePermission();
        this.lineage = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.scope = (Scope)DataQualityImpl.unmodifiable(this.scope);
        this.reports = (Collection)DataQualityImpl.unmodifiable(this.reports);
        this.lineage = (Lineage)DataQualityImpl.unmodifiable(this.lineage);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            DataQualityImpl that = (DataQualityImpl)object;
            return Utilities.equals(this.scope, that.scope) && Utilities.equals(this.reports, that.reports) && Utilities.equals(this.lineage, that.lineage);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 0;
        if (this.scope != null) {
            code ^= this.scope.hashCode();
        }
        if (this.lineage != null) {
            code ^= this.lineage.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.scope);
    }
}

