/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.util.Arrays;
import javax.units.Unit;
import org.geotools.metadata.iso.quality.ResultImpl;
import org.geotools.resources.Utilities;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.util.InternationalString;

public class QuantitativeResultImpl
extends ResultImpl
implements QuantitativeResult {
    private static final long serialVersionUID = -3430567391539903195L;
    private double[] values;
    private Class valueType;
    private Unit valueUnit;
    private InternationalString errorStatistic;

    public QuantitativeResultImpl() {
    }

    public QuantitativeResultImpl(double[] values) {
        this.setValues(values);
    }

    public synchronized double[] getValues() {
        if (this.isModifiable()) {
            return this.values;
        }
        return (double[])this.values.clone();
    }

    public synchronized void setValues(double[] newValues) {
        this.checkWritePermission();
        this.values = (double[])newValues.clone();
    }

    public Class getValueType() {
        return this.valueType;
    }

    public synchronized void setValueType(Class newValue) {
        this.checkWritePermission();
        this.valueType = newValue;
    }

    public Unit getValueUnit() {
        return this.valueUnit;
    }

    public synchronized void setValueUnit(Unit newValue) {
        this.checkWritePermission();
        this.valueUnit = newValue;
    }

    public InternationalString getErrorStatistic() {
        return this.errorStatistic;
    }

    public synchronized void setErrorStatistic(InternationalString newValue) {
        this.checkWritePermission();
        this.errorStatistic = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.values = (double[])QuantitativeResultImpl.unmodifiable(this.values);
        this.valueType = (Class)QuantitativeResultImpl.unmodifiable(this.valueType);
        this.valueUnit = (Unit)QuantitativeResultImpl.unmodifiable(this.valueUnit);
        this.errorStatistic = (InternationalString)QuantitativeResultImpl.unmodifiable(this.errorStatistic);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            QuantitativeResultImpl that = (QuantitativeResultImpl)object;
            return Arrays.equals(this.values, that.values) && Utilities.equals(this.valueType, that.valueType) && Utilities.equals(this.valueUnit, that.valueUnit) && Utilities.equals(this.errorStatistic, that.errorStatistic);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 557434149;
        if (this.valueType != null) {
            code ^= this.valueType.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.valueType);
    }
}

