/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.io.TableWriter;
import org.geotools.measure.Measure;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.wkt.AbstractConsole;
import org.geotools.referencing.wkt.Parser;
import org.geotools.referencing.wkt.Preprocessor;
import org.geotools.resources.Arguments;
import org.geotools.resources.cts.Resources;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class Console
extends AbstractConsole {
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
    private final String numberSeparator;
    private final CoordinateOperationFactory factory = FactoryFinder.getCoordinateOperationFactory(null);
    private CoordinateReferenceSystem sourceCRS;
    private CoordinateReferenceSystem targetCRS;
    private DirectPosition sourcePosition;
    private DirectPosition targetPosition;
    private MathTransform transform;
    private double[] tolerance;
    private transient Exception lastError;

    public Console() {
        super(new Preprocessor(new Parser()));
        this.numberSeparator = Console.getNumberSeparator(this.numberFormat);
    }

    public Console(LineNumberReader in) {
        super(new Preprocessor(new Parser()), in);
        this.numberSeparator = Console.getNumberSeparator(this.numberFormat);
    }

    private static String getNumberSeparator(NumberFormat numberFormat) {
        char decimalSeparator;
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(6);
        numberFormat.setMaximumFractionDigits(6);
        if (numberFormat instanceof DecimalFormat && (decimalSeparator = ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator()) == ',') {
            return ";";
        }
        return ",";
    }

    public static void main(String[] args) {
        Console console;
        LineNumberReader input;
        Arguments arguments = new Arguments(args);
        String load = arguments.getOptionalString("-load");
        String file = arguments.getOptionalString("-file");
        args = arguments.getRemainingArguments(0);
        Locale.setDefault(arguments.locale);
        if (file == null) {
            input = null;
            console = new Console();
        } else {
            try {
                input = new LineNumberReader(new FileReader(file));
                console = new Console(input);
                console.setPrompt(null);
            }
            catch (IOException exception) {
                System.err.println(exception.getLocalizedMessage());
                return;
            }
        }
        if (load != null) {
            try {
                LineNumberReader in = new LineNumberReader(new FileReader(load));
                try {
                    console.loadDefinitions(in);
                }
                catch (ParseException exception) {
                    console.reportError(exception);
                    in.close();
                    return;
                }
                in.close();
            }
            catch (IOException exception) {
                console.reportError(exception);
                return;
            }
        }
        console.run();
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException exception) {
                console.reportError(exception);
            }
        }
    }

    protected void execute(String instruction) throws IOException, ParseException, FactoryException, TransformException {
        StringTokenizer keywords;
        String value = null;
        int i = instruction.indexOf(61);
        if (i >= 0) {
            value = instruction.substring(i + 1).trim();
            instruction = instruction.substring(0, i).trim();
        }
        if ((keywords = new StringTokenizer(instruction)).hasMoreTokens()) {
            String key0 = keywords.nextToken();
            if (!keywords.hasMoreTokens()) {
                if (key0.equalsIgnoreCase("exit")) {
                    if (value != null) {
                        throw Console.unexpectedArgument("exit");
                    }
                    this.stop();
                    return;
                }
                if (key0.equalsIgnoreCase("stacktrace")) {
                    if (value != null) {
                        throw Console.unexpectedArgument("stacktrace");
                    }
                    if (this.lastError != null) {
                        this.lastError.printStackTrace(this.err);
                    }
                    return;
                }
                if (key0.equalsIgnoreCase("transform")) {
                    this.transform = (MathTransform)this.parseObject(value, MathTransform.class);
                    this.sourceCRS = null;
                    this.targetCRS = null;
                    return;
                }
            } else {
                String key1 = keywords.nextToken();
                if (!keywords.hasMoreTokens()) {
                    if (key0.equalsIgnoreCase("print")) {
                        if (value != null) {
                            throw Console.unexpectedArgument("print");
                        }
                        if (key1.equalsIgnoreCase("set")) {
                            this.printDefinitions();
                            return;
                        }
                        if (key1.equalsIgnoreCase("crs")) {
                            this.printCRS();
                            return;
                        }
                        if (key1.equalsIgnoreCase("pts")) {
                            this.printPts();
                            return;
                        }
                    }
                    if (key0.equalsIgnoreCase("set")) {
                        this.addDefinition(key1, value);
                        return;
                    }
                    if (key0.equalsIgnoreCase("test") && key1.equalsIgnoreCase("tolerance")) {
                        this.tolerance = this.parseVector(value);
                        return;
                    }
                    if (key1.equalsIgnoreCase("crs")) {
                        if (key0.equalsIgnoreCase("source")) {
                            this.sourceCRS = (CoordinateReferenceSystem)this.parseObject(value, CoordinateReferenceSystem.class);
                            this.transform = null;
                            return;
                        }
                        if (key0.equalsIgnoreCase("target")) {
                            this.targetCRS = (CoordinateReferenceSystem)this.parseObject(value, CoordinateReferenceSystem.class);
                            this.transform = null;
                            return;
                        }
                    }
                    if (key1.equalsIgnoreCase("pt")) {
                        if (key0.equalsIgnoreCase("source")) {
                            this.sourcePosition = new GeneralDirectPosition(this.parseVector(value));
                            return;
                        }
                        if (key0.equalsIgnoreCase("target")) {
                            this.targetPosition = new GeneralDirectPosition(this.parseVector(value));
                            if (this.tolerance != null && this.sourcePosition != null) {
                                this.update();
                                if (this.transform != null) {
                                    this.test();
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
        throw new ParseException("Illegal instruction \"" + instruction + "\".", 0);
    }

    private void printCRS() throws FactoryException, IOException {
        TableWriter table = new TableWriter(this.out, " \u2502 ");
        table.setMultiLinesCells(true);
        int separator = 9472;
        if (this.sourceCRS != null || this.targetCRS != null) {
            table.writeHorizontalSeparator();
            table.write("Source CRS");
            table.nextColumn();
            table.write("Target CRS");
            table.nextLine();
            table.writeHorizontalSeparator();
            if (this.sourceCRS != null) {
                table.write(this.parser.format(this.sourceCRS));
            }
            table.nextColumn();
            if (this.targetCRS != null) {
                table.write(this.parser.format(this.targetCRS));
            }
            table.nextLine();
            separator = 9552;
        }
        this.update();
        if (this.transform != null) {
            table.nextLine((char)separator);
            table.write("Math transform");
            table.nextColumn();
            table.write("Inverse transform");
            table.nextLine();
            table.writeHorizontalSeparator();
            table.write(this.parser.format(this.transform));
            table.nextColumn();
            try {
                table.write(this.parser.format(this.transform.inverse()));
            }
            catch (NoninvertibleTransformException exception) {
                table.write(exception.getLocalizedMessage());
            }
            table.nextLine();
        }
        table.writeHorizontalSeparator();
        table.flush();
    }

    private void printPts() throws FactoryException, TransformException, IOException {
        String targetException;
        DirectPosition transformedTarget;
        DirectPosition transformedSource;
        block9: {
            this.update();
            transformedSource = null;
            transformedTarget = null;
            targetException = null;
            if (this.transform != null) {
                if (this.sourcePosition != null) {
                    transformedSource = this.transform.transform(this.sourcePosition, null);
                }
                if (this.targetPosition != null) {
                    try {
                        transformedTarget = this.transform.inverse().transform(this.targetPosition, null);
                    }
                    catch (NoninvertibleTransformException exception) {
                        targetException = exception.getLocalizedMessage();
                        if (this.sourcePosition == null) break block9;
                        GeneralDirectPosition p = new GeneralDirectPosition(this.sourcePosition.getDimension());
                        transformedTarget = p;
                        Arrays.fill(p.ordinates, Double.NaN);
                    }
                }
            }
        }
        TableWriter table = new TableWriter(this.out, 0);
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.setAlignment(2);
        if (this.sourcePosition != null) {
            table.write("Source point:");
            this.print(this.sourcePosition, table);
            this.print(transformedSource, table);
            table.nextLine();
        }
        if (this.targetPosition != null) {
            table.write("Target point:");
            this.print(transformedTarget, table);
            this.print(this.targetPosition, table);
            table.nextLine();
        }
        if (this.sourceCRS != null && this.targetCRS != null) {
            table.write("Distance:");
            this.printDistance(this.sourceCRS, this.sourcePosition, transformedTarget, table);
            this.printDistance(this.targetCRS, this.targetPosition, transformedSource, table);
            table.nextLine();
        }
        table.writeHorizontalSeparator();
        table.flush();
        if (targetException != null) {
            this.out.write(targetException);
            this.out.write(this.lineSeparator);
        }
    }

    private void print(DirectPosition point, TableWriter table) throws IOException {
        if (point != null) {
            table.nextColumn();
            table.write("  (");
            double[] coords = point.getCoordinates();
            for (int i = 0; i < coords.length; ++i) {
                if (i != 0) {
                    table.write(", ");
                }
                table.nextColumn();
                table.write(this.numberFormat.format(coords[i]));
            }
            table.write(41);
        }
    }

    private void printDistance(CoordinateReferenceSystem crs, DirectPosition position1, DirectPosition position2, TableWriter table) throws IOException {
        if (position1 == null) {
            return;
        }
        int i = crs.getCoordinateSystem().getDimension();
        while (--i >= 0) {
            table.nextColumn();
        }
        if (position2 != null && crs instanceof AbstractCRS) {
            try {
                Measure distance = ((AbstractCRS)crs).distance(position1.getCoordinates(), position2.getCoordinates());
                table.setAlignment(2);
                table.write(this.numberFormat.format(distance.doubleValue()));
                table.write("  ");
                table.nextColumn();
                table.write(String.valueOf(distance.getUnit()));
                table.setAlignment(0);
                return;
            }
            catch (UnsupportedOperationException ignore) {
                // empty catch block
            }
        }
        table.nextColumn();
    }

    protected void test() throws TransformException, MismatchedDimensionException {
        int targetDim;
        DirectPosition transformedSource = this.transform.transform(this.sourcePosition, null);
        int sourceDim = transformedSource.getDimension();
        if (sourceDim != (targetDim = this.targetPosition.getDimension())) {
            throw new MismatchedDimensionException(Resources.format(98, new Integer(sourceDim), new Integer(targetDim)));
        }
        for (int i = 0; i < sourceDim; ++i) {
            if (Math.abs(transformedSource.getOrdinate(i) - this.targetPosition.getOrdinate(i)) <= this.tolerance[Math.min(i, this.tolerance.length - 1)]) continue;
            throw new TransformException("Transformation doesn't produce the expected value.");
        }
    }

    private static String removeDelimitors(String text, char start, char end) {
        int endPos = (text = text.trim()).length() - 1;
        if (endPos >= 1 && text.charAt(0) == start && text.charAt(endPos) == end) {
            text = text.substring(1, endPos).trim();
        }
        return text;
    }

    private double[] parseVector(String text) throws ParseException {
        text = Console.removeDelimitors(text, '(', ')');
        StringTokenizer st = new StringTokenizer(text, this.numberSeparator);
        double[] values = new double[st.countTokens()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.numberFormat.parse(st.nextToken().trim()).doubleValue();
        }
        return values;
    }

    private void update() throws FactoryException {
        if (this.transform == null && this.sourceCRS != null && this.targetCRS != null) {
            this.transform = this.factory.createOperation(this.sourceCRS, this.targetCRS).getMathTransform();
        }
    }

    private static ParseException unexpectedArgument(String instruction) {
        return new ParseException("Unexpected argument for instruction \"" + instruction + "\".", 0);
    }

    protected void reportError(Exception exception) {
        super.reportError(exception);
        this.lastError = exception;
    }
}

