/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Map;
import javax.units.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    protected final CoordinateSystem coordinateSystem;

    public AbstractCRS(Map properties, CoordinateSystem cs) {
        super(properties);
        AbstractCRS.ensureNonNull("cs", cs);
        this.coordinateSystem = cs;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final Unit getUnit() {
        Unit unit = null;
        int i = this.coordinateSystem.getDimension();
        while (--i >= 0) {
            Unit candidate = this.coordinateSystem.getAxis(i).getUnit();
            if (candidate == null) continue;
            if (unit == null) {
                unit = candidate;
                continue;
            }
            if (unit.equals((Object)candidate)) continue;
            return null;
        }
        return unit;
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (this.coordinateSystem instanceof AbstractCS) {
            return ((AbstractCS)this.coordinateSystem).distance(coord1, coord2);
        }
        throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractCRS that = (AbstractCRS)object;
            return AbstractCRS.equals((IdentifiedObject)this.coordinateSystem, (IdentifiedObject)that.coordinateSystem, compareMetadata);
        }
        return false;
    }

    public int hashCode() {
        return 0x3D90441 ^ this.coordinateSystem.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        Unit unit = this.getUnit();
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT();
        }
        return super.formatWKT(formatter);
    }
}

