/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Map;
import javax.units.Unit;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.wkt.Formatter;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;

public class DefaultGeocentricCRS
extends AbstractSingleCRS
implements GeocentricCRS {
    private static final long serialVersionUID = 6784642848287659827L;
    public static final DefaultGeocentricCRS CARTESIAN = new DefaultGeocentricCRS("Cartesian", (GeodeticDatum)DefaultGeodeticDatum.WGS84, (CartesianCS)DefaultCartesianCS.GEOCENTRIC);
    public static final DefaultGeocentricCRS SPHERICAL = new DefaultGeocentricCRS("Spherical", (GeodeticDatum)DefaultGeodeticDatum.WGS84, (SphericalCS)DefaultSphericalCS.GEOCENTRIC);

    public DefaultGeocentricCRS(String name, GeodeticDatum datum, CartesianCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeocentricCRS(String name, GeodeticDatum datum, SphericalCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeocentricCRS(Map properties, GeodeticDatum datum, CartesianCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public DefaultGeocentricCRS(Map properties, GeodeticDatum datum, SphericalCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public int hashCode() {
        return 0x54149733 ^ super.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        Unit unit = this.getUnit();
        formatter.append((IdentifiedObject)this.datum);
        formatter.append((IdentifiedObject)((GeodeticDatum)this.datum).getPrimeMeridian());
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT();
        }
        return "GEOCCS";
    }
}

