/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.opengis.util.InternationalString;

public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = -98032729598205972L;
    public static final String FORMULA_PROPERTY = "formula";
    private static final String[] LOCALIZABLES = new String[]{"formula"};
    private final InternationalString formula;
    protected final int sourceDimensions;
    protected final int targetDimensions;
    private final ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(MathTransform transform) {
        this(DefaultOperationMethod.getProperties(transform), transform.getSourceDimensions(), transform.getTargetDimensions(), DefaultOperationMethod.getDescriptor(transform));
    }

    private static Map getProperties(MathTransform transform) {
        Map<String, String> properties;
        DefaultOperationMethod.ensureNonNull("transform", transform);
        if (transform instanceof AbstractMathTransform) {
            ParameterDescriptorGroup descriptor = ((AbstractMathTransform)transform).getParameterDescriptors();
            properties = new HashMap<String, String>(DefaultOperationMethod.getProperties((IdentifiedObject)descriptor));
            properties.put("name", descriptor.getName().getCode());
        } else {
            properties = Collections.singletonMap("name", Resources.format(59));
        }
        return properties;
    }

    private static ParameterDescriptorGroup getDescriptor(MathTransform transform) {
        ParameterDescriptorGroup descriptor = null;
        if (transform instanceof AbstractMathTransform) {
            descriptor = ((AbstractMathTransform)transform).getParameterDescriptors();
        }
        return descriptor;
    }

    public DefaultOperationMethod(Map properties, int sourceDimensions, int targetDimensions, GeneralParameterDescriptor[] parameters) {
        this(properties, sourceDimensions, targetDimensions, DefaultOperationMethod.toGroup(properties, parameters));
    }

    private static ParameterDescriptorGroup toGroup(Map properties, GeneralParameterDescriptor[] parameters) {
        return parameters == null || parameters.length == 0 ? null : new DefaultParameterDescriptorGroup(properties, parameters);
    }

    public DefaultOperationMethod(Map properties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        this(properties, new HashMap(), sourceDimensions, targetDimensions, parameters);
    }

    private DefaultOperationMethod(Map properties, Map subProperties, int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        super(properties, subProperties, LOCALIZABLES);
        this.formula = (InternationalString)subProperties.get(FORMULA_PROPERTY);
        this.parameters = parameters;
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
        DefaultOperationMethod.ensurePositive("sourceDimensions", sourceDimensions);
        DefaultOperationMethod.ensurePositive("targetDimensions", targetDimensions);
    }

    private static void ensurePositive(String name, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException(Resources.format(82, name, new Integer(value)));
        }
    }

    public InternationalString getFormula() {
        return this.formula;
    }

    public int getSourceDimensions() {
        return this.sourceDimensions;
    }

    public int getTargetDimensions() {
        return this.targetDimensions;
    }

    public ParameterDescriptorGroup getParameters() {
        return this.parameters != null ? this.parameters : Parameters.EMPTY_GROUP;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultOperationMethod that = (DefaultOperationMethod)object;
            if (this.sourceDimensions == that.sourceDimensions && this.targetDimensions == that.targetDimensions && DefaultOperationMethod.equals((IdentifiedObject)this.parameters, (IdentifiedObject)that.parameters, compareMetadata)) {
                return !compareMetadata || Utilities.equals(this.formula, that.formula);
            }
        }
        return false;
    }

    public int hashCode() {
        int code = 2012209132 + this.sourceDimensions + 37 * this.targetDimensions;
        if (this.parameters != null) {
            code = code * 37 + this.parameters.hashCode();
        }
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        return "PROJECTION";
    }

    public static void checkDimensions(OperationMethod method, MathTransform transform) throws MismatchedDimensionException {
        if (method != null && transform != null) {
            String name;
            int expected;
            int actual = transform.getSourceDimensions();
            if (actual != (expected = method.getSourceDimensions())) {
                name = "sourceDimensions";
            } else {
                actual = transform.getTargetDimensions();
                if (actual != (expected = method.getTargetDimensions())) {
                    name = "targetDimensions";
                } else {
                    return;
                }
            }
            throw new IllegalArgumentException(Resources.format(99, name, new Integer(actual), new Integer(expected)));
        }
    }
}

