/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class TransverseMercator
extends MapProjection {
    private final double esp;
    private final double ml0;
    private final double en0;
    private final double en1;
    private final double en2;
    private final double en3;
    private final double en4;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;
    private static final double TOL = 1.0E-11;
    static /* synthetic */ Class class$org$opengis$referencing$operation$CylindricalProjection;
    static /* synthetic */ Class class$org$geotools$referencing$operation$projection$TransverseMercator;

    TransverseMercator(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
        super(parameters, expected);
        this.esp = this.excentricitySquared / (1.0 - this.excentricitySquared);
        this.en0 = 1.0 - this.excentricitySquared * (0.25 + this.excentricitySquared * (0.046875 + this.excentricitySquared * (0.01953125 + this.excentricitySquared * 0.01068115234375)));
        this.en1 = this.excentricitySquared * (0.75 - this.excentricitySquared * (0.046875 + this.excentricitySquared * (0.01953125 + this.excentricitySquared * 0.01068115234375)));
        double t = this.excentricitySquared * this.excentricitySquared;
        this.en2 = t * (0.46875 - this.excentricitySquared * (0.013020833333333334 + this.excentricitySquared * 0.007120768229166667));
        this.en3 = (t *= this.excentricitySquared) * (0.3645833333333333 - this.excentricitySquared * 0.005696614583333333);
        this.en4 = t * this.excentricitySquared * 0.3076171875;
        this.ml0 = this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double sinphi = Math.sin(y);
        double cosphi = Math.cos(y);
        double t = Math.abs(cosphi) > 1.0E-6 ? sinphi / cosphi : 0.0;
        t *= t;
        double al = cosphi * x;
        double als = al * al;
        double n = this.esp * cosphi * cosphi;
        y = this.mlfn(y, sinphi, cosphi) - this.ml0 + sinphi * (al /= Math.sqrt(1.0 - this.excentricitySquared * sinphi * sinphi)) * x * 0.5 * (1.0 + 0.08333333333333333 * als * (5.0 - t + n * (9.0 + 4.0 * n) + 0.03333333333333333 * als * (61.0 + t * (t - 58.0) + n * (270.0 - 330.0 * t) + 0.017857142857142856 * als * (1385.0 + t * (t * (543.0 - t) - 3111.0)))));
        x = al * (1.0 + 0.16666666666666666 * als * (1.0 - t + n + 0.05 * als * (5.0 + t * (t - 18.0) + n * (14.0 - 58.0 * t) + 0.023809523809523808 * als * (61.0 + t * (t * (179.0 - t) - 479.0)))));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi = this.inv_mlfn(this.ml0 + y);
        if (Math.abs(phi) >= 1.5707963267948966) {
            y = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            x = 0.0;
        } else {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double t = Math.abs(cosphi) > 1.0E-6 ? sinphi / cosphi : 0.0;
            double n = this.esp * cosphi * cosphi;
            double con = 1.0 - this.excentricitySquared * sinphi * sinphi;
            double d = x * Math.sqrt(con);
            con *= t;
            t *= t;
            double ds = d * d;
            y = phi - con * ds / (1.0 - this.excentricitySquared) * 0.5 * (1.0 - ds * 0.08333333333333333 * (5.0 + t * (3.0 - 9.0 * n) + n * (1.0 - 4.0 * n) - ds * 0.03333333333333333 * (61.0 + t * (90.0 - 252.0 * n + 45.0 * t) + 46.0 * n - ds * 0.017857142857142856 * (1385.0 + t * (3633.0 + t * (4095.0 + 1574.0 * t))))));
            x = d * (1.0 - ds * 0.16666666666666666 * (1.0 + 2.0 * t + n - ds * 0.05 * (5.0 + t * (28.0 + 24.0 * t + 8.0 * n) + 6.0 * n - ds * 0.023809523809523808 * (61.0 + t * (662.0 + t * (1320.0 + 720.0 * t)))))) / cosphi;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected double getToleranceForAssertions(double longitude, double latitude) {
        if (Math.abs(longitude - this.centralMeridian) > 0.26) {
            return 2.5;
        }
        if (Math.abs(longitude - this.centralMeridian) > 0.22) {
            return 1.0;
        }
        if (Math.abs(longitude - this.centralMeridian) > 0.17) {
            return 0.5;
        }
        return 1.0E-6;
    }

    private final double mlfn(double phi, double sphi, double cphi) {
        cphi *= sphi;
        sphi *= sphi;
        return this.en0 * phi - cphi * (this.en1 + sphi * (this.en2 + sphi * (this.en3 + sphi * this.en4)));
    }

    private final double inv_mlfn(double arg) throws ProjectionException {
        double t;
        double k = 1.0 / (1.0 - this.excentricitySquared);
        double phi = arg;
        int i = 15;
        do {
            if (--i < 0) {
                throw new ProjectionException(Resources.format(109));
            }
            double s = Math.sin(phi);
            t = 1.0 - this.excentricitySquared * s * s;
            t = (this.mlfn(phi, s, Math.cos(phi)) - arg) * (t * Math.sqrt(t)) * k;
            phi -= t;
        } while (!(Math.abs(t) < 1.0E-11));
        return phi;
    }

    private int getZone(double centralLongitudeZone1, double zoneWidth) {
        double zoneCount = Math.abs(360.0 / zoneWidth);
        double t = centralLongitudeZone1 - 0.5 * zoneWidth;
        t = Math.toDegrees(this.centralMeridian) - t;
        t = Math.floor(t / zoneWidth + 1.0E-6);
        t -= zoneCount * Math.floor(t / zoneCount);
        return (int)t + 1;
    }

    private double getCentralMedirian(double centralLongitudeZone1, double zoneWidth) {
        double t = centralLongitudeZone1 + (double)(this.getZone(centralLongitudeZone1, zoneWidth) - 1) * zoneWidth;
        t -= 360.0 * Math.floor((t + 180.0) / 360.0);
        return t;
    }

    public int getZone() {
        if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
            return this.getZone(-177.0, 6.0);
        }
        if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
            return this.getZone(-52.5, -3.0);
        }
        throw new IllegalStateException("Unknow projection type.");
    }

    public double getCentralMeridian() {
        if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
            return this.getCentralMedirian(-177.0, 6.0);
        }
        if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
            return this.getCentralMedirian(-52.5, -3.0);
        }
        throw new IllegalStateException("Unknow projection type.");
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.ml0);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    private static final class Spherical
    extends TransverseMercator {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
            super(parameters, expected);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double normalizedLongitude = x;
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double cosphi = Math.cos(y);
            double b = cosphi * Math.sin(x);
            if (Math.abs(Math.abs(b) - 1.0) <= 1.0E-6) {
                throw new ProjectionException(Resources.format(127));
            }
            y = Math.atan2(Math.tan(y), Math.cos(x)) - this.latitudeOfOrigin;
            x = 0.5 * Math.log((1.0 + b) / (1.0 - b));
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= this.getToleranceForSphereAssertions(normalizedLongitude, 0.0))) {
                throw new AssertionError(ptDst.getX() - x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= this.getToleranceForSphereAssertions(normalizedLongitude, 0.0))) {
                throw new AssertionError(ptDst.getY() - y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double t = Math.exp(x);
            double sinhX = 0.5 * (t - 1.0 / t);
            double cosD = Math.cos(this.latitudeOfOrigin + y);
            double phi = Math.asin(Math.sqrt((1.0 - cosD * cosD) / (1.0 + sinhX * sinhX)));
            y = y + this.latitudeOfOrigin < 0.0 ? -phi : phi;
            double d = x = Math.abs(sinhX) <= 1.0E-6 && Math.abs(cosD) <= 1.0E-6 ? 0.0 : Math.atan2(sinhX, cosD);
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= this.getToleranceForSphereAssertions(x, 0.0))) {
                throw new AssertionError(ptDst.getX() - x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= this.getToleranceForSphereAssertions(x, 0.0))) {
                throw new AssertionError(ptDst.getY() - y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected double getToleranceForSphereAssertions(double longitude, double latitude) {
            if (Math.abs(Math.abs(longitude) - 1.5707963267948966) < 1.0E-11) {
                return 1.0E18;
            }
            if (Math.abs(longitude) > 0.26) {
                return 1000000.0;
            }
            return 1.0E-6;
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$TransverseMercator == null ? (class$org$geotools$referencing$operation$projection$TransverseMercator = TransverseMercator.class$("org.geotools.referencing.operation.projection.TransverseMercator")) : class$org$geotools$referencing$operation$projection$TransverseMercator).desiredAssertionStatus();
        }
    }

    public static final class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Transverse_Mercator"), new NamedIdentifier(CitationImpl.EPSG, "Transverse Mercator"), new NamedIdentifier(CitationImpl.EPSG, "Gauss-Kruger"), new NamedIdentifier(CitationImpl.EPSG, "9807"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_TransverseMercator"), new NamedIdentifier(CitationImpl.ESRI, "Transverse_Mercator"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(58))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = TransverseMercator.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters, descriptors);
            }
            return new TransverseMercator(parameters, descriptors);
        }
    }
}

