/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.LocalizationGrid;
import org.geotools.resources.Arguments;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class NADCONTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -4707304160205218546L;
    private static final String GRID_LOCATION = "Grid location";
    private static final String DEFAULT_GRID_LOCATION = ".";
    private static final double TOL = 5.0E-10;
    private static final int MAX_ITER = 10;
    private static final double SEC_2_DEG = 3600.0;
    private final String latGridName;
    private final String longGridName;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private double dx;
    private double dy;
    private LocalizationGrid gridShift = null;
    private MathTransform gridShiftTransform = null;
    private transient MathTransform inverse;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$opengis$referencing$operation$Transformation;

    public NADCONTransform(String latGridName, String longGridName) throws ParameterNotFoundException, FactoryException {
        this.latGridName = latGridName;
        this.longGridName = longGridName;
        try {
            URL latGridURL = this.makeURL(latGridName);
            URL longGridURL = this.makeURL(longGridName);
            if (latGridName.endsWith(".las") && longGridName.endsWith(".los") || latGridName.endsWith(".LAS") && longGridName.endsWith(".LOS")) {
                this.loadBinaryGrid(latGridURL, longGridURL);
            } else if (latGridName.endsWith(".laa") && longGridName.endsWith(".loa") || latGridName.endsWith(".LAA") && longGridName.endsWith(".LOA")) {
                this.loadTextGrid(latGridURL, longGridURL);
            } else {
                throw new FactoryException(Resources.format(125, latGridName.substring(latGridName.lastIndexOf(46)), longGridName.substring(longGridName.lastIndexOf(46))));
            }
            this.gridShiftTransform = this.gridShift.getMathTransform();
        }
        catch (IOException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        Parameter lat_diff_file = new Parameter(Provider.LAT_DIFF_FILE);
        lat_diff_file.setValue(this.latGridName);
        Parameter long_diff_file = new Parameter(Provider.LONG_DIFF_FILE);
        long_diff_file.setValue(this.longGridName);
        return new ParameterGroup(this.getParameterDescriptors(), new GeneralParameterValue[]{lat_diff_file, long_diff_file});
    }

    public int getSourceDimensions() {
        return 2;
    }

    public int getTargetDimensions() {
        return 2;
    }

    private URL makeURL(String str) throws MalformedURLException {
        if (str.indexOf("\\") != -1 || str.indexOf("/") != -1 || str.indexOf(":") != -1) {
            return this.makeURLfromString(str);
        }
        Preferences prefs = Preferences.userNodeForPackage(NADCONTransform.class);
        String baseLocation = prefs.get(GRID_LOCATION, DEFAULT_GRID_LOCATION);
        return this.makeURLfromString(baseLocation + "/" + str);
    }

    private URL makeURLfromString(String str) throws MalformedURLException {
        try {
            return new URL(str);
        }
        catch (MalformedURLException e) {
            return new URL("file", "", str);
        }
    }

    private void loadBinaryGrid(URL latGridUrl, URL longGridUrl) throws IOException, FactoryException {
        int HEADER_BYTES = 96;
        int SEPARATOR_BYTES = 4;
        int DESCRIPTION_LENGTH = 64;
        ReadableByteChannel latChannel = this.getReadChannel(latGridUrl);
        ByteBuffer latBuffer = this.fillBuffer(latChannel, 96);
        ReadableByteChannel longChannel = this.getReadChannel(longGridUrl);
        ByteBuffer longBuffer = this.fillBuffer(longChannel, 96);
        latBuffer.position(latBuffer.position() + 64);
        int nc = latBuffer.getInt();
        int nr = latBuffer.getInt();
        int nz = latBuffer.getInt();
        this.xmin = latBuffer.getFloat();
        this.dx = latBuffer.getFloat();
        this.ymin = latBuffer.getFloat();
        this.dy = latBuffer.getFloat();
        float angle = latBuffer.getFloat();
        this.xmax = this.xmin + (double)(nc - 1) * this.dx;
        this.ymax = this.ymin + (double)(nr - 1) * this.dy;
        longBuffer.position(longBuffer.position() + 64);
        if (nc != longBuffer.getInt() || nr != longBuffer.getInt() || nz != longBuffer.getInt() || this.xmin != (double)longBuffer.getFloat() || this.dx != (double)longBuffer.getFloat() || this.ymin != (double)longBuffer.getFloat() || this.dy != (double)longBuffer.getFloat() || angle != longBuffer.getFloat()) {
            throw new FactoryException(Resources.format(79));
        }
        int RECORD_LENGTH = nc * 4 + 4;
        int NUM_BYTES_LEFT = (nr + 1) * RECORD_LENGTH - 96;
        int START_OF_DATA = RECORD_LENGTH - 96;
        latBuffer = this.fillBuffer(latChannel, NUM_BYTES_LEFT);
        latBuffer.position(START_OF_DATA);
        longBuffer = this.fillBuffer(longChannel, NUM_BYTES_LEFT);
        longBuffer.position(START_OF_DATA);
        this.gridShift = new LocalizationGrid(nc, nr);
        int i = 0;
        int j = 0;
        for (i = 0; i < nr; ++i) {
            latBuffer.position(latBuffer.position() + 4);
            longBuffer.position(longBuffer.position() + 4);
            for (j = 0; j < nc; ++j) {
                this.gridShift.setLocalizationPoint(j, i, new Float(longBuffer.getFloat()).doubleValue(), new Float(latBuffer.getFloat()).doubleValue());
            }
        }
        if (!$assertionsDisabled && i != nr) {
            throw new AssertionError(i);
        }
        if (!$assertionsDisabled && j != nc) {
            throw new AssertionError(j);
        }
    }

    private ByteBuffer fillBuffer(ReadableByteChannel channel, int numBytes) throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(numBytes);
        if (this.fill(buf, channel) == -1) {
            throw new EOFException(Resources.format(77));
        }
        buf.flip();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    private int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            if (!file.exists() || !file.canRead()) {
                throw new IOException(Resources.format(78, file));
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    private void loadTextGrid(URL latGridUrl, URL longGridUrl) throws IOException, FactoryException {
        InputStreamReader latIsr = new InputStreamReader(latGridUrl.openStream());
        BufferedReader latBr = new BufferedReader(latIsr);
        InputStreamReader longIsr = new InputStreamReader(longGridUrl.openStream());
        BufferedReader longBr = new BufferedReader(longIsr);
        String latLine = latBr.readLine();
        latLine = latBr.readLine();
        StringTokenizer latSt = new StringTokenizer(latLine, " ");
        if (latSt.countTokens() != 8) {
            throw new FactoryException(Resources.format(80, String.valueOf(latSt.countTokens())));
        }
        int nc = Integer.parseInt(latSt.nextToken());
        int nr = Integer.parseInt(latSt.nextToken());
        int nz = Integer.parseInt(latSt.nextToken());
        this.xmin = Float.parseFloat(latSt.nextToken());
        this.dx = Float.parseFloat(latSt.nextToken());
        this.ymin = Float.parseFloat(latSt.nextToken());
        this.dy = Float.parseFloat(latSt.nextToken());
        float angle = Float.parseFloat(latSt.nextToken());
        this.xmax = this.xmin + (double)(nc - 1) * this.dx;
        this.ymax = this.ymin + (double)(nr - 1) * this.dy;
        String longLine = longBr.readLine();
        longLine = longBr.readLine();
        StringTokenizer longSt = new StringTokenizer(longLine, " ");
        if (longSt.countTokens() != 8) {
            throw new FactoryException(Resources.format(80, String.valueOf(longSt.countTokens())));
        }
        if (nc != Integer.parseInt(longSt.nextToken()) || nr != Integer.parseInt(longSt.nextToken()) || nz != Integer.parseInt(longSt.nextToken()) || this.xmin != (double)Float.parseFloat(longSt.nextToken()) || this.dx != (double)Float.parseFloat(longSt.nextToken()) || this.ymin != (double)Float.parseFloat(longSt.nextToken()) || this.dy != (double)Float.parseFloat(longSt.nextToken()) || angle != Float.parseFloat(longSt.nextToken())) {
            throw new FactoryException(Resources.format(79));
        }
        this.gridShift = new LocalizationGrid(nc, nr);
        int i = 0;
        int j = 0;
        for (i = 0; i < nr; ++i) {
            j = 0;
            while (j < nc) {
                latLine = latBr.readLine();
                latSt = new StringTokenizer(latLine, " ");
                longLine = longBr.readLine();
                longSt = new StringTokenizer(longLine, " ");
                while (latSt.hasMoreTokens() && longSt.hasMoreTokens()) {
                    this.gridShift.setLocalizationPoint(j, i, Float.parseFloat(longSt.nextToken()), Float.parseFloat(latSt.nextToken()));
                    ++j;
                }
            }
        }
        if (!$assertionsDisabled && i != nr) {
            throw new AssertionError(i);
        }
        if (!$assertionsDisabled && j != nc) {
            throw new AssertionError(j);
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int step = 0;
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * this.getSourceDimensions() > dstOff) {
            step = -this.getSourceDimensions();
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            if (x < this.xmin || x > this.xmax || y < this.ymin || y > this.ymax) {
                throw new TransformException(Resources.format(117));
            }
            double xgrid = (x - this.xmin) / this.dx;
            double ygrid = (y - this.ymin) / this.dy;
            double[] array = new double[]{xgrid, ygrid};
            this.gridShiftTransform.transform(array, 0, array, 0, 1);
            dstPts[dstOff++] = x - array[0] / 3600.0;
            dstPts[dstOff++] = y + array[1] / 3600.0;
            srcOff += step;
            dstOff += step;
        }
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int step = 0;
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * this.getSourceDimensions() > dstOff) {
            step = -this.getSourceDimensions();
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double ytemp;
            double xtemp;
            block5: {
                double x = srcPts[srcOff++];
                double y = srcPts[srcOff++];
                xtemp = x;
                ytemp = y;
                int i = 10;
                do {
                    double[] array = new double[]{xtemp, ytemp};
                    this.transform(array, 0, array, 0, 1);
                    double xdif = array[0] - x;
                    double ydif = array[1] - y;
                    if (Math.abs(xdif) > 5.0E-10) {
                        xtemp -= xdif;
                    }
                    if (Math.abs(ydif) > 5.0E-10) {
                        ytemp -= ydif;
                    }
                    if (Math.abs(xdif) <= 5.0E-10 && Math.abs(ydif) <= 5.0E-10) break block5;
                } while (--i >= 0);
                throw new TransformException(Resources.format(109));
            }
            dstPts[dstOff++] = xtemp;
            dstPts[dstOff++] = ytemp;
            srcOff += step;
            dstOff += step;
        }
    }

    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    public final int hashCode() {
        long code = Double.doubleToLongBits(this.xmin) + 37L * (Double.doubleToLongBits(this.ymin) + 37L * (Double.doubleToLongBits(this.xmax) + 37L * (Double.doubleToLongBits(this.ymax) + 37L * (Double.doubleToLongBits(this.dx) + 37L * Double.doubleToLongBits(this.dy)))));
        return (int)code ^ (int)(code >>> 32);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            NADCONTransform that = (NADCONTransform)object;
            return Double.doubleToLongBits(this.xmin) == Double.doubleToLongBits(that.xmin) && Double.doubleToLongBits(this.ymin) == Double.doubleToLongBits(that.ymin) && Double.doubleToLongBits(this.xmax) == Double.doubleToLongBits(that.xmax) && Double.doubleToLongBits(this.ymax) == Double.doubleToLongBits(that.ymax) && Double.doubleToLongBits(this.dx) == Double.doubleToLongBits(that.dx) && Double.doubleToLongBits(this.dy) == Double.doubleToLongBits(that.dy) && this.gridShiftTransform.equals(that.gridShiftTransform);
        }
        return false;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        PrintWriter out = arguments.out;
        Preferences prefs = Preferences.userNodeForPackage(NADCONTransform.class);
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("default")) {
                prefs.remove(GRID_LOCATION);
            } else {
                prefs.put(GRID_LOCATION, args[0]);
            }
            return;
        }
        String location = prefs.get(GRID_LOCATION, DEFAULT_GRID_LOCATION);
        out.println("Usage: java org.geotools.referencing.operation.transform.NADCONTransform <defalult grid file location (path)>");
        out.print("Grid location: \"");
        out.print(location);
        out.println('\"');
    }

    static {
        $assertionsDisabled = !NADCONTransform.class.desiredAssertionStatus();
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -4707304160205218546L;
        public static final ParameterDescriptor LAT_DIFF_FILE = new DefaultParameterDescriptor("Latitude_difference_file", class$java$lang$String == null ? (class$java$lang$String = NADCONTransform.class$("java.lang.String")) : class$java$lang$String, null, "conus.las");
        public static final ParameterDescriptor LONG_DIFF_FILE = new DefaultParameterDescriptor("Longitude_difference_file", class$java$lang$String == null ? (class$java$lang$String = NADCONTransform.class$("java.lang.String")) : class$java$lang$String, null, "conus.los");
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "NADCON"), new NamedIdentifier(CitationImpl.EPSG, "NADCON"), new NamedIdentifier(CitationImpl.EPSG, "9613"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(41))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{LAT_DIFF_FILE, LONG_DIFF_FILE});

        public Provider() {
            super(2, 2, PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$Transformation == null ? (class$org$opengis$referencing$operation$Transformation = NADCONTransform.class$("org.opengis.referencing.operation.Transformation")) : class$org$opengis$referencing$operation$Transformation;
        }

        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
            return new NADCONTransform(Provider.stringValue(LAT_DIFF_FILE, values), Provider.stringValue(LONG_DIFF_FILE, values));
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = -4707304160205218546L;

        public ParameterValueGroup getParameterValues() {
            return null;
        }

        public void transform(double[] source, int srcOffset, double[] dest, int dstOffset, int length) throws TransformException {
            NADCONTransform.this.inverseTransform(source, srcOffset, dest, dstOffset, length);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            NADCONTransform.this.inverse = this;
        }
    }
}

