/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import javax.vecmath.SingularMatrixException;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.parameter.MatrixParameterDescriptors;
import org.geotools.parameter.MatrixParameters;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.spatialschema.geometry.DirectPosition;

public class ProjectiveTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -2104496465933824935L;
    private final int numRow;
    private final int numCol;
    private final double[] elt;
    static /* synthetic */ Class class$org$opengis$referencing$operation$Conversion;

    protected ProjectiveTransform(Matrix matrix) {
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        this.elt = new double[this.numRow * this.numCol];
        int index = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                this.elt[index++] = matrix.getElement(j, i);
            }
        }
    }

    public static LinearTransform create(Matrix matrix) {
        int dimension = matrix.getNumRow() - 1;
        if (dimension == matrix.getNumCol() - 1) {
            if (matrix.isIdentity()) {
                return IdentityTransform.create(dimension);
            }
            GeneralMatrix m = ProjectiveTransform.wrap(matrix);
            if (m.isAffine()) {
                switch (dimension) {
                    case 1: {
                        return LinearTransform1D.create(m.getElement(0, 0), m.getElement(0, 1));
                    }
                    case 2: {
                        return ProjectiveTransform.create(m.toAffineTransform2D());
                    }
                }
            }
        }
        return new ProjectiveTransform(matrix);
    }

    public static LinearTransform create(AffineTransform matrix) {
        if (matrix.isIdentity()) {
            return IdentityTransform.create(2);
        }
        return new AffineTransform2D(matrix);
    }

    public static Matrix createSelectMatrix(int sourceDim, int[] toKeep) throws IndexOutOfBoundsException {
        int targetDim = toKeep.length;
        GeneralMatrix matrix = new GeneralMatrix(targetDim + 1, sourceDim + 1);
        matrix.setZero();
        for (int j = 0; j < targetDim; ++j) {
            matrix.setElement(j, toKeep[j], 1.0);
        }
        matrix.setElement(targetDim, sourceDim, 1.0);
        return matrix;
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    static ParameterValueGroup getParameterValues(Matrix matrix) {
        MatrixParameters values = (MatrixParameters)Provider.PARAMETERS.createValue();
        values.setMatrix(matrix);
        return values;
    }

    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int upperSrc;
        int inputDimension = this.numCol - 1;
        int outputDimension = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        if (srcPts == dstPts && (upperSrc = srcOff + numPts * inputDimension) > dstOff && (inputDimension >= outputDimension ? dstOff > srcOff : dstOff + numPts * outputDimension > upperSrc)) {
            srcPts = new float[numPts * inputDimension];
            System.arraycopy(dstPts, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + inputDimension];
                for (int i = 0; i < inputDimension; ++i) {
                    sum += (double)srcPts[srcOff + i] * this.elt[mix++];
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[outputDimension];
            for (int j = 0; j < outputDimension; ++j) {
                dstPts[dstOff++] = (float)(buffer[j] / w);
            }
            srcOff += inputDimension;
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int upperSrc;
        int inputDimension = this.numCol - 1;
        int outputDimension = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        if (srcPts == dstPts && (upperSrc = srcOff + numPts * inputDimension) > dstOff && (inputDimension >= outputDimension ? dstOff > srcOff : dstOff + numPts * outputDimension > upperSrc)) {
            srcPts = new double[numPts * inputDimension];
            System.arraycopy(dstPts, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + inputDimension];
                for (int i = 0; i < inputDimension; ++i) {
                    sum += srcPts[srcOff + i] * this.elt[mix++];
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[outputDimension];
            for (int j = 0; j < outputDimension; ++j) {
                dstPts[dstOff++] = buffer[j] / w;
            }
            srcOff += inputDimension;
        }
    }

    public Matrix derivative(Point2D point) {
        return this.derivative((DirectPosition)null);
    }

    public Matrix derivative(DirectPosition point) {
        GeneralMatrix matrix = this.getGeneralMatrix();
        matrix.setSize(this.numRow - 1, this.numCol - 1);
        return matrix;
    }

    public Matrix getMatrix() {
        return this.getGeneralMatrix();
    }

    private GeneralMatrix getGeneralMatrix() {
        return new GeneralMatrix(this.numRow, this.numCol, this.elt);
    }

    public int getSourceDimensions() {
        return this.numCol - 1;
    }

    public int getTargetDimensions() {
        return this.numRow - 1;
    }

    public boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        int index = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                if (this.elt[index++] == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        GeneralMatrix matrix = this.getGeneralMatrix();
        try {
            matrix.invert();
        }
        catch (SingularMatrixException exception) {
            NoninvertibleTransformException e = new NoninvertibleTransformException(Resources.format(102));
            e.initCause((Throwable)exception);
            throw e;
        }
        return new ProjectiveTransform(matrix);
    }

    public int hashCode() {
        long code = -2104496465933824935L;
        int i = this.elt.length;
        while (--i >= 0) {
            code = code * 37L + Double.doubleToLongBits(this.elt[i]);
        }
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ProjectiveTransform that = (ProjectiveTransform)object;
            return this.numRow == that.numRow && this.numCol == that.numCol && Arrays.equals(this.elt, that.elt);
        }
        return false;
    }

    public static final class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = 649555815622129472L;
        private static OperationMethod[] methods = new OperationMethod[8];
        static final ParameterDescriptorGroup PARAMETERS;

        public Provider() {
            this(2, 2);
            Provider.methods[1] = this;
        }

        private Provider(int sourceDimensions, int targetDimensions) {
            super(sourceDimensions, targetDimensions, PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$Conversion == null ? (class$org$opengis$referencing$operation$Conversion = ProjectiveTransform.class$("org.opengis.referencing.operation.Conversion")) : class$org$opengis$referencing$operation$Conversion;
        }

        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            return ProjectiveTransform.create(((MatrixParameterDescriptors)this.getParameters()).getMatrix(values));
        }

        protected OperationMethod getMethod(MathTransform mt) {
            return Provider.getMethod(mt.getSourceDimensions(), mt.getTargetDimensions());
        }

        public static OperationMethod getMethod(int sourceDimensions, int targetDimensions) {
            int i;
            if (sourceDimensions == targetDimensions && (i = sourceDimensions - 1) >= 0 && i < methods.length) {
                OperationMethod method = methods[i];
                if (method == null) {
                    Provider.methods[i] = method = new Provider(sourceDimensions, targetDimensions);
                }
                return method;
            }
            return new Provider(sourceDimensions, targetDimensions);
        }

        static {
            NamedIdentifier name = new NamedIdentifier(CitationImpl.OGC, "Affine");
            HashMap<String, Object> properties = new HashMap<String, Object>(4, 0.8f);
            properties.put("name", name);
            properties.put("identifiers", name);
            properties.put("alias", new NamedIdentifier[]{name, new NamedIdentifier(CitationImpl.EPSG, "Affine general parametric transformation"), new NamedIdentifier(CitationImpl.EPSG, "9624"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(1))});
            PARAMETERS = new MatrixParameterDescriptors(properties);
        }
    }
}

