/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.cts.Resources;
import org.geotools.util.Singleton;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;

public class MathTransformParser
extends AbstractParser {
    protected final MathTransformFactory mtFactory;
    private String classification;
    private final Singleton method = new Singleton();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public MathTransformParser() {
        this(Symbols.DEFAULT);
    }

    public MathTransformParser(Symbols symbols) {
        this(symbols, FactoryFinder.getMathTransformFactory(null));
    }

    public MathTransformParser(Symbols symbols, MathTransformFactory mtFactory) {
        super(symbols);
        this.mtFactory = mtFactory;
    }

    public MathTransform parseMathTransform(String text) throws ParseException {
        Element element = this.getTree(text, new ParsePosition(0));
        MathTransform mt = this.parseMathTransform(element, true);
        element.close();
        return mt;
    }

    protected Object parse(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean required) throws ParseException {
        this.method.clear();
        this.classification = null;
        Object key = element.peek();
        if (key instanceof Element) {
            String keyword = ((Element)key).keyword.trim().toUpperCase(this.symbols.locale);
            if ("PARAM_MT".equals(keyword)) {
                return this.parseParamMT(element);
            }
            if ("CONCAT_MT".equals(keyword)) {
                return this.parseConcatMT(element);
            }
            if ("INVERSE_MT".equals(keyword)) {
                return this.parseInverseMT(element);
            }
            if ("PASSTHROUGH_MT".equals(keyword)) {
                return this.parsePassThroughMT(element);
            }
        }
        if (required) {
            throw element.parseFailed(null, Resources.format(122, key));
        }
        return null;
    }

    private MathTransform parseParamMT(Element parent) throws ParseException {
        Element param;
        ParameterValueGroup parameters;
        Element element = parent.pullElement("PARAM_MT");
        this.classification = element.pullString("classification");
        try {
            parameters = this.mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
        while ((param = element.pullOptionalElement("PARAMETER")) != null) {
            String name;
            ParameterValue parameter;
            Class type;
            if ((class$java$lang$Integer == null ? MathTransformParser.class$("java.lang.Integer") : class$java$lang$Integer).equals(type = ((ParameterDescriptor)(parameter = parameters.parameter(name = param.pullString("name"))).getDescriptor()).getValueClass())) {
                parameter.setValue(param.pullInteger("value"));
            } else if ((class$java$lang$Double == null ? MathTransformParser.class$("java.lang.Double") : class$java$lang$Double).equals(type)) {
                parameter.setValue(param.pullDouble("value"));
            } else {
                parameter.setValue((Object)param.pullString("value"));
            }
            param.close();
        }
        element.close();
        try {
            if (this.mtFactory instanceof DefaultMathTransformFactory) {
                return ((DefaultMathTransformFactory)this.mtFactory).createParameterizedTransform(parameters, this.method);
            }
            return this.mtFactory.createParameterizedTransform(parameters);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
    }

    private MathTransform parseInverseMT(Element parent) throws ParseException {
        Element element = parent.pullElement("INVERSE_MT");
        try {
            MathTransform transform = this.parseMathTransform(element, true).inverse();
            element.close();
            return transform;
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
    }

    private MathTransform parsePassThroughMT(Element parent) throws ParseException {
        Element element = parent.pullElement("PASSTHROUGH_MT");
        int firstAffectedOrdinate = parent.pullInteger("firstAffectedOrdinate");
        MathTransform transform = this.parseMathTransform(element, true);
        element.close();
        try {
            return this.mtFactory.createPassThroughTransform(firstAffectedOrdinate, transform, 0);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
    }

    private MathTransform parseConcatMT(Element parent) throws ParseException {
        MathTransform optionalTransform;
        Element element = parent.pullElement("CONCAT_MT");
        MathTransform transform = this.parseMathTransform(element, true);
        while ((optionalTransform = this.parseMathTransform(element, false)) != null) {
            try {
                transform = this.mtFactory.createConcatenatedTransform(transform, optionalTransform);
            }
            catch (FactoryException exception) {
                throw element.parseFailed((Exception)((Object)exception), null);
            }
        }
        element.close();
        return transform;
    }

    final OperationMethod getOperationMethod() {
        if (!this.method.isEmpty()) {
            return (OperationMethod)this.method.get();
        }
        if (this.classification != null) {
            Iterator it = this.mtFactory.getAvailableMethods(CoordinateOperation.class).iterator();
            while (it.hasNext()) {
                OperationMethod method = (OperationMethod)it.next();
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)method, this.classification)) continue;
                return method;
            }
        }
        return null;
    }
}

