/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageMIPMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.RenderedCoverage;
import org.geotools.resources.geometry.XAffineTransform;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.operation.MathTransform2D;

public final class GridCoverageRenderer {
    private static final boolean USE_PYRAMID = false;
    private static final double DOWN_SAMPLER = 0.5;
    private static final double LOG_DOWN_SAMPLER = Math.log(0.5);
    private static final int MIN_SIZE = 256;
    private final GridCoverage gridCoverage;
    private final ImageMIPMap images;
    private final int maxLevel;
    private RenderedImage image;

    public GridCoverageRenderer(GridCoverage gridCoverage) {
        this.gridCoverage = gridCoverage;
        if (gridCoverage instanceof GridCoverage2D) {
            this.image = ((GridCoverage2D)gridCoverage).geophysics(false).getRenderedImage();
        } else if (gridCoverage instanceof RenderedCoverage) {
            this.image = ((RenderedCoverage)gridCoverage).getRenderedImage();
        }
        this.images = null;
        double maxSize = Math.max(this.image.getWidth(), this.image.getHeight());
        int logLevel = (int)(Math.log(256.0 / maxSize) / LOG_DOWN_SAMPLER);
        this.maxLevel = Math.max(logLevel, 0);
    }

    public void paint(Graphics2D graphics) {
        MathTransform2D mathTransform = (MathTransform2D)this.gridCoverage.getGridGeometry().getGridToCoordinateSystem();
        if (!(mathTransform instanceof AffineTransform)) {
            throw new UnsupportedOperationException("Non-affine transformations not yet implemented");
        }
        AffineTransform gridToCoordinate = (AffineTransform)mathTransform;
        if (this.images == null) {
            AffineTransform transform = new AffineTransform(gridToCoordinate);
            transform.translate(-0.5, -0.5);
            try {
                graphics.drawRenderedImage(this.image, transform);
            }
            catch (Exception e) {
                this.image = this.getGoodImage(this.image);
                graphics.drawRenderedImage(this.image, transform);
            }
        } else {
            AffineTransform transform = graphics.getTransform();
            transform.concatenate(gridToCoordinate);
            double maxScale = Math.max(XAffineTransform.getScaleX0(transform), XAffineTransform.getScaleY0(transform));
            int level = Math.min(this.maxLevel, (int)(Math.log(maxScale) / LOG_DOWN_SAMPLER));
            if (level < 0) {
                level = 0;
            }
            transform.setTransform(gridToCoordinate);
            if (level != 0) {
                double scale = Math.pow(0.5, -level);
                transform.scale(scale, scale);
            }
            transform.translate(-0.5, -0.5);
            graphics.drawRenderedImage(this.images.getImage(level), transform);
        }
    }

    private RenderedImage getGoodImage(RenderedImage img) {
        BufferedImage good = new BufferedImage(img.getWidth(), img.getHeight(), 10);
        Graphics2D g2d = (Graphics2D)good.getGraphics();
        g2d.drawRenderedImage(img, new AffineTransform());
        return good;
    }
}

