/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import org.geotools.renderer.style.Style2D;
import org.geotools.resources.Utilities;

public class TextStyle2D
extends Style2D {
    GlyphVector textGlyphVector;
    Shape haloShape;
    String label;
    Font font;
    double rotation;
    boolean absoluteLineDisplacement;
    double anchorX;
    double anchorY;
    double displacementX;
    double displacementY;
    Paint haloFill;
    Composite haloComposite;
    float haloRadius;
    private Paint fill;
    private Composite composite;

    public double getAnchorX() {
        return this.anchorX;
    }

    public double getAnchorY() {
        return this.anchorY;
    }

    public Font getFont() {
        return this.font;
    }

    public Composite getHaloComposite() {
        return this.haloComposite;
    }

    public Paint getHaloFill() {
        return this.haloFill;
    }

    public float getHaloRadius() {
        return this.haloRadius;
    }

    public double getRotation() {
        return this.rotation;
    }

    public GlyphVector getTextGlyphVector(Graphics2D graphics) {
        if (this.textGlyphVector == null) {
            this.textGlyphVector = this.font.createGlyphVector(graphics.getFontRenderContext(), this.label);
        }
        return this.textGlyphVector;
    }

    public Shape getHaloShape(Graphics2D graphics) {
        if (this.haloShape == null) {
            GlyphVector gv = this.getTextGlyphVector(graphics);
            this.haloShape = new BasicStroke(2.0f * this.haloRadius, 1, 1).createStrokedShape(gv.getOutline());
        }
        return this.haloShape;
    }

    public void setAnchorX(double f) {
        this.anchorX = f;
    }

    public void setAnchorY(double f) {
        this.anchorY = f;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setHaloComposite(Composite composite) {
        this.haloComposite = composite;
    }

    public void setHaloFill(Paint paint) {
        this.haloFill = paint;
    }

    public void setHaloRadius(float f) {
        this.haloRadius = f;
    }

    public void setRotation(double f) {
        this.rotation = f;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isAbsoluteLineDisplacement() {
        return this.absoluteLineDisplacement;
    }

    public void setAbsoluteLineDisplacement(boolean absoluteLineDisplacement) {
        this.absoluteLineDisplacement = absoluteLineDisplacement;
    }

    public double getDisplacementX() {
        return this.displacementX;
    }

    public void setDisplacementX(double displacementX) {
        this.displacementX = displacementX;
    }

    public double getDisplacementY() {
        return this.displacementY;
    }

    public void setDisplacementY(double displacementY) {
        this.displacementY = displacementY;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint fill) {
        this.fill = fill;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public String toString() {
        return Utilities.getShortClassName(this) + "[\"" + this.label + "\"]";
    }
}

