/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Utilities {
    private static final String[] spacesFactory = new String[20];

    private Utilities() {
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static boolean sameInterfaces(Class object1, Class object2, Class base) {
        Class<?> c;
        int i;
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        Class<?>[] c1 = object1.getInterfaces();
        Class<?>[] c2 = object2.getInterfaces();
        int n = 0;
        for (i = 0; i < c2.length; ++i) {
            c = c2[i];
            if (!base.isAssignableFrom(c)) continue;
            c2[n++] = c;
        }
        block1: for (i = 0; i < c1.length; ++i) {
            c = c1[i];
            if (!base.isAssignableFrom(c)) continue;
            for (int j = 0; j < n; ++j) {
                if (!c.equals(c2[j])) continue;
                System.arraycopy(c2, j + 1, c2, j, --n - j);
                continue block1;
            }
            return false;
        }
        return n == 0;
    }

    public static String spaces(int length) {
        int last = spacesFactory.length - 1;
        if (length < 0) {
            length = 0;
        }
        if (length <= last) {
            if (spacesFactory[length] == null) {
                if (spacesFactory[last] == null) {
                    char[] blancs = new char[last];
                    Arrays.fill(blancs, ' ');
                    Utilities.spacesFactory[last] = new String(blancs).intern();
                }
                Utilities.spacesFactory[length] = spacesFactory[last].substring(0, length).intern();
            }
            return spacesFactory[length];
        }
        char[] blancs = new char[length];
        Arrays.fill(blancs, ' ');
        return new String(blancs);
    }

    public static String getShortName(Class classe) {
        Class<?> el;
        if (classe == null) {
            return "<*>";
        }
        int dimension = 0;
        while ((el = classe.getComponentType()) != null) {
            classe = el;
            ++dimension;
        }
        String name = classe.getName();
        int lower = name.lastIndexOf(46);
        int upper = name.length();
        name = name.substring(lower + 1, upper).replace('$', '.');
        if (dimension != 0) {
            StringBuffer buffer = new StringBuffer(name);
            do {
                buffer.append("[]");
            } while (--dimension != 0);
            name = buffer.toString();
        }
        return name;
    }

    public static String getShortClassName(Object object) {
        return Utilities.getShortName(object != null ? object.getClass() : null);
    }

    public static void unexpectedException(String paquet, String classe, String method, Throwable error) {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(error));
        String message = error.getLocalizedMessage();
        if (message != null) {
            buffer.append(": ");
            buffer.append(message);
        }
        LogRecord record = new LogRecord(Level.WARNING, buffer.toString());
        record.setSourceClassName(classe);
        record.setSourceMethodName(method);
        record.setThrown(error);
        Logger.getLogger(paquet).log(record);
    }
}

