/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterCapabilitiesMask;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.MathExpression;
import org.geotools.ows.ServiceException;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Any;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeValue;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.AnyGT;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterComplexTypes {
    public static final String CACHE_SERVICE_EXCEPTIONS = "FilterComplexTypes.CACHE_SERVICE_EXCEPTIONS";
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$geotools$filter$FilterCapabilitiesMask;
    static /* synthetic */ Class class$org$geotools$filter$Expression;
    static /* synthetic */ Class class$org$geotools$filter$MathExpression;
    static /* synthetic */ Class class$org$geotools$filter$FunctionExpression;
    static /* synthetic */ Class class$org$geotools$filter$LiteralExpression;
    static /* synthetic */ Class class$org$geotools$filter$AttributeExpression;
    static /* synthetic */ Class class$org$geotools$ows$ServiceException;
    static /* synthetic */ Class array$Lorg$geotools$ows$ServiceException;
    static /* synthetic */ Class array$Lorg$opengis$filter$expression$PropertyName;
    static /* synthetic */ Class class$java$lang$String;

    public static class SortOrderType
    implements SimpleType {
        public static final String SORT_ORDER_KEY = "org.geotools.xml.ogc.SortOrderType_KEY";
        public static final String SORT_ORDER_DESC = "org.geotools.xml.ogc.SortOrderType_DESC";
        public static final String SORT_ORDER_ASC = "org.geotools.xml.ogc.SortOrderType_ASC";
        private static SortOrderType instance = new SortOrderType();
        private static SimpleType[] parents = new SimpleType[]{XSISimpleTypes.String.getInstance()};
        private static Facet[] facets = new Facet[]{new FacetGT(1, "DESC"), new FacetGT(1, "ASC")};

        private SortOrderType() {
        }

        public static SortOrderType getInstance() {
            return instance;
        }

        public int getFinal() {
            return 0;
        }

        public String getId() {
            return null;
        }

        public AttributeValue toAttribute(Attribute attribute, Object value, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        public boolean canCreateAttributes(Attribute attribute, Object value, Map hints) {
            return false;
        }

        public int getChildType() {
            return 4;
        }

        public SimpleType[] getParents() {
            return parents;
        }

        public Facet[] getFacets() {
            return facets;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        public String getName() {
            return "SortOrderType";
        }

        public URI getNamespace() {
            return FilterSchema.NAMESPACE;
        }

        public Class getInstanceType() {
            return class$java$lang$String == null ? (class$java$lang$String = FilterComplexTypes.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        public Element findChildElement(String name) {
            return null;
        }
    }

    public static class SortByType
    extends FilterSchema.FilterComplexType {
        private static SortByType instance = new SortByType();
        private static Element[] elems = SortByType.loadE();
        private static Sequence seq = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("sortOrder", SortOrderType.getInstance(), 0, "DESC", null, false)};

        private SortByType() {
        }

        public static SortByType getInstance() {
            return instance;
        }

        private static Element[] loadE() {
            FilterSchema.FilterElement exp = new FilterSchema.FilterElement("expression", ExpressionType.getInstance()){

                public boolean isAbstract() {
                    return true;
                }
            };
            return new Element[]{new FilterSchema.FilterElement("PropertyName", PropertyNameType.getInstance(), exp){

                public int getMaxOccurs() {
                    return Integer.MAX_VALUE;
                }
            }};
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        public String getName() {
            return "SortByType";
        }

        public Class getInstanceType() {
            return array$Lorg$opengis$filter$expression$PropertyName == null ? (array$Lorg$opengis$filter$expression$PropertyName = FilterComplexTypes.class$("[Lorg.opengis.filter.expression.PropertyName;")) : array$Lorg$opengis$filter$expression$PropertyName;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType().equals(this) && value != null && value instanceof PropertyName[];
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new IOException("Cannot encode");
            }
            PropertyName[] pns = (PropertyName[])value;
            AttributesImpl ai = null;
            if (hints != null && hints.containsKey("org.geotools.xml.ogc.SortOrderType_KEY") && hints.get("org.geotools.xml.ogc.SortOrderType_KEY") == "org.geotools.xml.ogc.SortOrderType_ASC") {
                ai = new AttributesImpl();
                ai.addAttribute(FilterSchema.NAMESPACE.toString(), "sortOrder", null, "string", "ASC");
            }
            output.startElement(element.getNamespace(), element.getName(), ai);
            for (int i = 0; i < pns.length; ++i) {
                elems[0].getType().encode(elems[0], pns[i], output, hints);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class EmptyType
    extends FilterSchema.FilterComplexType {
        private static EmptyType instance = new EmptyType();

        public static EmptyType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return null;
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class ServiceExceptionReportType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new ServiceExceptionReportType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("ServiceException", ServiceExceptionType.getInstance()){

            public int getMinOccurs() {
                return 0;
            }

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        }};
        private static Sequence seq = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("version", XSISimpleTypes.String.getInstance(), 0, null, "1.2.0", false)};

        public static ComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            if (value == null || element.getType() == null || !this.getName().equals(element.getType().getName())) {
                throw new SAXNotSupportedException("wrong element type for service exception report");
            }
            ServiceException[] ret = new ServiceException[value.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ServiceException)value[i].getValue();
            }
            return ret;
        }

        public String getName() {
            return "ServiceExceptionReportType";
        }

        public Class getInstanceType() {
            return array$Lorg$geotools$ows$ServiceException == null ? (array$Lorg$geotools$ows$ServiceException = FilterComplexTypes.class$("[Lorg.geotools.ows.ServiceException;")) : array$Lorg$geotools$ows$ServiceException;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class ServiceExceptionType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new ServiceExceptionType();
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("code", XSISimpleTypes.String.getInstance()), new FilterSchema.FilterAttribute("locator", XSISimpleTypes.String.getInstance())};

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isMixed() {
            return true;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public boolean cache(Element element, Map hints) {
            return hints != null && hints.containsKey(FilterComplexTypes.CACHE_SERVICE_EXCEPTIONS);
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            if (value == null || element.getType() == null || !this.getName().equals(element.getType().getName())) {
                throw new SAXNotSupportedException("wrong element type for service exception");
            }
            String msg = (String)value[0].getValue();
            String locator = null;
            String code = null;
            locator = attrs1.getValue(null, "locator");
            if (locator == null) {
                locator = attrs1.getValue(this.getNamespace().toString(), "locator");
            }
            if ((code = attrs1.getValue(null, "code")) == null) {
                code = attrs1.getValue(this.getNamespace().toString(), "code");
            }
            ServiceException se = new ServiceException(msg == null ? "" : msg, code == null ? "" : code, locator == null ? "" : locator);
            if (this.cache(element, hints)) {
                return se;
            }
            throw se;
        }

        public String getName() {
            return "ServiceExceptionType";
        }

        public Class getInstanceType() {
            return class$org$geotools$ows$ServiceException == null ? (class$org$geotools$ows$ServiceException = FilterComplexTypes.class$("org.geotools.ows.ServiceException")) : class$org$geotools$ows$ServiceException;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class PropertyNameType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyNameType();

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isMixed() {
            return true;
        }

        public Type getParent() {
            return ExpressionType.getInstance();
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                String xpath = (String)value[0].getValue();
                AttributeExpression expr = factory.createAttributeExpression(null, xpath);
                return expr;
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal xpath for property name " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "PropertyNameType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$AttributeExpression == null ? (class$org$geotools$filter$AttributeExpression = FilterComplexTypes.class$("org.geotools.filter.AttributeExpression")) : class$org$geotools$filter$AttributeExpression;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return (value instanceof AttributeExpression || value instanceof String) && element.getType() != null && this.getName().equals(element.getType().getName());
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode " + (element == null ? "null" : element.getName()) + " " + (element == null ? "null" : element.getNamespace().toString()) + " " + (value == null ? null : value.getClass().getName()));
            }
            output.startElement(element.getNamespace(), element.getName(), null);
            if (value instanceof String) {
                output.characters((String)value);
            } else {
                AttributeExpression name = (AttributeExpression)value;
                output.characters(name.getAttributePath());
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class LiteralType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new LiteralType();
        private static Any any = new AnyGT(null, 0, 1);
        private static Sequence seq = new SequenceGT(new ElementGrouping[]{any});

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isMixed() {
            return true;
        }

        public Type getParent() {
            return ExpressionType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                String string = (String)value[0].getValue();
                Object literal = string;
                try {
                    literal = string.indexOf(46) != -1 ? (Number)new Double(Double.parseDouble(string)) : (Number)new Integer(Integer.parseInt(string));
                }
                catch (NumberFormatException nonNumber) {
                    // empty catch block
                }
                LiteralExpression expr = factory.createLiteralExpression(literal);
                return expr;
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element, e);
            }
        }

        public String getName() {
            return "LiteralType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$LiteralExpression == null ? (class$org$geotools$filter$LiteralExpression = FilterComplexTypes.class$("org.geotools.filter.LiteralExpression")) : class$org$geotools$filter$LiteralExpression;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return element.getType() != null && this.getName().equals(element.getType().getName()) && (value instanceof LiteralExpression || value instanceof String);
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            AttributesImpl ai = new AttributesImpl();
            if (value instanceof String) {
                output.startElement(element.getNamespace(), element.getName(), ai);
                output.characters(value.toString());
                output.endElement(element.getNamespace(), element.getName());
                return;
            }
            LiteralExpression me = (LiteralExpression)value;
            output.startElement(element.getNamespace(), element.getName(), ai);
            switch (me.getType()) {
                case 104: {
                    if (me.getLiteral() instanceof Geometry) {
                        GMLSchema.getInstance().getElements()[29].getType().encode(GMLSchema.getInstance().getElements()[29], me.getLiteral(), output, hints);
                        break;
                    }
                }
                case 101: 
                case 102: 
                case 103: {
                    output.characters(me.getLiteral().toString());
                }
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class FunctionType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new FunctionType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", ExpressionType.getInstance()){

            public int getMinOccurs() {
                return 0;
            }

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        }};
        private static Sequence seq = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("name", XSISimpleTypes.String.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public Type getParent() {
            return ExpressionType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) {
            return null;
        }

        public String getName() {
            return "FunctionType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$FunctionExpression == null ? (class$org$geotools$filter$FunctionExpression = FilterComplexTypes.class$("org.geotools.filter.FunctionExpression")) : class$org$geotools$filter$FunctionExpression;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x20000) != 131072) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof FunctionExpression;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            FunctionExpression me = (FunctionExpression)value;
            AttributesImpl ai = new AttributesImpl();
            ai.addAttribute(element.getNamespace().toString(), "name", null, "string", me.getName());
            output.startElement(element.getNamespace(), element.getName(), ai);
            for (int i = 0; i < me.getArgCount(); ++i) {
                elems[0].getType().encode(null, me.getArgs()[i], output, hints);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinaryOperatorType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BinaryOperatorType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", ExpressionType.getInstance()){

            public int getMinOccurs() {
                return 2;
            }

            public int getMaxOccurs() {
                return 2;
            }
        }};
        private static Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ExpressionType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return "BinaryOperatorType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$MathExpression == null ? (class$org$geotools$filter$MathExpression = FilterComplexTypes.class$("org.geotools.filter.MathExpression")) : class$org$geotools$filter$MathExpression;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x10000) != 65536) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof MathExpression;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            MathExpression me = (MathExpression)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            elems[0].getType().encode(null, me.getLeftValue(), output, hints);
            elems[0].getType().encode(null, me.getRightValue(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class ExpressionType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.ExpressionType {
        private static final ComplexType instance = new ExpressionType();

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isAbstract() {
            return true;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return "ExpressionType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$Expression == null ? (class$org$geotools$filter$Expression = FilterComplexTypes.class$("org.geotools.filter.Expression")) : class$org$geotools$filter$Expression;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Expression;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            Expression e = (Expression)value;
            switch (e.getType()) {
                case 100: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    PropertyNameType.getInstance().encode(new FilterSchema.FilterElement("PropertyName", PropertyNameType.getInstance()), e, output, hints);
                    return;
                }
                case 114: {
                    FunctionType.getInstance().encode(element != null ? element : new FilterSchema.FilterElement("Function", FunctionType.getInstance()), e, output, hints);
                    return;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    LiteralType.getInstance().encode(element != null ? element : new FilterSchema.FilterElement("Literal", LiteralType.getInstance()), e, output, hints);
                    return;
                }
                case 105: {
                    BinaryOperatorType.getInstance().encode(element != null ? element : new FilterSchema.FilterElement("Add", BinaryOperatorType.getInstance()), e, output, hints);
                    return;
                }
                case 108: {
                    BinaryOperatorType.getInstance().encode(element != null ? element : new FilterSchema.FilterElement("Div", BinaryOperatorType.getInstance()), e, output, hints);
                    return;
                }
                case 107: {
                    BinaryOperatorType.getInstance().encode(element != null ? element : new FilterSchema.FilterElement("Mul", BinaryOperatorType.getInstance()), e, output, hints);
                    return;
                }
                case 106: {
                    BinaryOperatorType.getInstance().encode(element != null ? element : new FilterSchema.FilterElement("Sub", BinaryOperatorType.getInstance()), e, output, hints);
                    return;
                }
            }
            throw new OperationNotSupportedException("Expression " + e + " type not found");
        }
    }

    public static class Spatial_OperatorsType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Spatial_OperatorsType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("BBOX", EmptyType.getInstance()), new FilterSchema.FilterElement("Equals", EmptyType.getInstance()), new FilterSchema.FilterElement("Disjoint", EmptyType.getInstance()), new FilterSchema.FilterElement("Intersect", EmptyType.getInstance()), new FilterSchema.FilterElement("Touches", EmptyType.getInstance()), new FilterSchema.FilterElement("Crosses", EmptyType.getInstance()), new FilterSchema.FilterElement("Within", EmptyType.getInstance()), new FilterSchema.FilterElement("Contains", EmptyType.getInstance()), new FilterSchema.FilterElement("Overlaps", EmptyType.getInstance()), new FilterSchema.FilterElement("Beyond", EmptyType.getInstance()), new FilterSchema.FilterElement("DWithin", EmptyType.getInstance())};
        private static Choice choice = new ChoiceGT(elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Missing parameter for Spatial_OperatorsType");
            }
            if (value.length < 1) {
                throw new SAXException("Atleast one child element is required");
            }
            int v = 0;
            for (int i = 0; i < value.length; ++i) {
                v |= FilterCapabilitiesMask.findOperation(value[i].getElement().getName());
            }
            return new Integer(v);
        }

        public String getName() {
            return "Spatial_OperatorsType";
        }

        public Class getInstanceType() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = FilterComplexTypes.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class Spatial_CapabilitiesType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Spatial_CapabilitiesType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("Spatial_Operators", Spatial_OperatorsType.getInstance())};
        private static Sequence seq = new SequenceGT(elements);

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || value.length != 1) {
                throw new SAXException("Invalid parameters specified for Spatial_CapabilitiesType");
            }
            if (elements[0].getName().equals(value[0].getElement().getName())) {
                return (Integer)value[0].getValue();
            }
            throw new SAXException("Invalid child element: " + value[0].getElement().getName());
        }

        public String getName() {
            return "Spatial_CapabilitiesType";
        }

        public Class getInstanceType() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = FilterComplexTypes.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class Scalar_CapabilitiesType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Scalar_CapabilitiesType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("Logical_Operators", EmptyType.getInstance()), new FilterSchema.FilterElement("Comparison_Operators", Comparison_OperatorsType.getInstance()), new FilterSchema.FilterElement("Arithmetic_Operators", Arithmetic_OperatorsType.getInstance())};
        private static Choice choice = new ChoiceGT(elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Missing paramters for Scalar_CapabilitiesType");
            }
            if (value.length < 1) {
                throw new SAXException("Missing child value elements");
            }
            int val = 0;
            for (int i = 0; i < value.length; ++i) {
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    val |= 0x800;
                    continue;
                }
                if (elements[1].getName().equals(value[i].getElement().getName())) {
                    val |= ((Integer)value[i].getValue()).intValue();
                    continue;
                }
                if (elements[2].getName().equals(value[i].getElement().getName())) {
                    val |= ((Integer)value[i].getValue()).intValue();
                    continue;
                }
                throw new SAXException("Invalid child element: " + value[i].getElement().getName());
            }
            return new Integer(val);
        }

        public String getName() {
            return "Scalar_CapabilitiesType";
        }

        public Class getInstanceType() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = FilterComplexTypes.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class Filter_CapabilitiesType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Filter_CapabilitiesType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("Spatial_Capabilities", Spatial_CapabilitiesType.getInstance()), new FilterSchema.FilterElement("Scalar_Capabilities", Scalar_CapabilitiesType.getInstance())};
        private static Sequence seq = new SequenceGT(elements);

        public static ComplexType getInstance() {
            return instance;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Parameter missing for Filter_Capabilities Type");
            }
            if (value.length != 2) {
                throw new SAXException("Either there is an extra child, or too few child elements");
            }
            FilterCapabilitiesMask fc = new FilterCapabilitiesMask();
            if (elements[0].getName().equals(value[0].getElement().getName())) {
                fc.addType((short)((Integer)value[0].getValue()).intValue());
                if (!elements[1].getName().equals(value[1].getElement().getName())) throw new SAXException("Unknown element" + value[1].getElement().getName());
                fc.addType((short)((Integer)value[1].getValue()).intValue());
                return fc;
            } else {
                if (!elements[1].getName().equals(value[0].getElement().getName())) throw new SAXException("Unknown element" + value[0].getElement().getName());
                fc.addType((short)((Integer)value[0].getValue()).intValue());
                if (!elements[0].getName().equals(value[1].getElement().getName())) throw new SAXException("Unknown element" + value[1].getElement().getName());
                fc.addType((short)((Integer)value[1].getValue()).intValue());
            }
            return fc;
        }

        public String getName() {
            return "";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$FilterCapabilitiesMask == null ? (class$org$geotools$filter$FilterCapabilitiesMask = FilterComplexTypes.class$("org.geotools.filter.FilterCapabilitiesMask")) : class$org$geotools$filter$FilterCapabilitiesMask;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }
    }

    public static class FunctionsType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new FunctionsType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("Function_Names", Function_NamesType.getInstance())};
        private static Sequence seq = new SequenceGT(elements);

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return "FunctionsType";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class Function_NamesType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Function_NamesType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("Function_Name", Function_NameType.getInstance())};
        private static Sequence seq = new SequenceGT(elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return "Function_NamesType";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class Function_NameType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Function_NameType();

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Type getParent() {
            return XSISimpleTypes.String.getInstance();
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return "Function_NameType";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        public boolean isMixed() {
            return true;
        }
    }

    public static class Comparison_OperatorsType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Comparison_OperatorsType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("Simple_Comparisons", EmptyType.getInstance()), new FilterSchema.FilterElement("Like", EmptyType.getInstance()), new FilterSchema.FilterElement("Between", EmptyType.getInstance()), new FilterSchema.FilterElement("NullCheck", EmptyType.getInstance())};
        private static Choice choice = new ChoiceGT(elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Parameter missing for Comparison_OperatorsType");
            }
            if (value.length < 1) {
                throw new SAXException("Missing child element");
            }
            int t = 0;
            for (int i = 0; i < value.length; ++i) {
                t |= FilterCapabilitiesMask.findOperation(value[i].getElement().getName());
            }
            return new Integer(t);
        }

        public String getName() {
            return "Comparison_OperatorsType";
        }

        public Class getInstanceType() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = FilterComplexTypes.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class Arithmetic_OperatorsType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new Arithmetic_OperatorsType();
        private static Element[] elements = new Element[]{new FilterSchema.FilterElement("Simple_Arithmetic", EmptyType.getInstance()), new FilterSchema.FilterElement("Functions", FunctionsType.getInstance())};
        private static Choice choice = new ChoiceGT(elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Parameter missing for Comparison_OperatorsType");
            }
            if (value.length < 1) {
                throw new SAXException("Missing child element");
            }
            int t = 0;
            for (int i = 0; i < value.length; ++i) {
                t |= FilterCapabilitiesMask.findOperation(value[i].getElement().getName());
            }
            return new Integer(t);
        }

        public String getName() {
            return "Comparison_OperatorsType";
        }

        public Class getInstanceType() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = FilterComplexTypes.class$("java.lang.Integer")) : class$java$lang$Integer;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException(element.toString() + " encode value " + value);
        }
    }
}

