/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.xml.DocumentFactory;
import org.xml.sax.SAXException;

public class FCBuffer
extends Thread
implements FeatureReader {
    public static final int FINISH = -1;
    public static final int STOP = -2;
    protected static Logger logger = FCBuffer.getLogger();
    protected int state = 0;
    private Feature[] features;
    private int end;
    private int size;
    private int head;
    private int timeout = 1000;
    private URI document;
    protected SAXException exception = null;
    protected FeatureType ft = null;

    private FCBuffer() {
        super("Feature Collection Buffer");
    }

    protected FCBuffer(URI document, int capacity, int timeout, FeatureType ft) {
        super("Feature Collection Buffer");
        this.features = new Feature[capacity];
        this.timeout = timeout;
        this.document = document;
        this.head = 0;
        this.size = 0;
        this.end = 0;
        this.ft = ft;
    }

    private static final Logger getLogger() {
        Logger l = Logger.getLogger("org.geotools.xml.gml");
        l.setLevel(Level.WARNING);
        return l;
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.features.length;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected boolean addFeature(Feature f) {
        if (this.ft == null) {
            this.ft = f.getFeatureType();
        }
        if (this.size >= this.features.length) {
            return false;
        }
        this.features[this.end] = f;
        ++this.end;
        if (this.end == this.features.length) {
            this.end = 0;
        }
        ++this.size;
        return true;
    }

    public static FeatureReader getFeatureReader(URI document, int capacity) throws SAXException {
        return FCBuffer.getFeatureReader(document, capacity, 1000, null);
    }

    public static FeatureReader getFeatureReader(URI document, int capacity, FeatureType ft) throws SAXException {
        return FCBuffer.getFeatureReader(document, capacity, 1000, ft);
    }

    public static FeatureReader getFeatureReader(URI document, int capacity, int timeout) throws SAXException {
        return FCBuffer.getFeatureReader(document, capacity, timeout, null);
    }

    public static FeatureReader getFeatureReader(URI document, int capacity, int timeout, FeatureType ft) throws SAXException {
        FCBuffer fc = new FCBuffer(document, capacity, timeout, ft);
        fc.start();
        if (fc.exception != null) {
            throw fc.exception;
        }
        if (fc.getFeatureType() == null || fc.getFeatureType().getDefaultGeometry() == null || fc.getFeatureType().getDefaultGeometry().getCoordinateSystem() == null) {
            // empty if block
        }
        return fc;
    }

    public FeatureType getFeatureType() {
        if (this.ft != null) {
            return this.ft;
        }
        Date d = new Date(Calendar.getInstance().getTimeInMillis() + (long)this.timeout);
        while (this.ft == null && this.state != -1 && this.state != -2) {
            FCBuffer.yield();
            if (!d.before(Calendar.getInstance().getTime())) continue;
            this.exception = new SAXException("Timeout");
            this.state = -2;
        }
        if (this.state == -1 || this.state == -2) {
            return this.ft;
        }
        return this.ft;
    }

    public Feature next() throws IOException, NoSuchElementException {
        if (this.exception != null) {
            this.state = -2;
            IOException e = new IOException(this.exception.toString());
            e.initCause(this.exception);
            throw e;
        }
        --this.size;
        Feature f = this.features[this.head++];
        if (this.head == this.features.length) {
            this.head = 0;
        }
        return f;
    }

    public Feature peek() throws IOException, NoSuchElementException {
        if (this.exception != null) {
            this.state = -2;
            IOException e = new IOException(this.exception.toString());
            e.initCause(this.exception);
            throw e;
        }
        Feature f = this.features[this.head];
        return f;
    }

    public boolean hasNext() throws IOException {
        if (this.exception instanceof StopException) {
            return false;
        }
        if (this.exception != null) {
            IOException e = new IOException(this.exception.toString());
            e.initCause(this.exception);
            throw e;
        }
        logger.finest("hasNext " + this.size);
        Date d = new Date(Calendar.getInstance().getTimeInMillis() + (long)this.timeout);
        while (this.size <= 1 && this.state != -1 && this.state != -2) {
            if (this.exception != null) {
                this.state = -2;
                IOException e = new IOException(this.exception.toString());
                e.initCause(this.exception);
                throw e;
            }
            logger.finest("waiting for parser");
            Thread.yield();
            if (!d.before(Calendar.getInstance().getTime())) continue;
            this.exception = new SAXException("Timeout");
            this.state = -2;
        }
        if (this.state == -2) {
            if (this.exception != null) {
                IOException e = new IOException(this.exception.toString());
                e.initCause(this.exception);
                throw e;
            }
            return false;
        }
        if (this.state == -1) {
            return this.size != 0;
        }
        if (this.size == 0) {
            this.state = -2;
            if (this.exception != null) {
                throw new IOException(this.exception.toString());
            }
            throw new IOException("There was an error");
        }
        return true;
    }

    public void close() {
        this.state = -2;
        this.interrupt();
    }

    public void run() {
        HashMap<String, FCBuffer> hints = new HashMap<String, FCBuffer>();
        hints.put("org.geotools.xml.gml.STREAM_HINT", this);
        try {
            DocumentFactory.getInstance(this.document, hints);
        }
        catch (StopException e) {
            this.exception = e;
            this.state = -2;
            FCBuffer.yield();
        }
        catch (SAXException e) {
            this.exception = e;
            this.state = -2;
            FCBuffer.yield();
        }
    }

    public static class StopException
    extends SAXException {
        StopException() {
            super("Stopping");
        }
    }
}

