/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.gml.FCBuffer;
import org.geotools.xml.gml.GMLComplexTypes;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.AttributeValue;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.AttributeValueGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.xLink.XLinkSchema;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GMLSchema
implements Schema {
    public static final URI NAMESPACE = GMLSchema.makeURI("http://www.opengis.net/gml");
    private static Attribute[] attributes = AttributeList.attributes1;
    private static ComplexType[] complexTypes = GMLSchema.loadComplexTypes();
    private static Element[] elements = GMLSchema.loadElements();
    private static AttributeGroup[] attributeGroups = new AttributeGroup[]{new GMLAssociationAttributeGroup()};
    private static SimpleType[] simpleTypes = new SimpleType[]{new GMLNullType()};
    private static Schema instance = new GMLSchema();
    public static final int BOX = 41;
    private static Schema[] imports = new Schema[]{XLinkSchema.getInstance()};
    static /* synthetic */ Class class$java$lang$String;

    private GMLSchema() {
    }

    public static void setLogLevel(Level l) {
        GMLComplexTypes.logger.setLevel(l);
        FCBuffer.logger.setLevel(l);
    }

    public AttributeGroup[] getAttributeGroups() {
        return attributeGroups;
    }

    public Attribute[] getAttributes() {
        return attributes;
    }

    public int getBlockDefault() {
        return 0;
    }

    private static final ComplexType[] loadComplexTypes() {
        ComplexType[] complexTypes1 = new ComplexType[]{GMLComplexTypes.AbstractGeometryType.getInstance(), GMLComplexTypes.AbstractGeometryCollectionBaseType.getInstance(), GMLComplexTypes.GeometryAssociationType.getInstance(), GMLComplexTypes.PointMemberType.getInstance(), GMLComplexTypes.LineStringMemberType.getInstance(), GMLComplexTypes.PolygonMemberType.getInstance(), GMLComplexTypes.LinearRingMemberType.getInstance(), GMLComplexTypes.PointType.getInstance(), GMLComplexTypes.LineStringType.getInstance(), GMLComplexTypes.LinearRingType.getInstance(), GMLComplexTypes.BoxType.getInstance(), GMLComplexTypes.PolygonType.getInstance(), GMLComplexTypes.GeometryCollectionType.getInstance(), GMLComplexTypes.MultiPointType.getInstance(), GMLComplexTypes.MultiLineStringType.getInstance(), GMLComplexTypes.MultiPolygonType.getInstance(), GMLComplexTypes.CoordType.getInstance(), GMLComplexTypes.CoordinatesType.getInstance(), GMLComplexTypes.AbstractFeatureType.getInstance(), GMLComplexTypes.AbstractFeatureCollectionsBaseType.getInstance(), GMLComplexTypes.AbstractFeatureCollectionType.getInstance(), GMLComplexTypes.GeometryPropertyType.getInstance(), GMLComplexTypes.FeatureAssociationType.getInstance(), GMLComplexTypes.BoundingShapeType.getInstance(), GMLComplexTypes.PointPropertyType.getInstance(), GMLComplexTypes.PolygonPropertyType.getInstance(), GMLComplexTypes.LineStringPropertyType.getInstance(), GMLComplexTypes.MultiPointPropertyType.getInstance(), GMLComplexTypes.MultiLineStringPropertyType.getInstance(), GMLComplexTypes.MultiPolygonPropertyType.getInstance(), GMLComplexTypes.MultiGeometryPropertyType.getInstance()};
        return complexTypes1;
    }

    public ComplexType[] getComplexTypes() {
        return complexTypes;
    }

    private static final Element[] loadElements() {
        Element[] elements1 = new Element[48];
        elements1[0] = new GMLElement("_Feature", GMLComplexTypes.AbstractFeatureType.getInstance(), 1, 1, true, null);
        elements1[1] = new GMLElement("featureCollection", GMLComplexTypes.AbstractFeatureCollectionType.getInstance(), 1, 1, true, elements1[0]);
        elements1[2] = new GMLElement("featureMember", GMLComplexTypes.FeatureAssociationType.getInstance(), 1, 1, false, null);
        elements1[3] = new GMLElement("_geometryProperty", GMLComplexTypes.GeometryAssociationType.getInstance(), 1, 1, true, null);
        elements1[4] = new GMLElement("geometryProperty", GMLComplexTypes.GeometryAssociationType.getInstance(), 1, 1, false, null);
        elements1[5] = new GMLElement("boundedBy", GMLComplexTypes.BoundingShapeType.getInstance(), 1, 1, false, null);
        elements1[6] = new GMLElement("pointProperty", GMLComplexTypes.PointPropertyType.getInstance(), 1, 1, false, elements1[3]);
        elements1[7] = new GMLElement("polygonProperty", GMLComplexTypes.PolygonPropertyType.getInstance(), 1, 1, false, elements1[3]);
        elements1[8] = new GMLElement("lineStringProperty", GMLComplexTypes.LineStringPropertyType.getInstance(), 1, 1, false, elements1[3]);
        elements1[9] = new GMLElement("multiPointProperty", GMLComplexTypes.MultiPointPropertyType.getInstance(), 1, 1, false, elements1[3]);
        elements1[10] = new GMLElement("multiLineStringProperty", GMLComplexTypes.MultiLineStringPropertyType.getInstance(), 1, 1, false, elements1[3]);
        elements1[11] = new GMLElement("multiPolygonProperty", GMLComplexTypes.MultiPolygonPropertyType.getInstance(), 1, 1, false, elements1[3]);
        elements1[12] = new GMLElement("multiGeometryProperty", GMLComplexTypes.MultiGeometryPropertyType.getInstance(), 1, 1, false, elements1[3]);
        elements1[13] = new GMLElement("location", GMLComplexTypes.PointPropertyType.getInstance(), 1, 1, false, elements1[6]);
        elements1[14] = new GMLElement("centerOf", GMLComplexTypes.PointPropertyType.getInstance(), 1, 1, false, elements1[6]);
        elements1[15] = new GMLElement("position", GMLComplexTypes.PointPropertyType.getInstance(), 1, 1, false, elements1[6]);
        elements1[16] = new GMLElement("extentOf", GMLComplexTypes.PolygonPropertyType.getInstance(), 1, 1, false, elements1[7]);
        elements1[17] = new GMLElement("coverage", GMLComplexTypes.PolygonPropertyType.getInstance(), 1, 1, false, elements1[7]);
        elements1[18] = new GMLElement("edgeOf", GMLComplexTypes.LineStringPropertyType.getInstance(), 1, 1, false, elements1[8]);
        elements1[19] = new GMLElement("centerLineOf", GMLComplexTypes.LineStringPropertyType.getInstance(), 1, 1, false, elements1[8]);
        elements1[20] = new GMLElement("multiLocation", GMLComplexTypes.MultiPointPropertyType.getInstance(), 1, 1, false, elements1[9]);
        elements1[21] = new GMLElement("multiCenterOf", GMLComplexTypes.MultiPointPropertyType.getInstance(), 1, 1, false, elements1[9]);
        elements1[22] = new GMLElement("multiPosition", GMLComplexTypes.MultiPointPropertyType.getInstance(), 1, 1, false, elements1[9]);
        elements1[23] = new GMLElement("multiCenterLineOf", GMLComplexTypes.MultiLineStringPropertyType.getInstance(), 1, 1, false, elements1[10]);
        elements1[24] = new GMLElement("multiEdgeOf", GMLComplexTypes.MultiLineStringPropertyType.getInstance(), 1, 1, false, elements1[10]);
        elements1[25] = new GMLElement("multiCoverage", GMLComplexTypes.MultiPolygonPropertyType.getInstance(), 1, 1, false, elements1[11]);
        elements1[26] = new GMLElement("multiExtentOf", GMLComplexTypes.MultiPolygonPropertyType.getInstance(), 1, 1, false, elements1[11]);
        elements1[28] = new GMLElement("name", XSISimpleTypes.String.getInstance(), 1, 1, false, null);
        elements1[27] = new GMLElement("description", XSISimpleTypes.String.getInstance(), 1, 1, false, null);
        elements1[29] = new GMLElement("_Geometry", GMLComplexTypes.AbstractGeometryType.getInstance(), 1, 1, true, null);
        elements1[30] = new GMLElement("GeometryCollection", GMLComplexTypes.GeometryCollectionType.getInstance(), 1, 1, true, elements1[29]);
        elements1[31] = new GMLElement("geometryMember", GMLComplexTypes.GeometryAssociationType.getInstance(), 1, 1, false, null);
        elements1[32] = new GMLElement("pointMember", GMLComplexTypes.PointMemberType.getInstance(), 1, 1, false, elements1[31]);
        elements1[33] = new GMLElement("lineStringMember", GMLComplexTypes.PointMemberType.getInstance(), 1, 1, false, elements1[31]);
        elements1[34] = new GMLElement("polygonMember", GMLComplexTypes.PointMemberType.getInstance(), 1, 1, false, elements1[31]);
        elements1[35] = new GMLElement("outerBoundaryIs", GMLComplexTypes.LinearRingMemberType.getInstance(), 1, 1, false, null);
        elements1[36] = new GMLElement("innerBoundaryIs", GMLComplexTypes.LinearRingMemberType.getInstance(), 1, 1, false, null);
        elements1[37] = new GMLElement("Point", GMLComplexTypes.PointType.getInstance(), 1, 1, false, elements1[29]);
        elements1[38] = new GMLElement("LineString", GMLComplexTypes.LineStringType.getInstance(), 1, 1, false, elements1[29]);
        elements1[39] = new GMLElement("LinearRing", GMLComplexTypes.LinearRingType.getInstance(), 1, 1, false, elements1[29]);
        elements1[40] = new GMLElement("Polygon", GMLComplexTypes.PolygonType.getInstance(), 1, 1, false, elements1[29]);
        elements1[41] = new GMLElement("Box", GMLComplexTypes.BoxType.getInstance(), 1, 1, false, null);
        elements1[42] = new GMLElement("MultiGeometry", GMLComplexTypes.GeometryCollectionType.getInstance(), 1, 1, false, elements1[29]);
        elements1[43] = new GMLElement("MultiPoint", GMLComplexTypes.MultiPointType.getInstance(), 1, 1, false, elements1[29]);
        elements1[44] = new GMLElement("MultiLineString", GMLComplexTypes.MultiLineStringType.getInstance(), 1, 1, false, elements1[29]);
        elements1[45] = new GMLElement("MultiPolygon", GMLComplexTypes.MultiPolygonType.getInstance(), 1, 1, false, elements1[29]);
        elements1[46] = new GMLElement("coord", GMLComplexTypes.CoordType.getInstance(), 1, 1, false, null);
        elements1[47] = new GMLElement("coordinates", GMLComplexTypes.CoordinatesType.getInstance(), 1, 1, false, null);
        return elements1;
    }

    public boolean isElementFormDefault() {
        return true;
    }

    public Element[] getElements() {
        return elements;
    }

    public int getFinalDefault() {
        return 0;
    }

    public Group[] getGroups() {
        return new Group[0];
    }

    public String getId() {
        return null;
    }

    public Schema[] getImports() {
        return imports;
    }

    public SimpleType[] getSimpleTypes() {
        return simpleTypes;
    }

    public URI getTargetNamespace() {
        return NAMESPACE;
    }

    public URI getURI() {
        return NAMESPACE;
    }

    public String getVersion() {
        return "2.1.2";
    }

    private static URI makeURI(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean includesURI(URI uri) {
        return true;
    }

    public boolean isAttributeFormDefault() {
        return false;
    }

    public String getPrefix() {
        return "gml";
    }

    public static Schema getInstance() {
        return instance;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static class GMLNullType
    implements SimpleType {
        GMLNullType() {
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public Type getParent() {
            return null;
        }

        public int getFinal() {
            return 0;
        }

        public String getId() {
            return null;
        }

        public String getName() {
            return "NullType";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attr, Map hints) throws SAXException {
            if (value == null || value.length != 1 || value[0].getValue() == null) {
                return null;
            }
            if (!(value[0].getValue() instanceof String)) {
                throw new SAXException("SimpleTypes can only evaluate Strings");
            }
            String text = (String)value[0].getValue();
            Object[] enumeration = new String[]{"inapplicable", "unknown", "unavailable", "missing"};
            if (Arrays.binarySearch(enumeration, text = text.trim()) >= 0) {
                return value[0].getValue();
            }
            throw new SAXException("The value passed in to gml:NullType was not one of the allowable enumerated values.");
        }

        public Class getInstanceType() {
            return class$java$lang$String == null ? (class$java$lang$String = GMLSchema.class$("java.lang.String")) : class$java$lang$String;
        }

        public AttributeValue toAttribute(Attribute attribute, Object value, Map hints) {
            Object[] enumeration = new String[]{"inapplicable", "unknown", "unavailable", "missing"};
            if (Arrays.binarySearch(enumeration, value) < 0) {
                return new AttributeValueGT(attribute, null);
            }
            return new AttributeValueGT(attribute, value.toString());
        }

        public boolean canCreateAttributes(Attribute attribute, Object value, Map hints) {
            Object[] enumeration = new String[]{"inapplicable", "unknown", "unavailable", "missing"};
            return Arrays.binarySearch(enumeration, value) < 0;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            Object[] enumeration = new String[]{"inapplicable", "unknown", "unavailable", "missing"};
            return Arrays.binarySearch(enumeration, value) < 0;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            output.startElement(element.getNamespace(), element.getName(), null);
            output.characters(value.toString());
            output.endElement(element.getNamespace(), element.getName());
        }

        public int getChildType() {
            return 4;
        }

        public SimpleType[] getParents() {
            return new SimpleType[]{XSISimpleTypes.String.getInstance()};
        }

        public Facet[] getFacets() {
            return new Facet[]{new FacetGT(1, "inapplicable"), new FacetGT(1, "unknown"), new FacetGT(1, "unavailable"), new FacetGT(1, "missing")};
        }

        public Element findChildElement(String name) {
            return null;
        }
    }

    static class GMLAssociationAttributeGroup
    implements AttributeGroup {
        static final Attribute[] attributes1 = new Attribute[]{new GMLAttribute("remoteSchema", XSISimpleTypes.AnyURI.getInstance())};
        static final AttributeGroup child = XLinkSchema.SimpleLink.getInstance();

        GMLAssociationAttributeGroup() {
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public String getAnyAttributeNameSpace() {
            return child.getAnyAttributeNameSpace();
        }

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getId() {
            return null;
        }

        public String getName() {
            return "AssociationAttributeGroup";
        }
    }

    static class GMLAttribute
    implements Attribute {
        String name;
        String def = null;
        SimpleType simpleType;
        int use = 0;

        private GMLAttribute() {
        }

        public GMLAttribute(String name, SimpleType simpleType) {
            this.name = name;
            this.simpleType = simpleType;
        }

        public GMLAttribute(String name, SimpleType simpleType, int use) {
            this.name = name;
            this.simpleType = simpleType;
            this.use = use;
        }

        public GMLAttribute(String name, SimpleType simpleType, int use, String def) {
            this.name = name;
            this.simpleType = simpleType;
            this.use = use;
            this.def = def;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public String getDefault() {
            return this.def;
        }

        public String getFixed() {
            return null;
        }

        public boolean isForm() {
            return false;
        }

        public String getId() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public int getUse() {
            return this.use;
        }

        public SimpleType getSimpleType() {
            return this.simpleType;
        }
    }

    static abstract class GMLComplexType
    implements ComplexType {
        GMLComplexType() {
        }

        public int getBlock() {
            return 0;
        }

        public int getFinal() {
            return 0;
        }

        public String getId() {
            return null;
        }

        public boolean isMixed() {
            return false;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        static GMLComplexType getInstance() {
            return null;
        }

        public boolean isDerived() {
            return false;
        }

        public Type getParent() {
            return null;
        }

        public boolean cache(Element e, Map m) {
            return true;
        }
    }

    static class GMLElement
    implements Element {
        boolean abstracT = false;
        int max;
        int min;
        String name;
        Type type;
        Element substitutionGroup;

        private GMLElement() {
        }

        public GMLElement(String name, Type type, int min, int max, boolean abstracT, Element substitutionGroup) {
            this.abstracT = abstracT;
            this.max = max;
            this.min = min;
            this.name = name;
            this.type = type;
            this.substitutionGroup = substitutionGroup;
        }

        public GMLElement(GMLElement element, int min, int max) {
            this.abstracT = element.isAbstract();
            this.max = max;
            this.min = min;
            this.name = element.getName();
            this.type = element.getType();
            this.substitutionGroup = element.getSubstitutionGroup();
        }

        public Element findChildElement(String name1) {
            if (this.name != null && this.name.equals(name1)) {
                return this;
            }
            return null;
        }

        public int getGrouping() {
            return 1;
        }

        public boolean isAbstract() {
            return this.abstracT;
        }

        public int getBlock() {
            return 0;
        }

        public String getDefault() {
            return null;
        }

        public int getFinal() {
            return 0;
        }

        public String getFixed() {
            return null;
        }

        public boolean isForm() {
            return false;
        }

        public String getId() {
            return null;
        }

        public int getMaxOccurs() {
            return this.max;
        }

        public int getMinOccurs() {
            return this.min;
        }

        public String getName() {
            return this.name;
        }

        public boolean isNillable() {
            return false;
        }

        public Element getSubstitutionGroup() {
            return this.substitutionGroup;
        }

        public Type getType() {
            return this.type;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }
    }

    static class AttributeList {
        static final Attribute[] attributes1 = new Attribute[]{new GMLAttribute("remoteSchema", XSISimpleTypes.AnyURI.getInstance())};

        AttributeList() {
        }
    }
}

