/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app;

import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditingNotificationObserver
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditingNotificationObserver.class);
    private VCSGisManager manager;

    private VCSGisManager getManager() {
        if (this.manager == null) {
            this.manager = VCSGisLocator.getManager();
        }
        return this.manager;
    }

    private VCSGisWorkspace getWorkspace(FeatureStore store) {
        return this.getManager().getWorkspace(store);
    }

    public void update(Observable o, Object notification) {
        EditingNotification n = (EditingNotification)notification;
        try {
            if ("BEFORE_ENTER_EDITING_STORE".equalsIgnoreCase(n.getType())) {
                FeatureStore store = n.getFeatureStore();
                VCSGisWorkspace ws = this.getWorkspace(store);
                if (ws == null) {
                    return;
                }
                VCSGisWorkspaceEntity lentity = ws.getWorkspaceEntity(store.getName());
                if (lentity == null) {
                    return;
                }
                int maskStatus = lentity.getState();
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                I18nManager i18n = ToolsLocator.getI18nManager();
                if ((maskStatus & 0x100) == 256) {
                    dialogs.messageDialog(i18n.getTranslation("_The_table_XtablenameX_under_control_version_is_marked_as_corrupt", new String[]{lentity.getEntityName()}) + "\n" + i18n.getTranslation("_Changes_you_make_cannot_be_committed"), null, i18n.getTranslation("_Start_editing"), 2, "_The_table_under_control_version_is_marked_as_corrupt");
                    return;
                }
                if ((maskStatus & 0x80) == 128) {
                    dialogs.messageDialog(i18n.getTranslation("_The_table_XtablenameX_under_control_version_is_marked_as_offline", new String[]{lentity.getEntityName()}) + "\n" + i18n.getTranslation("_Changes_you_make_cannot_be_committed"), null, i18n.getTranslation("_Start_editing"), 2, "_The_table_under_control_version_is_marked_as_disconnected");
                    return;
                }
            } else if ("BEFORE_EXIT_EDITING_STORE".equalsIgnoreCase(n.getType())) {
                FeatureStore store = n.getFeatureStore();
                VCSGisWorkspace ws = this.getWorkspace(store);
                if (ws == null) {
                    return;
                }
                VCSGisWorkspaceEntity lentity = ws.getWorkspaceEntity(store.getName());
                if (lentity == null) {
                    return;
                }
                if (store.getDefaultFeatureTypeQuietly().get(lentity.getFeatureIdFieldName()) == null) {
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    dialogs.messageDialog(i18n.getTranslation("_The_XFieldNameX_field_of_the_XTableNameX_under_version_control_does_not_exist", new String[]{lentity.getEntityName()}) + "\n" + i18n.getTranslation("_Cancel_editing_and_download_the_table_from_the_repository_again_to_correct_the_problem") + "\n" + i18n.getTranslation("_Changes_made_during_this_editing_session_will_be_lost"), null, i18n.getTranslation("_Stop_editing"), 2, "_Missing_vcsgis_pkfield_after_terminate_editing");
                    n.cancel();
                    return;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Can't process notification '" + n.getType() + "'.", t);
            n.abort();
        }
    }
}

