/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;

public class VCSGisExecuteTopologyPlanExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        if (StringUtils.equalsIgnoreCase((CharSequence)actionCommand, (CharSequence)"tools-vcsgis-execute-topologyplan")) {
            IView view = this.getActiveView();
            if (view == null) {
                return;
            }
            List<FLyrVect> activeLayers = this.getActiveLayers(view, t -> {
                try {
                    FeatureStore store = t.getFeatureStore();
                    if (store == null) {
                        return false;
                    }
                    DataServerExplorer explorer = store.getExplorer();
                    return explorer instanceof JDBCServerExplorer;
                }
                catch (Exception ex) {
                    logger.warn("Can't check if the layer can be valid", (Throwable)ex);
                    return false;
                }
            });
            if (activeLayers.isEmpty()) {
                return;
            }
            FLyrVect layer = activeLayers.get(0);
            this.doExecuteTopologyPlan(layer.getFeatureStore());
        }
    }

    public boolean isEnabled() {
        IView view = this.getActiveView();
        if (view == null) {
            return false;
        }
        List<FLyrVect> activeLayers = this.getActiveLayers(view, t -> {
            boolean bl;
            FeatureStore store;
            DataServerExplorer explorer;
            block5: {
                explorer = null;
                store = t.getFeatureStore();
                if (store != null) break block5;
                boolean bl2 = false;
                DisposeUtils.disposeQuietly(explorer);
                return bl2;
            }
            try {
                explorer = store.getExplorer();
                bl = explorer instanceof JDBCServerExplorer;
            }
            catch (Exception ex) {
                boolean bl3;
                try {
                    logger.warn("Can't check if the layer can be valid", (Throwable)ex);
                    bl3 = false;
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(explorer);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)explorer);
                return bl3;
            }
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return bl;
        });
        return activeLayers.size() == 1;
    }

    public boolean isVisible() {
        IView view = this.getActiveView();
        if (view == null) {
            return false;
        }
        try {
            Class.forName("org.gvsig.topology.lib.api.TopologyManager");
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }

    public void doExecuteTopologyPlan(FeatureStore store) {
        try {
            JDBCServerExplorer explorer = (JDBCServerExplorer)store.getExplorer();
            JDBCServerExplorerParameters params = explorer.getParameters();
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            if (!manager.isWorkspace(params)) {
                dialogs.messageDialog("_The_selected_layer_does_not_belong_to_a_working_copy", "_VCS_Execute_topology_plan", 1);
                return;
            }
            VCSGisWorkspace ws = manager.openWorkspace(explorer);
            VCSGisWorkspaceEntity entity0 = ws.getWorkspaceEntity(store.getName());
            if (entity0 == null) {
                dialogs.messageDialog("_The_selected_layer_does_not_belong_to_a_working_copy", "_VCS_Execute_topology_plan", 1);
                return;
            }
            ws.updateEntitiesFromRepository(null);
            ws.updateTopologyPlansFromRepository(null);
            VCSGisWorkspaceEntity entity = ws.getWorkspaceEntity(store.getName());
            if (StringUtils.isBlank((CharSequence)entity.getTopologyPlanCode())) {
                dialogs.messageDialog("_The_selected_layer_does_not_have_a_topology_plan_assigned", "_VCS_Execute_topology_plan", 1);
                return;
            }
            VCSGisTopologyPlan topologyPlan = ws.getTopologyPlan(entity.getTopologyPlanCode());
            if (topologyPlan == null || StringUtils.isBlank((CharSequence)topologyPlan.getData())) {
                dialogs.messageDialog("_The_topology_plan_assigned_to_the_selected_layer_does_not_exist", "_VCS_Execute_topology_plan", 1);
                return;
            }
            VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
            Thread th = new Thread(() -> swingManager.executeTopologyPlan(ws, (VCSGisEntity)entity, false), "VCSRunTopologyPlan");
            th.start();
        }
        catch (Exception ex) {
            logger.warn("Can't execute topology plan from '" + store.getFullName() + "'", (Throwable)ex);
        }
    }

    private IView getActiveView() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        return view;
    }

    private List<FLyrVect> getActiveLayers(IView view, Predicate<FLyrVect> valid) {
        FLayer[] actives;
        if (view == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FLyrVect> layers = new ArrayList<FLyrVect>();
        ViewDocument viewDocument = view.getViewDocument();
        for (FLayer layer : actives = viewDocument.getMapContext().getLayers().getActives()) {
            if (!(layer instanceof FLyrVect) || !valid.test((FLyrVect)layer)) continue;
            layers.add((FLyrVect)layer);
        }
        return layers;
    }
}

