/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ListModel;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.json.Json;
import org.gvsig.json.JsonArrayBuilder;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.vcsgis.app.FeatureStoresTreeModel;
import org.gvsig.vcsgis.app.addlayer.LayersWithGroup;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisSwingServicesImpl
implements VCSGisSwingServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisSwingServicesImpl.class);
    private static final String VCSGISMODELS_PROJECT_PROPERTY = "VCSGisModels";
    private Map<Integer, ISymbol> highlightedPolygonSymbols;
    private Map<Integer, ISymbol> highlightedLineSymbols;
    private Map<Integer, ISymbol> highlightedPointSymbols;

    public TreeModel getFeatureStoresTreeModel() {
        return new FeatureStoresTreeModel();
    }

    public ListModel getFeatureStoresListModel() {
        DefaultListModel<FeatureStore> model = new DefaultListModel<FeatureStore>();
        ApplicationManager appManager = ApplicationLocator.getApplicationManager();
        Project project = appManager.getCurrentProject();
        List tables = project.getDocuments(TableManager.TYPENAME);
        for (Document document : tables) {
            TableDocument table = (TableDocument)document;
            FeatureStore tableStore = table.getFeatureStore();
            if (tableStore == null) continue;
            model.addElement(tableStore);
        }
        return model;
    }

    public void addTableToProject(VCSGisWorkspace ws, FeatureStore store) {
        ApplicationManager appManager = ApplicationLocator.getApplicationManager();
        DocumentManager tableManager = appManager.getProjectManager().getDocumentManager(TableManager.TYPENAME);
        Project project = appManager.getCurrentProject();
        TableDocument tableDoc = (TableDocument)tableManager.createDocument();
        tableDoc.setName(store.getName());
        tableDoc.setStore(store);
        project.addDocument((Document)tableDoc);
    }

    public ComboBoxModel getViewDocumentsComboBoxModel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_Select_a_view"), null));
        ApplicationManager appManager = ApplicationLocator.getApplicationManager();
        Project project = appManager.getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document document : views) {
            ViewDocument view = (ViewDocument)document;
            model.addElement(new LabeledValueImpl(view.getName(), (Object)view));
        }
        return model;
    }

    public void addLayerToView(FeatureStore store, LabeledValue labeledView, String groupName, String name, boolean replaceLayerIfExists) {
        ViewDocument view = labeledView == null ? null : (labeledView.getValue() == null ? null : (ViewDocument)labeledView.getValue());
        this.addLayerToView(store, view, groupName, name, replaceLayerIfExists);
    }

    private void addLayerToView(FeatureStore store, ViewDocument view, String groupName, String name, boolean replaceLayerIfExists) {
        try {
            String layerName;
            if (store == null) {
                return;
            }
            if (view == null) {
                IView viewWin = this.getActiveView();
                if (viewWin == null) {
                    return;
                }
                view = viewWin.getViewDocument();
            }
            if (StringUtils.isBlank((CharSequence)(layerName = name))) {
                layerName = store.getName();
            }
            FLayer layer = MapContextLocator.getMapContextManager().createLayer(layerName, (DataStore)store);
            LayersWithGroup helper = new LayersWithGroup(view.getMapContext());
            helper.add(groupName, name, layer);
            helper.updateMapContext(true, replaceLayerIfExists);
        }
        catch (Exception ex) {
            VCSGisManager manager = VCSGisLocator.getManager();
            throw new VCSGisRuntimeException(18, manager.getErrorMessage(18), (Throwable)ex);
        }
    }

    public void highlight(int mode, Geometry geom) {
        this.highlight(mode, geom, null);
    }

    public void highlight(int mode, Geometry geom, FeatureStore store) {
        List<ViewDocument> viewList;
        if (this.highlightedPointSymbols == null) {
            this.highlightedPointSymbols = new HashMap<Integer, ISymbol>();
            this.highlightedLineSymbols = new HashMap<Integer, ISymbol>();
            this.highlightedPolygonSymbols = new HashMap<Integer, ISymbol>();
            try {
                ISymbol[] symbols;
                File pluginfolder = PluginsLocator.getManager().getPlugin((Object)this).getPluginDirectory();
                File folder = new File(pluginfolder, "symbols");
                block26: for (ISymbol symbol : symbols = MapContextLocator.getSymbolManager().loadSymbols(folder)) {
                    String symbolid;
                    if (!(symbol instanceof ISymbol_v2)) continue;
                    switch (symbolid = ((ISymbol_v2)symbol).getID()) {
                        case "vcsgis-repository-polygon": {
                            this.highlightedPolygonSymbols.put(1, symbol);
                            continue block26;
                        }
                        case "vcsgis-repository-line": {
                            this.highlightedLineSymbols.put(1, symbol);
                            continue block26;
                        }
                        case "vcsgis-repository-point": {
                            this.highlightedPointSymbols.put(1, symbol);
                            continue block26;
                        }
                        case "vcsgis-workspace-polygon": {
                            this.highlightedPolygonSymbols.put(2, symbol);
                            continue block26;
                        }
                        case "vcsgis-workspace-line": {
                            this.highlightedLineSymbols.put(2, symbol);
                            continue block26;
                        }
                        case "vcsgis-workspace-point": {
                            this.highlightedPointSymbols.put(2, symbol);
                            continue block26;
                        }
                        case "vcsgis-workspace-previous-polygon": {
                            this.highlightedPolygonSymbols.put(3, symbol);
                            continue block26;
                        }
                        case "vcsgis-workspace-previous-line": {
                            this.highlightedLineSymbols.put(3, symbol);
                            continue block26;
                        }
                        case "vcsgis-workspace-previous-point": {
                            this.highlightedPointSymbols.put(3, symbol);
                        }
                    }
                }
            }
            catch (Exception pluginfolder) {
                // empty catch block
            }
        }
        if (store == null) {
            ApplicationManager application = ApplicationLocator.getManager();
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            viewList = new ArrayList<ViewDocument>();
            viewList.add(viewdoc);
        } else {
            viewList = this.getViewDocumentsHavingAStore(store);
        }
        for (ViewDocument viewDoc : viewList) {
            String name = "unknown";
            try {
                name = viewDoc.getName();
                MapContext mapContext = viewDoc.getMapContext();
                GraphicLayer gl = mapContext.getGraphicsLayer();
                if (geom != null) {
                    ISymbol symbol;
                    symbol = null;
                    if (geom instanceof Point || geom instanceof MultiPoint) {
                        symbol = this.highlightedPointSymbols.get(mode);
                    } else if (geom instanceof Curve || geom instanceof MultiCurve) {
                        symbol = this.highlightedLineSymbols.get(mode);
                    } else if (geom instanceof Surface || geom instanceof MultiSurface) {
                        symbol = this.highlightedPolygonSymbols.get(mode);
                    }
                    if (symbol != null) {
                        int symbolid = gl.getSymbolId(symbol);
                        if (symbolid < 0) {
                            gl.addSymbol(symbol);
                            symbolid = gl.getSymbolId(symbol);
                        }
                        gl.addGraphic("vcsgis-highlighted", geom, symbolid);
                    }
                }
                mapContext.invalidate();
            }
            catch (Exception ex) {
                LOGGER.warn("Error highlighting elements in graphics layer of view '" + name + "'", (Throwable)ex);
            }
        }
    }

    public void centerActiveViewToGeometry(Geometry geometry) {
        IView view;
        if (geometry != null && (view = this.getActiveView()) != null) {
            ViewDocument viewDocument = view.getViewDocument();
            viewDocument.center(geometry.getEnvelope());
        }
    }

    public void centerViewsHavingAStoreToGeometry(FeatureStore store, Geometry geometry) {
        if (geometry != null) {
            List<ViewDocument> views = this.getViewDocumentsHavingAStore(store);
            for (ViewDocument view : views) {
                if (view == null) continue;
                view.center(geometry.getEnvelope());
            }
        }
    }

    public void zoomActiveViewToGeometry(Geometry geometry) {
        IView view;
        if (geometry != null && (view = this.getActiveView()) != null) {
            ViewDocument viewDocument = view.getViewDocument();
            viewDocument.getMapContext().getViewPort().setEnvelope(geometry.getEnvelope());
        }
    }

    public void zoomViewsHavingAStoreToGeometry(FeatureStore store, Geometry geometry) {
        if (geometry != null) {
            List<ViewDocument> views = this.getViewDocumentsHavingAStore(store);
            for (ViewDocument view : views) {
                if (view == null) continue;
                view.getMapContext().getViewPort().setEnvelope(geometry.getEnvelope());
            }
        }
    }

    private IView getActiveView() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        return view;
    }

    public void cleanHighligthed() {
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        Project project = projectManager.getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document doc : views) {
            String name = "unknown";
            try {
                name = doc.getName();
                ViewDocument viewdoc = (ViewDocument)doc;
                MapContext mapContext = viewdoc.getMapContext();
                GraphicLayer gl = mapContext.getGraphicsLayer();
                if (!gl.removeGraphics("vcsgis-highlighted")) continue;
                mapContext.invalidate();
            }
            catch (Exception ex) {
                LOGGER.warn("Error removing elements in graphics layer of view '" + name + "'", (Throwable)ex);
            }
        }
    }

    public void cleanActiveViewHighligthed() {
        String name = "unknown";
        try {
            ApplicationManager application = ApplicationLocator.getManager();
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (viewdoc != null) {
                name = viewdoc.getName();
                MapContext mapContext = viewdoc.getMapContext();
                GraphicLayer gl = mapContext.getGraphicsLayer();
                gl.removeGraphics("vcsgis-highlighted");
                mapContext.invalidate();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Error removing elements in graphics layer of view '" + name + "'", (Throwable)ex);
        }
    }

    public void refreshDocuments() {
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        Project project = projectManager.getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document doc : views) {
            doc.refresh();
        }
        List tables = project.getDocuments(TableManager.TYPENAME);
        for (Document doc : tables) {
            doc.refresh();
        }
    }

    public void refreshDocument(FeatureStore store) {
        if (store == null) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        Project project = projectManager.getCurrentProject();
        String storeFullName = store.getFullName();
        List views = project.getDocuments(ViewManager.TYPENAME);
        block4: for (Document doc : views) {
            ViewDocument view = (ViewDocument)doc;
            Iterator it = view.deepiterator();
            while (it.hasNext()) {
                FeatureStore layerStore;
                FLayer layer = (FLayer)it.next();
                if (!(layer instanceof FLyrVect) || (layerStore = ((FLyrVect)layer).getFeatureStore()) == null || !StringUtils.equals((CharSequence)layerStore.getFullName(), (CharSequence)storeFullName)) continue;
                try {
                    layerStore.refresh();
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't refresh store from layer '" + layer.getName() + "'.", (Throwable)ex);
                }
                view.getMapContext().invalidate();
                continue block4;
            }
        }
        List tables = project.getDocuments(TableManager.TYPENAME);
        for (Document doc : tables) {
            TableDocument table = (TableDocument)doc;
            FeatureStore featureStore = table.getStore();
            if (!StringUtils.equals((CharSequence)featureStore.getFullName(), (CharSequence)storeFullName)) continue;
            try {
                featureStore.refresh();
            }
            catch (DataException e) {
                LOGGER.warn("Error refreshing table", (Throwable)e);
            }
        }
    }

    public void refreshDocument(Set<FeatureStore> stores) {
        if (stores == null || stores.isEmpty()) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        Project project = projectManager.getCurrentProject();
        HashSet<ViewDocument> viewsToRefresh = new HashSet<ViewDocument>();
        for (FeatureStore store : stores) {
            String storeFullName = store.getFullName();
            List views = project.getDocuments(ViewManager.TYPENAME);
            for (Document doc : views) {
                String name = doc.getName();
                try {
                    ViewDocument view = (ViewDocument)doc;
                    Iterator it = view.deepiterator();
                    while (it.hasNext()) {
                        FeatureStore layerStore;
                        FLayer layer = (FLayer)it.next();
                        if (!(layer instanceof FLyrVect) || (layerStore = ((FLyrVect)layer).getFeatureStore()) == null || !StringUtils.equals((CharSequence)layerStore.getFullName(), (CharSequence)storeFullName)) continue;
                        viewsToRefresh.add(view);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Error searching View with store '" + storeFullName + "' (curview '" + name + "')", (Throwable)ex);
                }
            }
            List tables = project.getDocuments(TableManager.TYPENAME);
            for (Document doc : tables) {
                TableDocument table = (TableDocument)doc;
                FeatureStore featureStore = table.getStore();
                if (!StringUtils.equals((CharSequence)featureStore.getFullName(), (CharSequence)storeFullName)) continue;
                try {
                    featureStore.refresh();
                }
                catch (DataException e) {
                    LOGGER.warn("Error refreshing table", (Throwable)e);
                }
            }
        }
        for (ViewDocument viewDocument : viewsToRefresh) {
            viewDocument.getMapContext().invalidate();
        }
    }

    public List<ViewDocument> getViewDocumentsHavingAStore(FeatureStore store) {
        if (store == null) {
            return null;
        }
        ArrayList<ViewDocument> viewList = new ArrayList<ViewDocument>();
        String storeFullName = store.getFullName();
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        Project project = projectManager.getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document doc : views) {
            String name = doc.getName();
            try {
                ViewDocument view = (ViewDocument)doc;
                Iterator it = view.deepiterator();
                while (it.hasNext()) {
                    FeatureStore layerStore;
                    FLayer layer = (FLayer)it.next();
                    if (!(layer instanceof FLyrVect) || (layerStore = ((FLyrVect)layer).getFeatureStore()) == null || !StringUtils.equals((CharSequence)layerStore.getFullName(), (CharSequence)store.getFullName())) continue;
                    viewList.add(view);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Error searching View with store '" + storeFullName + "' (curview '" + name + "')", (Throwable)ex);
            }
        }
        return viewList;
    }

    public boolean isThereAnyActiveView() {
        return this.getActiveView() != null;
    }

    public void addTableToProject(VCSGisWorkspace ws, FeatureStore store, String tableName) {
        ApplicationManager appManager = ApplicationLocator.getApplicationManager();
        DocumentManager tableManager = appManager.getProjectManager().getDocumentManager(TableManager.TYPENAME);
        Project project = appManager.getCurrentProject();
        TableDocument tableDoc = (TableDocument)tableManager.createDocument();
        tableDoc.setName(tableName);
        tableDoc.setStore(store);
        project.addDocument((Document)tableDoc);
    }

    public Icon getFeatureStoresTreeModelIcon(TreeModel model, Object obj) {
        if (model instanceof FeatureStoresTreeModel) {
            return ((FeatureStoresTreeModel)model).getIcon(obj);
        }
        return null;
    }

    public void connectedToModel(VCSGisWorkspace workspace, String model) {
        String previousProjectModelInfo = null;
        try {
            JsonObjectBuilder item;
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            Project project = application.getCurrentProject();
            HashMap<String, Object> models = new HashMap<String, Object>();
            previousProjectModelInfo = (String)project.getProperty(VCSGISMODELS_PROJECT_PROPERTY);
            if (previousProjectModelInfo != null) {
                JsonArray array = Json.createArray((String)previousProjectModelInfo);
                for (JsonValue value : array) {
                    item = (JsonObject)value;
                    String modelName = item.getString("model", null);
                    JDBCServerExplorerParameters wsparameters = (JDBCServerExplorerParameters)Json.toObject((JsonValue)item.getJsonObject("parameters"));
                    String url = wsparameters.getUrl();
                    String key = modelName;
                    models.put(key, item);
                }
            }
            JDBCServerExplorerParameters parameters = workspace.getExplorerParameters();
            String url = parameters.getUrl();
            String key = model;
            item = Json.createObjectBuilder();
            item.add("model", model);
            item.add("parameters", (SupportToJson)parameters);
            models.put(key, item.build());
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (JsonObject n : models.values()) {
                array.add(n);
            }
            String s = array.build().toString();
            project.setProperty(VCSGISMODELS_PROJECT_PROPERTY, (Object)s);
            LOGGER.info("Added information of vcsgis model to project properties.");
            LOGGER.debug(s);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add information of vcsgis model to project properties. Previous model info='" + previousProjectModelInfo + "'", (Throwable)ex);
        }
    }

    public void projectLoaded(Project project) {
        String projectModelInfo = null;
        try {
            projectModelInfo = (String)project.getProperty(VCSGISMODELS_PROJECT_PROPERTY);
            if (projectModelInfo == null) {
                LOGGER.info("Project loaded without information of vcsgis models.");
                return;
            }
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            DataManager dataManager = DALLocator.getDataManager();
            JsonArray array = Json.createArray((String)projectModelInfo);
            for (JsonValue value : array) {
                String modelName = "unkbown";
                String url = "unknown";
                try {
                    JsonObject item = (JsonObject)value;
                    modelName = item.getString("model", null);
                    JDBCServerExplorerParameters wsparameters = (JDBCServerExplorerParameters)Json.toObject((JsonValue)((JsonValue)item.get((Object)"parameters")));
                    url = wsparameters.getUrl();
                    JDBCServerExplorer wsexplorer = (JDBCServerExplorer)dataManager.openServerExplorer(wsparameters.getProviderName(), (DataServerExplorerParameters)wsparameters);
                    VCSGisWorkspace workspace = manager.openWorkspace(wsexplorer);
                    workspace.registerDataModelRepository(modelName);
                    LOGGER.info("Conected to vcsgis model '" + modelName + "' (workspace=" + url + ").");
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't register data model '" + modelName + "' of workspace '" + url + "'.", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add information of vcsgis model to project properties (" + projectModelInfo + ").", (Throwable)ex);
        }
    }

    public Geometry getExtentOfCurrentDocument() {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        Project project = application.getCurrentProject();
        ViewDocument view = (ViewDocument)project.getActiveDocument(ViewDocument.class);
        if (view == null) {
            return null;
        }
        return view.getMapContext().getViewPort().getEnvelope().getBox2D();
    }

    public boolean isInSomeDocument(FeatureStore store) {
        if (store == null) {
            return false;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        Project project = projectManager.getCurrentProject();
        String storeFullName = store.getFullName();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document doc : views) {
            String name = doc.getName();
            try {
                ViewDocument view = (ViewDocument)doc;
                Iterator it = view.deepiterator();
                while (it.hasNext()) {
                    FeatureStore layerStore;
                    FLayer layer = (FLayer)it.next();
                    if (!(layer instanceof FLyrVect) || (layerStore = ((FLyrVect)layer).getFeatureStore()) == null || !StringUtils.equals((CharSequence)layerStore.getFullName(), (CharSequence)storeFullName)) continue;
                    return true;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Error searching store '" + storeFullName + "' (curview '" + name + "')", (Throwable)ex);
            }
        }
        List tables = project.getDocuments(TableManager.TYPENAME);
        for (Document doc : tables) {
            String name = doc.getName();
            try {
                TableDocument table = (TableDocument)doc;
                FeatureStore featureStore = table.getStore();
                if (!StringUtils.equals((CharSequence)featureStore.getFullName(), (CharSequence)storeFullName)) continue;
                return true;
            }
            catch (Exception ex) {
                LOGGER.warn("Error searching store '" + storeFullName + "' (curtable '" + name + "')", (Throwable)ex);
            }
        }
        return false;
    }

    public LabeledValue<MapControl> getActiveMapControl() {
        try {
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            Project project = application.getCurrentProject();
            ViewDocument viewDoc = (ViewDocument)project.getActiveDocument(ViewDocument.class);
            if (viewDoc == null) {
                return null;
            }
            IView view = (IView)viewDoc.getMainComponent();
            return new LabeledValueImpl(viewDoc.getName(), (Object)view.getMapControl());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public List<LabeledValue<MapControl>> getMapControls() {
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        Project project = projectManager.getCurrentProject();
        ArrayList<LabeledValue<MapControl>> mapControls = new ArrayList<LabeledValue<MapControl>>();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document doc : views) {
            ViewDocument viewDoc = (ViewDocument)doc;
            IView view = (IView)viewDoc.getMainComponent();
            mapControls.add((LabeledValue<MapControl>)new LabeledValueImpl(viewDoc.getName(), (Object)view.getMapControl()));
        }
        return mapControls;
    }

    public List<FeatureStore> getFeatureStores() {
        ListDisposable<FeatureStore> stores = new ListDisposable<FeatureStore>();
        ApplicationManager appManager = ApplicationLocator.getApplicationManager();
        Project project = appManager.getCurrentProject();
        List docs = project.getDocuments();
        for (Document document : docs) {
            if (document instanceof TableDocument) {
                TableDocument table = (TableDocument)document;
                FeatureStore store = table.getFeatureStore();
                if (store == null) continue;
                DisposeUtils.bind((Disposable)store);
                stores.add(store);
                continue;
            }
            if (!(document instanceof ViewDocument)) continue;
            ViewDocument view = (ViewDocument)document;
            Iterator it = view.getMapContext().deepiterator();
            while (it.hasNext()) {
                FeatureStore store;
                FLayer layer = (FLayer)it.next();
                if (!(layer instanceof VectorLayer) || (store = ((VectorLayer)layer).getFeatureStore()) == null) continue;
                DisposeUtils.bind((Disposable)store);
                stores.add(store);
            }
        }
        return stores;
    }

    private static class ListDisposable<T>
    extends ArrayList<T>
    implements Disposable {
        private ListDisposable() {
        }

        public void dispose() {
            for (Object element : this) {
                DisposeUtils.dispose(element);
            }
            this.clear();
        }
    }
}

