/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app.addlayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.util.IsEmpty;

public class LayersWithGroup
implements Iterable<FLayer>,
IsEmpty {
    private final Map<String, FLayer> treelayers = new LinkedHashMap<String, FLayer>();
    private final List<FLayer> layers = new ArrayList<FLayer>();
    private final MapContext mapContext;
    public static final int UPDATE_MODE_REPLACE_LAYER_IF_EXISTS = 0;
    public static final int UPDATE_MODE_ADD_DUPLICATES = 1;
    public static final int UPDATE_MODE_SKIP_DUPLICATES = 2;

    public LayersWithGroup(MapContext mapContext) {
        this.mapContext = mapContext;
    }

    public synchronized void add(String groupName, String layerName, FLayer layer) {
        this.layers.add(layer);
        if (StringUtils.isBlank((String)layerName)) {
            this.treelayers.put(layer.getName(), layer);
            return;
        }
        if (StringUtils.isBlank((String)groupName)) {
            this.treelayers.put(layerName, layer);
            return;
        }
        FLayers group = (FLayers)this.treelayers.get("$$" + groupName);
        if (group == null) {
            group = new FLayers();
            group.setMapContext(this.mapContext);
            group.setName(groupName);
            group.setParentLayer(this.mapContext.getLayers());
            this.treelayers.put("$$" + groupName, (FLayer)group);
        }
        group.add(layer);
    }

    public synchronized void updateMapContext(boolean maintainStructureInToC, boolean replaceLayerIfExists) {
        this.updateMapControl(null, maintainStructureInToC, replaceLayerIfExists);
    }

    public synchronized void updateMapControl(MapControl mapControl, boolean maintainStructureInToC, boolean replaceLayerIfExists) {
        this.updateMapControl(mapControl, maintainStructureInToC, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateMapControl(MapControl mapControl, boolean maintainStructureInToC, int updateMode) {
        block21: {
            this.mapContext.beginAtomicEvent();
            try {
                if (maintainStructureInToC) {
                    FLayers layersToC = this.mapContext.getLayers();
                    for (FLayer aLayer : this) {
                        if (aLayer == null) continue;
                        if (aLayer instanceof FLayers) {
                            FLayers group = (FLayers)aLayer;
                            FLayer groupToC = layersToC.getLayer(aLayer.getName());
                            if (groupToC instanceof FLayers) {
                                for (FLayer l : group) {
                                    FLyrVect ltoc = this.getLayer((FLayers)groupToC, (FLyrVect)l);
                                    switch (updateMode) {
                                        case 0: {
                                            if (ltoc == null) {
                                                ((FLayers)groupToC).add(l);
                                                break;
                                            }
                                            this.refreshLayer(ltoc);
                                            break;
                                        }
                                        case 1: {
                                            ((FLayers)groupToC).add(l);
                                            break;
                                        }
                                        case 2: {
                                            if (ltoc != null) break;
                                            ((FLayers)groupToC).add(l);
                                        }
                                    }
                                }
                                continue;
                            }
                            group.setVisible(true);
                            this.addLayer(mapControl, (FLayer)group);
                            continue;
                        }
                        FLyrVect ltoc = this.getLayer(layersToC, (FLyrVect)aLayer);
                        switch (updateMode) {
                            case 0: {
                                if (ltoc == null) {
                                    aLayer.setVisible(true);
                                    this.addLayer(mapControl, aLayer);
                                    break;
                                }
                                this.refreshLayer(ltoc);
                                break;
                            }
                            case 1: {
                                aLayer.setVisible(true);
                                this.addLayer(mapControl, aLayer);
                                break;
                            }
                            case 2: {
                                if (ltoc != null) break;
                                aLayer.setVisible(true);
                                this.addLayer(mapControl, aLayer);
                            }
                        }
                    }
                    break block21;
                }
                for (FLayer aLayer : this.allLayers()) {
                    this.addLayer(mapControl, aLayer);
                }
            }
            finally {
                this.mapContext.endAtomicEvent();
            }
        }
    }

    private void refreshLayer(FLyrVect layer) {
        try {
            FeatureStore store = layer.getFeatureStore();
            if (store != null) {
                store.refresh();
            }
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    private FLyrVect getLayer(FLayers group, FLyrVect layer) {
        FeatureStore store = layer.getFeatureStore();
        DataStoreParameters params = layer.getDataStoreParameters();
        for (FLayer layer1 : group) {
            FeatureStore store1;
            if (!(layer1 instanceof FLyrVect) || !((store1 = ((FLyrVect)layer1).getFeatureStore()) == null || store == null ? ((FLyrVect)layer1).getDataStoreParameters().isTheSameStore(params) : StringUtils.equals((String)store1.getFullName(), (String)store.getFullName()))) continue;
            return (FLyrVect)layer1;
        }
        return null;
    }

    private void addLayer(MapControl mapControl, FLayer layer) {
        if (mapControl != null) {
            mapControl.addLayer(layer);
            return;
        }
        this.mapContext.getLayers().add(layer);
        if (!this.mapContext.hasActiveLayers()) {
            layer.setActive(true);
        }
    }

    public synchronized void disposeLayers() {
        for (FLayer layer : this) {
            layer.dispose();
        }
    }

    public boolean isEmpty() {
        return this.treelayers.isEmpty();
    }

    @Override
    public Iterator<FLayer> iterator() {
        return this.treelayers.values().iterator();
    }

    public Collection<FLayer> allLayers() {
        return this.layers;
    }
}

