/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app.addlayer;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.geodb.TableInfo;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.vcsgis.app.addlayer.AbstractWizardVCSGis;
import org.gvsig.vcsgis.app.addlayer.VCSGisTableInfo;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;

public class WizardVCSGisTabular
extends AbstractWizardVCSGis {
    @Override
    protected boolean requireGeometry() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWizard() {
        DataManager man = DALLocator.getDataManager();
        ApplicationManager application = ApplicationLocator.getManager();
        VCSGisWorkspace workspace = this.getWorkspace();
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected() || !((VCSGisTableInfo)tableInfo).needConnectToModel()) continue;
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            int n = dialogs.confirmDialog(i18n.getTranslation("_Some_of_the_selected_tables_require_connection_to_a_data_model") + "\n" + i18n.getTranslation("_It_is_recommended_that_you_connect_to_the_data_model_before_loading_the_tables") + "\n" + i18n.getTranslation("_Do_you_want_to_add_the_selected_tables_anyway"), i18n.getTranslation("_AddTable"), 0, 3, "_Some_of_the_selected_tables_require_connection_to_a_data_model");
            if (n == 0) continue;
            return null;
        }
        ArrayList<TableDocument> tabledocs = new ArrayList<TableDocument>();
        ArrayList<VCSGisTableInfo> tablesInformation = new ArrayList<VCSGisTableInfo>();
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            tablesInformation.add((VCSGisTableInfo)tableInfo);
        }
        ArrayList<String> dataModels = new ArrayList<String>();
        for (VCSGisTableInfo tableInfo : tablesInformation) {
            VCSGisEntity entity = tableInfo.getEntity();
            List entityModels = entity.getDataModelsAsList();
            if (entityModels == null) continue;
            for (String entityModel : entityModels) {
                dataModels.add(entityModel);
            }
        }
        if (!dataModels.isEmpty()) {
            for (StoresRepository storesRepository : man.getStoresRepository().getSubrepositories()) {
                dataModels.remove(storesRepository.getID());
            }
            for (String dataModel : dataModels) {
                this.registerDataModelRepository(workspace, dataModel);
            }
        }
        for (VCSGisTableInfo tableInfo : tablesInformation) {
            JDBCStoreParameters storeParams = tableInfo.getParameters();
            FeatureStore store = null;
            try {
                try {
                    store = (FeatureStore)man.openStore(storeParams.getDataStoreName(), (DataStoreParameters)storeParams);
                }
                catch (Exception e) {
                    LOGGER.warn("Can't open store ", (Throwable)e);
                    Object var12_17 = null;
                    DisposeUtils.disposeQuietly((Disposable)store);
                    return var12_17;
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            TableDocument document = (TableDocument)application.getProjectManager().createDocument(TableManager.TYPENAME, tableInfo.getDocumentName());
            document.setStore(store);
            tabledocs.add(document);
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        return tabledocs;
    }
}

