/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app.addlayer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.BaseCreateLayerParameters;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.geodb.TableInfo;
import org.gvsig.geodb.vectorialdb.visibility.LayerScaleVisibilityUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.app.addlayer.AbstractWizardVCSGis;
import org.gvsig.vcsgis.app.addlayer.LayersWithGroup;
import org.gvsig.vcsgis.app.addlayer.VCSGisTableInfo;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;

public class WizardVCSGisVectorial
extends AbstractWizardVCSGis {
    public WizardVCSGisVectorial() {
        this.setVisibleMaintainStructureInToC(true);
    }

    @Override
    protected boolean requireGeometry() {
        return true;
    }

    public Object executeWizard() {
        DataManager man = DALLocator.getDataManager();
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        MapControl mapControl = this.getMapCtrl();
        MapContext mapContext = mapControl.getMapContext();
        LayersWithGroup layers = new LayersWithGroup(mapContext);
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean checkScale = this.getCheckScale();
        boolean addToCWhenLoadingAll = this.getAddToCWhenLoadingAll();
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected() || !((VCSGisTableInfo)tableInfo).needConnectToModel()) continue;
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            int n = dialogs.confirmDialog(i18n.getTranslation("_Some_of_the_selected_tables_require_connection_to_a_data_model") + "\n" + i18n.getTranslation("_It_is_recommended_that_you_connect_to_the_data_model_before_loading_the_tables") + "\n" + i18n.getTranslation("_Do_you_want_to_add_the_selected_tables_anyway"), i18n.getTranslation("_AddLayer"), 0, 3, "_Some_of_the_selected_tables_require_connection_to_a_data_model");
            if (n == 0) continue;
            return null;
        }
        Thread th = new Thread(() -> {
            SimpleTaskStatus taskstatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Loading layers");
            taskstatus.setIndeterminate();
            taskstatus.setAutoremove(true);
            taskstatus.add();
            ArrayList<VCSGisTableInfo> tablesInformation = new ArrayList<VCSGisTableInfo>();
            for (TableInfo tableInfo : this.getTablesInformation()) {
                if (!tableInfo.isSelected()) continue;
                tablesInformation.add((VCSGisTableInfo)tableInfo);
            }
            tablesInformation.sort(new Comparator<VCSGisTableInfo>(){

                @Override
                public int compare(VCSGisTableInfo o1, VCSGisTableInfo o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    VCSGisEntity e1 = o1.getEntity();
                    VCSGisEntity e2 = o2.getEntity();
                    if (e1 == null || e2 == null) {
                        return 0;
                    }
                    FeatureType ft1 = o1.getFeatureType();
                    FeatureType ft2 = o2.getFeatureType();
                    int order1 = ft1 == null ? 0 : ft1.getTags().getInt("TOC_Order", 0);
                    int order2 = ft2 == null ? 0 : ft2.getTags().getInt("TOC_Order", 0);
                    String id1 = String.format("%05d/%02d/%s/%s", order1, WizardVCSGisVectorial.this.getLayerOrderWeight(e1), WizardVCSGisVectorial.this.getCategory(e1), e1.getLabelOrName());
                    String id2 = String.format("%05d/%02d/%s/%s", order2, WizardVCSGisVectorial.this.getLayerOrderWeight(e2), WizardVCSGisVectorial.this.getCategory(e2), e2.getLabelOrName());
                    return id2.compareTo(id1);
                }
            });
            ArrayList<String> dataModels = new ArrayList<String>();
            for (VCSGisTableInfo tableInfo : tablesInformation) {
                VCSGisEntity entity = tableInfo.getEntity();
                List entityModels = entity.getDataModelsAsList();
                if (entityModels == null) continue;
                for (String entityModel : entityModels) {
                    dataModels.add(entityModel);
                }
            }
            if (!dataModels.isEmpty()) {
                for (StoresRepository storesRepository : man.getStoresRepository().getSubrepositories()) {
                    dataModels.remove(storesRepository.getID());
                }
                for (String dataModel : dataModels) {
                    this.registerDataModelRepository(workspace, dataModel);
                }
            }
            taskstatus.setRangeOfValues(0L, (long)tablesInformation.size());
            for (VCSGisTableInfo tableInfo : tablesInformation) {
                if (taskstatus.isCancellationRequested()) {
                    taskstatus.cancel();
                    return;
                }
                taskstatus.message(tableInfo.getEntity().getLabelOrName());
                LOGGER.info("Load layer '" + tableInfo.getId() + "'");
                JDBCStoreParameters params = tableInfo.getParameters();
                VCSGisEntity entity = tableInfo.getEntity();
                List entityModels = entity.getDataModelsAsList();
                if (entityModels != null) {
                    for (String entityModel : entityModels) {
                        dataModels.add(entityModel);
                    }
                }
                String category = this.getCategory(entity);
                this.fixCRS((DataStoreParameters)params);
                if (tableInfo.getVisible() == null) {
                    tableInfo.setVisible(entity.getCategoryTags(category).getBoolean("visibility", true));
                }
                boolean defaultVisibility = tableInfo.getVisible();
                try {
                    String tableName;
                    FLayer fLayer = mapContextManager.createLayer(tableInfo.getDocumentName(), (MapContextManager.CreateLayerParameters)new BaseCreateLayerParameters((DataStoreParameters)params, defaultVisibility));
                    if (defaultVisibility) {
                        LayerScaleVisibilityUtils.checkForVisibilityScale((FLayer)fLayer, (boolean)checkScale);
                    }
                    if (StringUtils.isBlank((String)(tableName = params.getTable()))) {
                        layers.add(null, null, fLayer);
                    } else if (workspace.getWorkspaceEntityByName(tableName) == null) {
                        layers.add(null, tableName, fLayer);
                    } else {
                        layers.add(category, fLayer.getName(), fLayer);
                    }
                    if (!addToCWhenLoadingAll) {
                        SwingUtilities.invokeLater(() -> layers.updateMapControl(mapControl, this.maintainStructureInToC(), 2));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can't create layer '" + tableInfo.getDocumentName() + "'.", (Throwable)e);
                }
                taskstatus.incrementCurrentValue();
            }
            if (addToCWhenLoadingAll) {
                SwingUtilities.invokeLater(() -> {
                    layers.updateMapControl(mapControl, this.maintainStructureInToC(), false);
                    layers.disposeLayers();
                });
            } else {
                SwingUtilities.invokeLater(() -> layers.disposeLayers());
            }
            taskstatus.terminate();
        }, "WizardVCSGisVectorial");
        this.startTask(th);
        return null;
    }

    private void fireLayerErrorEvent(FLayer lyr, MapControl mapControl) {
        mapControl.getMapContext().callNewErrorEvent(null);
    }

    @Override
    protected Function<VCSGisEntity, String> getLabelEntityFormatter() {
        return entity -> {
            String label = this.getWorkspace().formatEntityLabel(entity);
            FeatureType type = entity.getFeatureType();
            if (type == null) {
                return label;
            }
            IProjection srs = type.getDefaultSRS();
            if (srs == null) {
                return label;
            }
            MapContext mapContext1 = this.getMapContext();
            if (mapContext1 == null) {
                return label + " [" + srs.getAbrev() + "]";
            }
            if (mapContext1.getProjection() == null) {
                return label + " [" + srs.getAbrev() + "]";
            }
            if (StringUtils.equalsIgnoreCase((String)mapContext1.getProjection().getAbrev(), (String)srs.getAbrev())) {
                return label + " [" + srs.getAbrev() + "]";
            }
            return label + " [" + srs.getAbrev() + "!]";
        };
    }

    private int getLayerOrderWeight(VCSGisEntity entity) {
        int type2d = 3;
        try {
            GeometryType geomtype = entity.getFeatureType().getDefaultGeometryAttribute().getGeomType();
            type2d = this.simplifyType(geomtype);
        }
        catch (Exception e) {
            LOGGER.warn("While getting geo type.", (Throwable)e);
        }
        switch (type2d) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 3;
    }

    private int simplifyType(GeometryType gt) {
        if (gt.isTypeOf(1) || gt.isTypeOf(7)) {
            return 1;
        }
        if (gt.isTypeOf(2) || gt.isTypeOf(8)) {
            return 2;
        }
        if (gt.isTypeOf(3) || gt.isTypeOf(9)) {
            return 3;
        }
        return 3;
    }
}

