/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dispersepoints;

import com.google.common.primitives.Ints;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.util.ArrayList;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.geoprocess.algorithm.dispersepoints.DispersePointsOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.service.spi.ServiceManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispersePointsAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    public static final String SCATTER_RADIUS = "SCATTER_RADIUS";
    public static final String MATCH_DISTANCE = "MATCH_DISTANCE";
    public static final String SELECTGEOM_INPUT = "SELECTGEOM_INPUT";
    private static Logger logger = LoggerFactory.getLogger(DispersePointsAlgorithm.class);

    public void defineCharacteristics() {
        this.setName(this.getTranslation("_disperse_points"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("input_layer"), 0, true);
            this.addOutputVectorLayer(RESULT, this.getTranslation("_disperse_points"), 0);
            this.m_Parameters.addNumericalValue(MATCH_DISTANCE, this.getTranslation("_match_distance"), 0.0, 2);
            this.m_Parameters.addNumericalValue(SCATTER_RADIUS, this.getTranslation("_scatter_radius"), 0.0, 2);
            this.m_Parameters.addBoolean(SELECTGEOM_INPUT, this.getTranslation("Selected_geometries_input_layer"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        double scatterRadius = this.m_Parameters.getParameter(SCATTER_RADIUS).getParameterValueAsDouble();
        double matchDistance = this.m_Parameters.getParameter(MATCH_DISTANCE).getParameterValueAsDouble();
        boolean selectedGeomInput = this.m_Parameters.getParameter(SELECTGEOM_INPUT).getParameterValueAsBoolean();
        FlyrVectIVectorLayer inputLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        inputLayer = (FlyrVectIVectorLayer)layer;
        DataManager dataManager = DALLocator.getDataManager();
        FeatureStore inputFeatureStore = inputLayer.getFeatureStore();
        try {
            FeatureType featureTypeInputLayer = inputFeatureStore.getDefaultFeatureType();
            DispersePointsOperation operation = null;
            FeatureStore outFeatStore = null;
            outFeatStore = this.buildOutPutStore(featureTypeInputLayer, inputLayer.getShapeType(), this.getTranslation("_disperse_points"), RESULT);
            operation = new DispersePointsOperation(this.createIndex(inputLayer.getFeatureStore()), scatterRadius, matchDistance, this);
            operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
            operation.computesGeometryOperation(inputFeatureStore, outFeatStore, this.attrNames, selectedGeomInput, false, true);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return true;
    }

    private SpatialIndex createIndex(FeatureStore store) throws BaseException {
        DynObject parameters;
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        SpatialIndexFactory factory = geomManager.getSpatialIndexFactory("JSIRTree");
        SpatialIndex index = (SpatialIndex)factory.create(parameters = factory.createParameters(), (ServiceManager)geomManager);
        final SpatialIndex wrappedIndex = store.wrapSpatialIndex(index);
        if (wrappedIndex == null) {
            String msg = "Can't use the data source '" + store.getFullName() + "' in this geoprocess, need soport of numeric OIDs to create spatial index.";
            logger.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        final FilteredLogger log = new FilteredLogger(logger, "Disperse points, create index", 20);
        Visitor visitor = new Visitor(){

            public void visit(Object obj) throws VisitCanceledException, BaseException {
                if (obj == null) {
                    log.warn("The feature to process is null, skip.");
                    return;
                }
                Feature f = (Feature)obj;
                Geometry g = f.getDefaultGeometry();
                if (g == null) {
                    log.warn("The geometry is null, skip.");
                    return;
                }
                FeatureReference ref = f.getReference();
                if (ref == null) {
                    log.warn("Can't get the reference for the current feature, skip.");
                    return;
                }
                wrappedIndex.insert(g, (Object)ref);
            }
        };
        store.accept(visitor);
        return wrappedIndex;
    }

    protected FeatureStore buildOutPutStore(FeatureType featureType1, int shapeType, String sextanteLayerName, String sextanteLayerLabel) {
        ArrayList<Class> typesList = new ArrayList<Class>();
        ArrayList<String> attr = new ArrayList<String>();
        ArrayList<Integer> sizesList = new ArrayList<Integer>();
        for (FeatureAttributeDescriptor attribute : featureType1) {
            if (attribute.getDataType().getType() == 66) continue;
            attr.add(attribute.getName());
            typesList.add(attribute.getObjectClass());
            sizesList.add(attribute.getSize());
        }
        this.attrNames = new String[attr.size()];
        attr.toArray(this.attrNames);
        Class[] types = new Class[typesList.size()];
        typesList.toArray(types);
        int[] sizes = Ints.toArray(sizesList);
        try {
            IVectorLayer output = this.getNewVectorLayer(sextanteLayerLabel, sextanteLayerName, shapeType, types, this.attrNames, sizes, 4);
            return ((FlyrVectIVectorLayer)output).getFeatureStore();
        }
        catch (UnsupportedOutputChannelException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeoAlgorithmExecutionException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return null;
    }
}

