/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dispersepoints;

import es.unex.sextante.core.Sextante;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class DispersePointsOperation
extends GeometryOperation {
    private SpatialIndex index;
    private double scatterRadius;
    private double matchDistance;
    NavigableSet<Integer> processed;

    public DispersePointsOperation(SpatialIndex index, double scatterRadius, double matchDistance, AbstractSextanteGeoProcess p) {
        super(p);
        this.index = index;
        this.scatterRadius = scatterRadius;
        this.matchDistance = matchDistance;
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        File dbfile = folderManager.getUniqueTemporaryFile(new String[]{"dispersepoints.mapdb"});
        DB db = DBMaker.fileDB((File)dbfile).fileMmapEnable().make();
        this.processed = (NavigableSet)db.treeSet("processed").create();
    }

    public EditableFeature invoke(Geometry g, Feature feature) {
        boolean addedFeature = false;
        if (g == null) {
            return this.lastEditFeature;
        }
        try {
            FeatureReference reference = feature.getReference();
            if (!this.processed.contains(reference.hashCode())) {
                ArrayList<FeatureReference> group = new ArrayList<FeatureReference>();
                Iterator iterator = this.index.query(g.buffer(this.matchDistance));
                while (iterator.hasNext()) {
                    Feature feat;
                    Geometry g2;
                    double dist;
                    FeatureReference ref = (FeatureReference)iterator.next();
                    if (this.processed.contains(ref.hashCode()) || !((dist = g.distance(g2 = (feat = ref.getFeature().getCopy()).getDefaultGeometry())) <= this.matchDistance)) continue;
                    group.add(ref);
                    this.processed.add(ref.hashCode());
                }
                if (group.size() == 1) {
                    this.buildFeature(feature, g);
                } else {
                    this.buildFeatures(group, (Point)g);
                }
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return this.lastEditFeature;
    }

    private void buildFeatures(List<FeatureReference> group, Point center) throws CreateGeometryException, DataException {
        if (group.isEmpty()) {
            return;
        }
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        int points = group.size();
        double step = Math.PI * 2 / (double)points;
        int i = 0;
        for (FeatureReference ref : group) {
            Feature feature = ref.getFeature().getCopy();
            this.buildFeature(feature, (Geometry)geomManager.createPoint(center.getX() + Math.cos((double)i * step) * this.scatterRadius, center.getY() + Math.sin((double)i * step) * this.scatterRadius, 0));
            ++i;
        }
    }

    public void invoke(Geometry g, EditableFeature feature) {
        this.invoke(g, (Feature)feature);
    }

    private void buildFeature(Feature feat, Geometry g) throws DataException {
        EditableFeature outFeat = this.persister.getOutputFeatureStore().createNewFeature(feat);
        try {
            this.persister.addFeature((Feature)outFeat, g);
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

