/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.autopolygon;

import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class AutopolygonEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter geometryParameter;
    private final FeatureStore featureStore;
    private Geometry geometryValue;

    public AutopolygonEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.geometryParameter = new DefaultEditingServiceParameter("Draw geometry", "draw_geometry_to_autopolygon", 9, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.GEOMETRY});
    }

    public EditingServiceParameter next() {
        if (this.geometryValue == null) {
            return this.geometryParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        this.geometryValue = null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.geometryParameter);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        Geometry geometry;
        GeometryType geometryType;
        if (param == this.geometryParameter && value instanceof Geometry && ((geometryType = (geometry = (Geometry)value).getGeometryType()).isTypeOf(9) || geometryType.isTypeOf(3))) {
            this.geometryValue = geometry;
            return;
        }
        throw new InvalidEntryException(null);
    }

    public void finishAndStore() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = this.finish();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public Geometry finish() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = this.geometryValue.cloneGeometry();
        try {
            GeometryType storeGeomType;
            FeatureQuery query = this.queryByGeometry(geometry);
            if (query != null) {
                FeatureSet features = this.featureStore.getFeatureSet(query);
                DisposableIterator featuresIterator = features.fastIterator();
                while (featuresIterator.hasNext()) {
                    Feature feature = (Feature)featuresIterator.next();
                    geometry = geometry.difference(feature.getDefaultGeometry());
                }
                featuresIterator.dispose();
                features.dispose();
            }
            if ((storeGeomType = editingProviderServices.getGeomType(this.featureStore)).isTypeOf(9)) {
                MultiPrimitive multi = (MultiPrimitive)GeometryLocator.getGeometryManager().create(storeGeomType.getType(), storeGeomType.getSubType());
                multi.addPrimitives(geometry);
                return multi;
            }
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
        return geometry;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.geometryValue = null;
    }

    public String getName() {
        return "insert-autopolygon";
    }

    private FeatureQuery queryByGeometry(Geometry geometry) throws DataException {
        FeatureQuery featureQuery = this.featureStore.createFeatureQuery();
        FeatureType featureType = this.featureStore.getDefaultFeatureType();
        String geomName = featureType.getDefaultGeometryAttributeName();
        featureQuery.setFeatureType(featureType);
        IProjection query_proj = featureType.getDefaultSRS();
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(geometry, query_proj, this.featureStore);
        featureQuery.setFilter(iee);
        featureQuery.setAttributeNames(null);
        return featureQuery;
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.geometryParameter) {
            return this.geometryValue;
        }
        return null;
    }
}

