/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.centerviewpoint.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.project.documents.view.toolListeners.InfoListener;
import org.gvsig.centerviewpoint.CenterViewToPointExtension;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputCoordinatesPanel
extends JPanel
implements IWindow {
    private static final long serialVersionUID = 1L;
    private JLabel labelX = null;
    private JTextField textX = null;
    private JLabel labelY = null;
    private JLabel labelColor = null;
    private JTextField textY = null;
    private MapControl mapControl;
    private WindowInfo viewInfo = null;
    private String firstCoordinate;
    private String secondCoordinate;
    private Point2D center;
    private GraphicLayer lyr;
    private ColorChooserPanel colorPanel;
    private AcceptCancelPanel okCancelPanel = null;
    MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
    private static final Logger LOG = LoggerFactory.getLogger(InputCoordinatesPanel.class);

    public InputCoordinatesPanel(MapContext mapContext) {
        this.mapControl = new MapControl();
        this.mapControl.setMapContext(mapContext);
        this.lyr = this.mapControl.getMapContext().getGraphicsLayer();
        this.initializeCoordinates();
        this.initialize();
    }

    private void initializeCoordinates() {
        IProjection proj = this.mapControl.getProjection();
        if (proj.isProjected()) {
            this.firstCoordinate = "X";
            this.secondCoordinate = "Y";
        } else {
            this.firstCoordinate = "Lon";
            this.secondCoordinate = "Lat";
        }
    }

    private void zoomToCoordinates() throws Exception {
        try {
            Envelope oldExtent = this.mapControl.getViewPort().getAdjustedEnvelope();
            double oldCenterX = oldExtent.getCenter(0);
            double oldCenterY = oldExtent.getCenter(1);
            double centerX = Double.parseDouble(this.textX.getText());
            double centerY = Double.parseDouble(this.textY.getText());
            this.center = new Point2D.Double(centerX, centerY);
            double movX = centerX - oldCenterX;
            double movY = centerY - oldCenterY;
            double minx = oldExtent.getMinimum(0) + movX;
            double miny = oldExtent.getMinimum(1) + movY;
            double maxX = oldExtent.getMaximum(0) + movX;
            double maxY = oldExtent.getMaximum(1) + movY;
            Envelope extent = GeometryLocator.getGeometryManager().createEnvelope(minx, miny, maxX, maxY, 0);
            this.mapControl.getViewPort().setEnvelope(extent);
        }
        catch (NumberFormatException e) {
            throw new Exception();
        }
    }

    private void initialize() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.setSize(270, 150);
        this.labelX = new JLabel();
        this.labelX.setText(this.firstCoordinate + ":");
        this.labelY = new JLabel();
        this.labelY.setText(this.secondCoordinate + ":");
        GridBagLayout gbl = new GridBagLayout();
        JPanel centerPanel = new JPanel(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 21;
        c.insets = new Insets(3, 5, 5, 5);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        centerPanel.add((Component)this.labelX, c);
        c.gridy = 1;
        centerPanel.add((Component)this.labelY, c);
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        centerPanel.add((Component)this.getTextX(), c);
        c.gridy = 1;
        centerPanel.add((Component)this.getTextY(), c);
        JPanel centerPanel2 = new JPanel(new BorderLayout());
        centerPanel2.add((Component)this.getColorPanel(), "Center");
        TitledBorder tb1 = BorderFactory.createTitledBorder(new TitledBorder(i18nManager.getTranslation("coordinates")));
        centerPanel.setBorder(tb1);
        this.add((Component)centerPanel, "North");
        TitledBorder tb2 = BorderFactory.createTitledBorder(new TitledBorder(i18nManager.getTranslation("point_color")));
        centerPanel2.setBorder(tb2);
        this.add((Component)centerPanel2, "Center");
        this.add((Component)this.getOkCancelPanel(), "South");
    }

    private JTextField getTextX() {
        if (this.textX == null) {
            this.textX = new JTextField();
            this.textX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputCoordinatesPanel.this.textX.transferFocus();
                }
            });
        }
        return this.textX;
    }

    private JTextField getTextY() {
        if (this.textY == null) {
            this.textY = new JTextField();
            this.textY.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputCoordinatesPanel.this.textY.transferFocus();
                }
            });
        }
        return this.textY;
    }

    public WindowInfo getWindowInfo() {
        if (this.viewInfo == null) {
            this.viewInfo = new WindowInfo(8);
            this.viewInfo.setTitle(PluginServices.getText((Object)this, (String)"Centrar_la_Vista_sobre_un_punto"));
            this.viewInfo.setWidth(this.getWidth());
            this.viewInfo.setHeight(this.getHeight());
        }
        return this.viewInfo;
    }

    private void openInfo() {
        InfoListener infoListener = new InfoListener(this.mapControl);
        MouseEvent e = new MouseEvent((Component)((CenterViewToPointExtension)PluginServices.getExtension(CenterViewToPointExtension.class)).getView(), 1, 128L, 500, 500, 400, 1, true);
        Point2D centerPixels = this.mapControl.getViewPort().fromMapPoint(this.center.getX(), this.center.getY());
        PointEvent pe = new PointEvent(centerPixels, e, this.mapControl);
        try {
            infoListener.point(pe);
        }
        catch (BehaviorException e1) {
            e1.printStackTrace();
        }
        if (this.mapControl.getMapContext().getLayers().getActives().length == 0) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_hay_ninguna_capa_seleccionada") + " \n" + PluginServices.getText((Object)this, (String)"debe_seleccionar_las_capas_de_las_que_quiera_obtener_informacion"));
        }
    }

    private void drawPoint(Color color) {
        CenterViewToPointExtension.COLOR = color;
        this.lyr.clearAllGraphics();
        ISymbol theSymbol = this.mapContextManager.getSymbolManager().createSymbol(1, color);
        int idSymbol = this.lyr.addSymbol(theSymbol);
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point geom = null;
        try {
            geom = (Point)geomManager.create(1, 0);
            geom.setX(this.center.getX());
            geom.setY(this.center.getY());
        }
        catch (CreateGeometryException e) {
            LOG.error("Error creating a point geometry", (Throwable)e);
        }
        this.lyr.addGraphic((Geometry)geom, idSymbol);
        this.mapControl.drawGraphics();
    }

    private JPanel getColorPanel() {
        if (this.colorPanel == null) {
            this.colorPanel = new ColorChooserPanel();
            this.colorPanel.setAlpha(250);
            this.colorPanel.setColor(CenterViewToPointExtension.COLOR);
        }
        return this.colorPanel;
    }

    private AcceptCancelPanel getOkCancelPanel() {
        if (this.okCancelPanel == null) {
            ActionListener okAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        InputCoordinatesPanel.this.zoomToCoordinates();
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"formato_de_numero_incorrecto"));
                        return;
                    }
                    if (PluginServices.getMainFrame() == null) {
                        ((JDialog)InputCoordinatesPanel.this.getParent().getParent().getParent().getParent()).dispose();
                    } else {
                        PluginServices.getMDIManager().closeWindow((IWindow)InputCoordinatesPanel.this);
                    }
                    Preferences prefs = Preferences.userRoot().node("gvsig.centerViewToPoint");
                    if (prefs.get("showInfo", "True").equalsIgnoreCase("True")) {
                        InputCoordinatesPanel.this.openInfo();
                    }
                    InputCoordinatesPanel.this.drawPoint(((ColorChooserPanel)InputCoordinatesPanel.this.getColorPanel()).getColor());
                }
            };
            ActionListener cancelAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputCoordinatesPanel.this.closeThis();
                }
            };
            this.okCancelPanel = new AcceptCancelPanel(okAction, cancelAction);
        }
        return this.okCancelPanel;
    }

    private void closeThis() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

