/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.ExpressionSyntaxException;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.ReprMethod;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.impl.I18N;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public abstract class AbstractAutomaticExpressionChecker {
    private static final Color COLOR_ERROR = new Color(255, 225, 232);
    private static final Color COLOR_SUGGESTION = new Color(255, 255, 159);
    private final JTextComponent text;
    private final ExpressionBuilderConfig builderConfig;
    private Color color_ok;
    private Timer timerExpression;
    private JMenuItem menuItemShowPreview;
    private JMenuItem menuItemShowTip;
    private JMenuItem menuItemShowMessage;
    private String message;
    protected String tip;
    private String preview;
    private DocumentListener doclistener;
    private KeyAdapter keylistener;
    private ActionListener timelistener;
    private boolean valid;

    public AbstractAutomaticExpressionChecker(ExpressionBuilderConfig config, JTextComponent theText) {
        this.text = theText;
        this.builderConfig = config;
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.color_ok = this.text.getBackground();
        toolsSwingManager.setDefaultPopupMenu(this.text);
        toolsSwingManager.addClearButton(this.text);
        JPopupMenu popupMenu = this.text.getComponentPopupMenu();
        this.menuItemShowTip = new JMenuItem(i18n.getTranslation("_Show_tip"));
        this.menuItemShowTip.addActionListener(e -> {
            if (StringUtils.isBlank((CharSequence)this.tip)) {
                return;
            }
            JOptionPane.showMessageDialog(this.text.getParent(), this.toHTML(this.tip), i18n.getTranslation("Tip"), 1);
        });
        popupMenu.add(this.menuItemShowTip);
        this.menuItemShowPreview = new JMenuItem(i18n.getTranslation("_Show_preview"));
        this.menuItemShowPreview.addActionListener(e -> this.showMessageDialog(i18n.getTranslation("_Preview_value"), this.preview));
        popupMenu.add(this.menuItemShowPreview);
        this.menuItemShowMessage = new JMenuItem(i18n.getTranslation("_Show_message"));
        this.menuItemShowMessage.addActionListener(e -> this.showMessageDialog(i18n.getTranslation("_Message"), this.message + "\n\n" + this.tip));
        popupMenu.add(this.menuItemShowMessage);
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        Collection actions = cfgActionsManager.getConfigurableActions("JExpressionBuilder");
        if (!actions.isEmpty()) {
            popupMenu.addSeparator();
            for (Action action : actions) {
                JMenuItem item = new JMenuItem(action);
                item.addActionListener(e -> {
                    e.setSource(this);
                    action.actionPerformed(e);
                });
                popupMenu.add(item);
            }
        }
        this.timelistener = e -> {
            this.checkExpression();
            this.stateChanged();
        };
        this.doclistener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractAutomaticExpressionChecker.this.timerExpression.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractAutomaticExpressionChecker.this.timerExpression.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractAutomaticExpressionChecker.this.timerExpression.restart();
            }
        };
        this.keylistener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 67 && e.isControlDown()) {
                    AbstractAutomaticExpressionChecker.this.checkExpression();
                }
            }
        };
        this.timerExpression = new Timer(3000, this.timelistener);
        this.timerExpression.setRepeats(false);
        this.text.getDocument().addDocumentListener(this.doclistener);
        this.text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (AbstractAutomaticExpressionChecker.this.timerExpression.isRunning()) {
                    AbstractAutomaticExpressionChecker.this.timerExpression.stop();
                    AbstractAutomaticExpressionChecker.this.checkExpression();
                    AbstractAutomaticExpressionChecker.this.stateChanged();
                }
            }
        });
        this.text.addKeyListener(this.keylistener);
    }

    public void checkExpression() {
        String suggestion;
        this.valid = true;
        if (this.text == null || this.builderConfig == null) {
            return;
        }
        if (!this.text.isShowing()) {
            return;
        }
        if (!this.text.isEnabled()) {
            this.timerExpression.restart();
            return;
        }
        Expression expression = this.getExpression();
        this.setTip(null);
        this.setPreview(null);
        this.setMessage(1, null);
        if (expression == null) {
            return;
        }
        try {
            expression.getCode();
            this.setMessage(1, "");
        }
        catch (ExpressionSyntaxException ex) {
            this.setMessage(0, ex.getDescription());
            this.valid = false;
            return;
        }
        catch (Exception ex) {
            this.setMessage(0, "Syntax error in expression");
            this.valid = false;
            return;
        }
        MutableObject theTip = new MutableObject(null);
        expression.setSQLCompatible(false);
        if (this.builderConfig.getPreviewSymbolTable() == null) {
            try {
                ExpressionEvaluatorManager theManager = ExpressionEvaluatorLocator.getManager();
                MutableSymbolTable symbolTable = theManager.createSymbolTable();
                Object theValue = expression.execute((SymbolTable)symbolTable);
                this.setPreview(theValue);
            }
            catch (Exception ex) {
                this.setMessage(1, "");
            }
        } else {
            try {
                Object theValue = expression.execute(this.builderConfig.getPreviewSymbolTable());
                this.setPreview(theValue);
            }
            catch (ExpressionRuntimeException ex) {
                theTip.setValue((Object)ex.getTip());
                this.setMessage(0, "Runtime error. " + ex.getMessage());
                this.valid = false;
            }
            catch (Exception ex) {
                this.setMessage(0, "Runtime error. " + ex.getMessage());
                this.valid = false;
            }
        }
        if (this.builderConfig.getPreferences().isSQLCompatible()) {
            Code code = expression.getCode();
            try {
                code.accept(new Visitor((Mutable)theTip){
                    final /* synthetic */ Mutable val$theTip;
                    {
                        this.val$theTip = mutable;
                    }

                    public void visit(Object obj) throws VisitCanceledException, BaseException {
                        Code code = (Code)obj;
                        switch (code.code()) {
                            case 2: {
                                Function function = ((Code.Callable)code).function();
                                if (function == null || function.isSQLCompatible()) break;
                                this.val$theTip.setValue((Object)I18N.Avoid_the_use_of_functions_not_compatible_with_SQL_in_this_data_source(function.name()));
                                break;
                            }
                            case 1: {
                                if (AbstractAutomaticExpressionChecker.this.builderConfig.getPreviewSymbolTable() == null || AbstractAutomaticExpressionChecker.this.builderConfig.getPreviewSymbolTable().isSQLCompatible(((Code.Identifier)code).name())) break;
                                this.val$theTip.setValue((Object)I18N.Avoid_the_use_of_functions_not_compatible_with_SQL_in_this_data_source(((Code.Identifier)code).name()));
                                break;
                            }
                            case 3: {
                                this.val$theTip.setValue((Object)I18N.Avoid_the_use_of_functions_not_compatible_with_SQL_in_this_data_source(((Code.Callable)code).name()));
                            }
                        }
                    }
                });
            }
            catch (BaseException baseException) {
                // empty catch block
            }
        }
        if ((suggestion = this.getSuggestion()) != null) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)theTip.getValue()))) {
                theTip.setValue((Object)suggestion);
            } else {
                theTip.setValue((Object)(suggestion + "\n\n" + (String)theTip.getValue()));
            }
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)theTip.getValue()))) {
            this.setTip((String)theTip.getValue());
            if (this.text.getBackground() == this.color_ok) {
                this.text.setBackground(COLOR_SUGGESTION);
            }
        }
    }

    protected boolean isTipEnabled() {
        return !StringUtils.isBlank((CharSequence)this.tip);
    }

    protected boolean isPreviewEnabled() {
        return !StringUtils.isBlank((CharSequence)this.preview);
    }

    protected boolean isMessageEnabled() {
        return !StringUtils.isBlank((CharSequence)this.message);
    }

    protected String getTip() {
        return this.tip;
    }

    protected String getMessage() {
        return this.message;
    }

    protected String getPreview() {
        return this.preview;
    }

    protected void showMessageDialog() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (this.isMessageEnabled()) {
            this.showMessageDialog(i18n.getTranslation("_Message"), this.getMessage());
        } else if (this.isPreviewEnabled()) {
            this.showMessageDialog(i18n.getTranslation("_Preview_value"), this.getPreview());
        }
    }

    protected void showMessageDialog(String title, String msg) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        JEditorPane textMessage = new JEditorPane();
        JScrollPane scroll = new JScrollPane(textMessage);
        scroll.setPreferredSize(new Dimension(500, 300));
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)textMessage);
        textMessage.setContentType("text/html");
        textMessage.setText(this.toHTML(msg));
        textMessage.setCaretPosition(0);
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winmgr.createDialog((JComponent)scroll, title, null, 1);
        dialog.show(WindowManager.MODE.DIALOG);
    }

    protected void setPreview(Object value) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        ReprMethod repr = manager.getReprMethod(value);
        this.preview = repr.repr(value);
        this.text.setToolTipText(this.toHTML(StringUtils.abbreviate((String)Objects.toString(this.preview, ""), (int)100)));
        this.menuItemShowPreview.setEnabled(this.isPreviewEnabled());
        this.text.setBackground(this.color_ok);
    }

    protected void setMessage(int mode, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            this.message = "";
            this.text.setToolTipText("");
            this.menuItemShowMessage.setEnabled(false);
            this.text.setBackground(this.color_ok);
            return;
        }
        this.message = text;
        this.text.setToolTipText(this.toHTML(StringUtils.abbreviate((String)Objects.toString(text, ""), (int)100)));
        this.menuItemShowMessage.setEnabled(true);
        switch (mode) {
            case 1: {
                this.text.setBackground(COLOR_SUGGESTION);
                break;
            }
            default: {
                this.text.setBackground(COLOR_ERROR);
            }
        }
    }

    protected void setTip(String theTip) {
        this.tip = theTip;
        this.menuItemShowTip.setEnabled(this.isTipEnabled());
    }

    protected abstract Expression getExpression();

    protected abstract String getSuggestion();

    protected String toHTML(String s) {
        s = StringUtils.replace((String)s, (String)"<html>", (String)"");
        s = StringUtils.replace((String)s, (String)"</html>", (String)"");
        s = StringUtils.replace((String)s, (String)"\n", (String)"<br>");
        s = "<html>" + s + "</html>";
        return s;
    }

    protected void stateChanged() {
    }

    public boolean isValid() {
        this.checkExpression();
        return this.valid;
    }
}

