/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.expressionevaluator.swing.impl.AbstractAutomaticExpressionChecker;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionEvaluatorSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.InitComponentsListener;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;

public class DefaultExpressionPickerController
extends AbstractPickerController<Expression>
implements ExpressionPickerController,
Disposable {
    private JButton button;
    private JTextComponent text;
    private Expression value;
    private ExpressionBuilderConfig config;
    private DefaultExpressionEvaluatorSwingManager manager;
    private ActionListener buttonAction;
    private JMenuItem menuItem;
    private AbstractAutomaticExpressionChecker automaticExpressionChecker;
    private boolean returnNullWhenEmptyExpression;
    private HistoryController<Expression> historyController;
    private BookmarksController<Expression> bookmarksController;
    private JButton buttonBookmarks;
    private JButton buttonHistory;
    private ActionListener historyAndBookmarkListener;
    private JComboBox combo;

    public static void selfRegister() {
        URL imageResource = DefaultExpressionPickerController.class.getClassLoader().getResource("org/gvsig/tools/swing/picker/picker-expression.png");
        if (imageResource != null) {
            IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
            IconTheme theme = iconThemeManager.getCurrent();
            ImageIcon icon = new ImageIcon(imageResource);
            theme.registerDefault("tools", "picker", "picker-expression", icon, imageResource);
        }
    }

    public DefaultExpressionPickerController(DefaultExpressionEvaluatorSwingManager manager, JComboBox combo, JButton button, JButton btnHistory, JButton btnBookmarks) {
        this(manager, (JTextComponent)combo.getEditor().getEditorComponent(), button, btnHistory, btnBookmarks);
        this.combo = combo;
    }

    public DefaultExpressionPickerController(DefaultExpressionEvaluatorSwingManager manager, JTextComponent text, JButton button, JButton btnHistory, JButton btnBookmarks) {
        this.manager = manager;
        this.text = text;
        this.button = button;
        this.buttonHistory = btnHistory;
        this.buttonBookmarks = btnBookmarks;
        this.createComponents();
    }

    private void createComponents() {
        ToolsSwingUtils.addInitComponentsListener((JComponent)this.text, (InitComponentsListener)new InitComponentsListener(){

            public void doDisposeComponents() {
                DefaultExpressionPickerController.this.disposeComponents();
            }

            public void doInitComponents() {
                DefaultExpressionPickerController.this.initComponents();
            }
        });
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.config = new DefaultExpressionBuilderConfig(this.manager);
        this.returnNullWhenEmptyExpression = true;
        this.value = null;
        this.buttonAction = e -> this.doSelectExpression();
        this.menuItem = new JMenuItem(i18n.getTranslation("_Show_expression_builder"));
        this.historyAndBookmarkListener = e -> {
            ActionEventWithCurrentValue ee = (ActionEventWithCurrentValue)e;
            switch (ee.getID()) {
                case 1001: {
                    this.set((Expression)ee.getCurrentValue());
                    this.fireChangeEvent();
                    break;
                }
                case 1002: {
                    ee.setCurrentValue((Object)this.get());
                }
            }
        };
        this.historyController = swingManager.createHistoryController(this.config.getHistory(), this.buttonHistory);
        this.bookmarksController = swingManager.createBookmarksController(this.config.getBookmarks(), this.buttonBookmarks);
        this.automaticExpressionChecker = new AbstractAutomaticExpressionChecker(this.config, this.text){

            @Override
            protected Expression getExpression() {
                return DefaultExpressionPickerController.this.getWithOutHistory();
            }

            @Override
            protected String getSuggestion() {
                if (DefaultExpressionPickerController.this.config == null) {
                    return null;
                }
                return DefaultExpressionPickerController.this.config.getSuggestion(this.getExpression());
            }

            @Override
            protected void stateChanged() {
                DefaultExpressionPickerController.this.fireChangeEvent();
            }
        };
        if ("...".equals(this.button.getText())) {
            this.button.setText("");
        }
        this.button.setIcon(this.getIcon("picker-expression"));
    }

    private void disposeComponents() {
        this.dispose();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.text.getDocument().putProperty("filterNewlines", false);
        this.button.addActionListener(this.buttonAction);
        swingManager.addClearButton(this.text, e -> {
            this.set((Expression)null);
            this.fireChangeEvent();
        });
        swingManager.setDefaultPopupMenu(this.text);
        JPopupMenu popupMenu = this.text.getComponentPopupMenu();
        this.menuItem.addActionListener(this.buttonAction);
        popupMenu.add(this.menuItem);
        this.historyController.addActionListener(this.historyAndBookmarkListener);
        popupMenu.add(this.historyController.createMenu());
        this.bookmarksController.addActionListener(this.historyAndBookmarkListener);
        popupMenu.add(this.bookmarksController.createMenu());
    }

    public void dispose() {
        if (this.buttonAction != null) {
            this.button.removeActionListener(this.buttonAction);
            this.menuItem.removeActionListener(this.buttonAction);
            this.buttonAction = null;
        }
        if (this.historyAndBookmarkListener != null) {
            this.historyController.removeActionListener(this.historyAndBookmarkListener);
            this.bookmarksController.removeActionListener(this.historyAndBookmarkListener);
            this.historyAndBookmarkListener = null;
        }
        DisposeUtils.disposeQuietly((Object)this.config);
        this.config = null;
    }

    private void doSelectExpression() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Expression theValue = this.get();
        JExpressionBuilder panel = this.manager.createJExpressionBuilder(this.config.cloneConfig());
        panel.setExpression(theValue);
        Dialog dialog = windowManager.createDialog(panel.asJComponent(), i18n.getTranslation("_Expression_builder"), null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            this.set(panel.getExpression());
            this.fireChangeEvent();
        }
    }

    public Expression get() {
        Expression expression = this.getWithOutHistory();
        if (expression != null && !expression.isEmpty()) {
            this.getConfig().getHistory().add((Object)ExpressionUtils.createExpression((String)expression.getPhrase()));
        }
        return expression;
    }

    public Expression getWithOutHistory() {
        String s = this.text.getText();
        if (this.returnNullWhenEmptyExpression && ExpressionUtils.isEmpty((Expression)this.value) && StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        if (this.value == null) {
            this.value = ExpressionEvaluatorLocator.getManager().createExpression();
        }
        this.value.setPhrase((String)StringUtils.defaultIfBlank((CharSequence)this.text.getText(), null));
        return this.value;
    }

    public void set(Expression value) {
        if (value == null) {
            this.text.setText("");
            this.value = null;
            this.returnNullWhenEmptyExpression = true;
        } else {
            this.value = value;
            this.text.setText(this.value.getPhrase());
            this.returnNullWhenEmptyExpression = false;
        }
    }

    public void set(String phrase) {
        if (this.value != null) {
            this.value.setPhrase(phrase);
        }
    }

    public boolean isEmpty() {
        boolean empty = StringUtils.isBlank((CharSequence)this.text.getText());
        return empty;
    }

    public void coerceAndSet(Object value) {
        try {
            Coercion toExpression = ToolsLocator.getDataTypesManager().getCoercion(80);
            this.set((Expression)toExpression.coerce(value));
        }
        catch (CoercionException ex) {
            throw new IllegalArgumentException("Can't converto to color", ex);
        }
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
        if (this.buttonBookmarks != null) {
            this.buttonBookmarks.setEnabled(enabled);
        }
        if (this.buttonHistory != null) {
            this.buttonHistory.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.text.isEnabled();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.text.setEditable(editable);
        this.button.setEnabled(editable);
        if (this.buttonBookmarks != null) {
            this.buttonBookmarks.setEnabled(editable);
        }
        if (this.buttonHistory != null) {
            this.buttonHistory.setEnabled(editable);
        }
    }

    public ExpressionBuilderConfig getConfig() {
        return this.config;
    }

    public boolean isValid() {
        return this.automaticExpressionChecker.isValid();
    }

    public void setHistory(History history) {
        if (history == null) {
            history = ExpressionEvaluatorLocator.getManager().getHistory();
        }
        this.historyController.setHistory(history);
        this.config.setHistory(history);
    }

    public void setBookmarks(Bookmarks bookmarks) {
        if (bookmarks == null) {
            bookmarks = ExpressionEvaluatorLocator.getManager().getBookmarks();
        }
        this.bookmarksController.setBookmarks(bookmarks);
        this.config.setBookmarks(bookmarks);
    }
}

