/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;

public class DefaultAggregateElements
extends AbstractElement
implements Element.GroupElement {
    private final List<Element> elements;
    private final ExpressionEvaluatorSwingManager manager;
    private List<Element> aggregateds;

    public DefaultAggregateElements(ExpressionEvaluatorSwingManager manager, String name) {
        super(name, (Object)name, "expressionbuilder-element-group");
        this.manager = manager;
        this.elements = new ArrayList<Element>();
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public Element get(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    public Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    public Collection<Element> getValues() {
        if (this.aggregateds == null) {
            this.aggregateds = this.buildChilds(null, this.elements);
        }
        return this.aggregateds;
    }

    private List<Element> buildChilds(List<Element> theAggregateds, List<Element> elements) {
        if (theAggregateds == null) {
            theAggregateds = new ArrayList<Element>();
        }
        for (Element element : elements) {
            theAggregateds.add(element);
            if (!(element instanceof Element.GroupElement)) continue;
            this.buildChilds(theAggregateds, ((Element.GroupElement)element).getElements());
        }
        return theAggregateds;
    }

    public void addElement(Element element) {
        this.elements.add(element);
    }

    public void addElement(Function function) {
        Element.ConstantElement item = this.manager.createConstantElement((Object)function, function.name());
        item.setConfig(this.getConfig());
        this.addElement((Element)item);
    }

    public Element setConfig(ExpressionBuilderConfig config) {
        super.setConfig(config);
        if (this.elements != null) {
            for (Element element : this.elements) {
                element.setConfig(config);
            }
        }
        return this;
    }

    public void dispose() {
        super.dispose();
        if (this.elements != null) {
            for (Element element : this.elements) {
                DisposeUtils.disposeQuietly((Disposable)element);
            }
            this.elements.clear();
        }
    }
}

