/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.progress;

import org.javanetworkanalyzer.progress.ConsoleProgressBar;
import org.javanetworkanalyzer.progress.ProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProgressMonitor
implements ProgressMonitor {
    private boolean cancelled = false;
    private int percentageComplete = 0;
    private long end;
    private ConsoleProgressBar consoleProgressBar;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProgressMonitor.class);

    @Override
    public void startTask(String taskName, long end) {
        LOGGER.info("STARTING TASK \"{}\"", (Object)taskName);
        this.end = end;
        this.consoleProgressBar = new ConsoleProgressBar(this, 40, 1);
    }

    @Override
    public void endTask() {
        LOGGER.info("TASK FINISHED");
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setProgress(long count) {
        this.percentageComplete = (int)(count * 100L / this.end);
    }

    @Override
    public int getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public void setProgress(long count, long startTime) {
        String bar = this.consoleProgressBar.progressBar(count, startTime);
        if (!bar.equals("")) {
            System.out.println(bar);
        }
        this.setProgress(count);
    }
}

