/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl;

import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInstantType;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.Chronology;
import org.gvsig.timesupport.Duration;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.impl.DefaultAbsoluteInstantType;
import org.gvsig.timesupport.impl.DefaultAbsoluteInterval;
import org.gvsig.timesupport.impl.DefaultChronology;
import org.gvsig.timesupport.impl.DefaultDuration;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;

public class DefaultAbsoluteInstant
implements AbsoluteInstant {
    private Partial jodaPartial = null;
    private AbsoluteInstantType[] dateTimeFieldTypes = null;
    private Chronology chronology = null;
    private DateTimeFieldType[] indexes = null;

    DefaultAbsoluteInstant(Chronology chronology) {
        this.jodaPartial = new Partial(((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
        this.initializeIndexes();
    }

    DefaultAbsoluteInstant(Chronology chronology, Partial jodaPartial) {
        this.jodaPartial = jodaPartial;
        this.chronology = chronology;
        this.initializeIndexes();
    }

    DefaultAbsoluteInstant(DefaultAbsoluteInstantType dateTimeFieldType, int value, Chronology chronology) {
        this.jodaPartial = new Partial(dateTimeFieldType.getJodaType(), value, ((DefaultChronology)chronology).getJodaType());
        this.dateTimeFieldTypes = new DefaultAbsoluteInstantType[1];
        this.dateTimeFieldTypes[0] = dateTimeFieldType;
        this.chronology = chronology;
        this.initializeIndexes();
    }

    DefaultAbsoluteInstant(DefaultAbsoluteInstantType[] dateTimeFieldTypes, int[] values, Chronology chronology) {
        DateTimeFieldType[] jodaDateTimeFieldTypes = new DateTimeFieldType[dateTimeFieldTypes.length];
        this.dateTimeFieldTypes = new DefaultAbsoluteInstantType[dateTimeFieldTypes.length];
        for (int i = 0; i < dateTimeFieldTypes.length; ++i) {
            this.dateTimeFieldTypes[i] = dateTimeFieldTypes[i];
            jodaDateTimeFieldTypes[i] = dateTimeFieldTypes[i].getJodaType();
        }
        this.jodaPartial = new Partial(jodaDateTimeFieldTypes, values, ((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
        this.initializeIndexes();
    }

    private void initializeIndexes() {
        this.indexes = new DateTimeFieldType[8];
        DateTimeFieldType[] dateTimeFieldTypes = this.jodaPartial.getFieldTypes();
        for (int i = 0; i < dateTimeFieldTypes.length; ++i) {
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.year())) {
                this.indexes[0] = dateTimeFieldTypes[i];
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.monthOfYear())) {
                this.indexes[1] = dateTimeFieldTypes[i];
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.weekOfWeekyear())) {
                this.indexes[2] = dateTimeFieldTypes[i];
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.dayOfMonth())) {
                this.indexes[3] = dateTimeFieldTypes[i];
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.hourOfDay())) {
                this.indexes[4] = dateTimeFieldTypes[i];
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.minuteOfHour())) {
                this.indexes[5] = dateTimeFieldTypes[i];
                continue;
            }
            if (dateTimeFieldTypes[i].equals(DateTimeFieldType.secondOfMinute())) {
                this.indexes[6] = dateTimeFieldTypes[i];
                continue;
            }
            if (!dateTimeFieldTypes[i].equals(DateTimeFieldType.millisOfSecond())) continue;
            this.indexes[7] = dateTimeFieldTypes[i];
        }
    }

    public int size() {
        return this.jodaPartial.size();
    }

    public AbsoluteInstantType getFieldType(int index) {
        return this.dateTimeFieldTypes[index];
    }

    public int getValue(int index) {
        return this.jodaPartial.getValue(index);
    }

    public String toString() {
        return this.jodaPartial.toString();
    }

    public String toString(String pattern) {
        return this.jodaPartial.toString(pattern);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultAbsoluteInstant)) {
            return false;
        }
        return ((DefaultAbsoluteInstant)obj).getJodaType().equals((Object)this.jodaPartial);
    }

    Partial getJodaType() {
        return this.jodaPartial;
    }

    public boolean isAfter(Instant partial) {
        return this.jodaPartial.isAfter((ReadablePartial)((DefaultAbsoluteInstant)partial).getJodaType());
    }

    public boolean isBefore(Instant partial) {
        return this.jodaPartial.isBefore((ReadablePartial)((DefaultAbsoluteInstant)partial).getJodaType());
    }

    public boolean isEqual(Instant partial) {
        return this.jodaPartial.isEqual((ReadablePartial)((DefaultAbsoluteInstant)partial).getJodaType());
    }

    public Chronology getChronology() {
        return this.chronology;
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultAbsoluteInstant(this.chronology, new Partial((ReadablePartial)this.jodaPartial));
    }

    public int getYears() {
        if (this.indexes[0] == null) {
            return 0;
        }
        return this.jodaPartial.get(this.indexes[0]);
    }

    public int getMonths() {
        if (this.indexes[1] == null) {
            return 1;
        }
        return this.jodaPartial.get(this.indexes[1]);
    }

    public int getWeeks() {
        if (this.indexes[2] == null) {
            return 0;
        }
        return this.jodaPartial.get(this.indexes[2]);
    }

    public int getDays() {
        if (this.indexes[3] == null) {
            return 1;
        }
        return this.jodaPartial.get(this.indexes[3]);
    }

    public int getHours() {
        if (this.indexes[4] == null) {
            return 0;
        }
        return this.jodaPartial.get(this.indexes[4]);
    }

    public int getMinutes() {
        if (this.indexes[5] == null) {
            return 0;
        }
        return this.jodaPartial.get(this.indexes[5]);
    }

    public int getSeconds() {
        if (this.indexes[6] == null) {
            return 0;
        }
        return this.jodaPartial.get(this.indexes[6]);
    }

    public int getMillis() {
        if (this.indexes[7] == null) {
            return 0;
        }
        return this.jodaPartial.get(this.indexes[7]);
    }

    public final boolean isRelative() {
        return false;
    }

    public boolean isAbsolute() {
        return true;
    }

    public final boolean isInterval() {
        return false;
    }

    public boolean isInstant() {
        return true;
    }

    public boolean intersects(Time time) {
        if (time.isAbsolute()) {
            if (time.isInterval()) {
                return ((AbsoluteInterval)time).getMillis() == 0 && ((AbsoluteInterval)time).getStart().equals(this);
            }
            return this.equals(time);
        }
        return true;
    }

    public AbsoluteInstant minus(AbsoluteInterval interval) {
        return new DefaultAbsoluteInstant(this.chronology, this.jodaPartial.minus((ReadablePeriod)((DefaultAbsoluteInterval)interval).getJodaType()));
    }

    public AbsoluteInstant plus(AbsoluteInterval interval) {
        return new DefaultAbsoluteInstant(this.chronology, this.jodaPartial.plus((ReadablePeriod)((DefaultAbsoluteInterval)interval).getJodaType()));
    }

    public Duration toStandardDuration() {
        long millis = 0L;
        millis += (long)this.getYears() * 946080000000L;
        millis += (long)(this.getMonths() - 1) * 2592000000L;
        millis += (long)(this.getDays() - 1) * 946080000000L;
        millis += (long)this.getHours() * 3600000L;
        millis += (long)this.getMinutes() * 60000L;
        millis += (long)this.getSeconds() * 1000L;
        return new DefaultDuration(millis += (long)this.getMillis());
    }
}

