/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSProtocolHandler;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class WMTSProtocolHandlerFactory {
    private static final List<String> supportedVersions = new ArrayList<String>();

    public static WMTSProtocolHandler negotiate(String host) throws ConnectException, IOException {
        String highestVersionSupportedByServer = WMTSProtocolHandlerFactory.getSuitableWMTSVersion(host, "");
        if (supportedVersions.contains(highestVersionSupportedByServer)) {
            return WMTSProtocolHandlerFactory.createVersionDriver(highestVersionSupportedByServer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSuitableWMTSVersion(String host, String _version) throws ConnectException, IOException {
        String request = WMTSProtocolHandler.buildCapabilitiesSuitableVersionRequest(host, _version);
        String version = "";
        StringReader reader = null;
        InputStream dis = null;
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        try {
            URL url = new URL(request);
            byte[] buffer = new byte[1024];
            File f = downloader.downloadFile(url, "GET", null, null, "getSuitableWMTSVersion", ICancellable.DUMB, -1, false);
            dis = new FileInputStream(f);
            IOUtils.readFully((InputStream)dis, (byte[])buffer);
            String string = new String(buffer);
            int a = string.toLowerCase().indexOf("<?xml");
            if (a != -1) {
                string = string.substring(a, string.length());
            }
            reader = new StringReader(string);
            KXmlParser kxmlParser = new KXmlParser();
            kxmlParser.setInput((Reader)reader);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1 && kxmlParser.getName().compareTo("Capabilities") == 0) {
                version = kxmlParser.getAttributeValue("", "version");
            }
            reader.close();
            dis.close();
            String string2 = version;
            return string2;
        }
        catch (XmlPullParserException xmlEx) {
            xmlEx.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static WMTSProtocolHandler createVersionDriver(String version) {
        try {
            version = version.replace('.', '_');
            Class<?> driver = Class.forName("org.gvsig.raster.wmts.ogc.impl.wmts_" + version + ".WMTSProtocolHandler" + version);
            return (WMTSProtocolHandler)driver.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        supportedVersions.add("1.0.0");
    }
}

