/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.wmts.ogc.exception.WMTSException;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSLayerImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSOperationsMetadataImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSServiceIdentificationImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSServiceProviderImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSThemesImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSet;

public class WMTSServerDescription {
    private int width;
    private int height;
    private String format = null;
    private String infoFormat = null;
    private String srs = null;
    private String exceptionFormat = null;
    private int protocol = -1;
    private List<WMTSLayer> layerList = null;
    private List<WMTSTileMatrixSet> tileMatrixSet = null;
    private WMTSThemesImpl themes = null;
    private WMTSThemesImpl themesAsLayerList = null;
    private WMTSServiceIdentificationImpl serviceId = null;
    private WMTSServiceProviderImpl serviceProv = null;
    private WMTSOperationsMetadataImpl operationsMetadata = null;
    private String version = null;

    public WMTSServerDescription(String version) {
        this.version = version;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int _width) {
        this.width = _width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int _height) {
        this.height = _height;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String _format) {
        this.format = _format;
    }

    public String getInfoFormat() {
        return this.infoFormat;
    }

    public void setInfoFormat(String _format) {
        this.infoFormat = _format;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String _srs) {
        this.srs = _srs;
    }

    public void setExceptionFormat(String _format) {
        this.exceptionFormat = _format;
    }

    public String getExceptionFormat() {
        return this.exceptionFormat;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public WMTSLayerImpl buildNewLayer() {
        try {
            this.version = this.version.replace('.', '_');
            Class<?> clase = Class.forName("org.gvsig.raster.wmts.ogc.impl.wmts_" + this.version + ".struct.WMTSLayer_" + this.version);
            Class[] args = new Class[]{WMTSServerDescription.class};
            try {
                Constructor<?> hazNuevo = clase.getConstructor(args);
                Object[] args2 = new Object[]{this};
                return (WMTSLayerImpl)hazNuevo.newInstance(args2);
            }
            catch (SecurityException e) {
                throw new WMTSException("Error SecurityException in open", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new WMTSException("Error NoSuchMethodException in open", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new WMTSException("Error IllegalArgumentException in open", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new WMTSException("Error InstantiationException in open", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new WMTSException("Error IllegalAccessException in open", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WMTSException("Error opening this image with " + clase, (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object createVersionObject(String className) {
        return this.createVersionObject(className, this.version);
    }

    public Object createVersionObject(String className, String version) {
        try {
            version = version.replace('.', '_');
            Class<?> driver = Class.forName("org.gvsig.raster.wmts.ogc.impl.wmts_" + version + ".struct." + className + "_" + version);
            return driver.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public WMTSOperationsMetadataImpl getOperationsMetadata() {
        if (this.operationsMetadata == null) {
            this.operationsMetadata = (WMTSOperationsMetadataImpl)this.createVersionObject("WMTSOperationsMetadata", this.version);
        }
        return this.operationsMetadata;
    }

    public WMTSServiceIdentificationImpl getServiceIdentification() {
        if (this.serviceId == null) {
            this.serviceId = (WMTSServiceIdentificationImpl)this.createVersionObject("WMTSServiceIdentification", this.version);
        }
        return this.serviceId;
    }

    public WMTSServiceProviderImpl getServiceProvider() {
        if (this.serviceProv == null) {
            this.serviceProv = (WMTSServiceProviderImpl)this.createVersionObject("WMTSServiceProvider", this.version);
        }
        return this.serviceProv;
    }

    public List<WMTSLayer> getLayerList() {
        if (this.layerList == null) {
            this.layerList = new ArrayList<WMTSLayer>();
        }
        return this.layerList;
    }

    public List<WMTSTileMatrixSet> getTileMatrixSet() {
        if (this.tileMatrixSet == null) {
            this.tileMatrixSet = new ArrayList<WMTSTileMatrixSet>();
        }
        return this.tileMatrixSet;
    }

    public WMTSThemesImpl getThemes() {
        if (this.themes == null) {
            this.themes = (WMTSThemesImpl)this.createVersionObject("WMTSThemes", this.version);
        }
        return this.themes;
    }

    public WMTSThemesImpl getLayerListAsThemes() {
        if (this.themesAsLayerList == null) {
            this.themesAsLayerList = (WMTSThemesImpl)this.createVersionObject("WMTSThemes", this.version);
        }
        return this.themesAsLayerList;
    }

    public WMTSLayerImpl getLayerByTitle(String titleLayer) {
        for (int i = 0; i < this.layerList.size(); ++i) {
            WMTSLayerImpl layer = (WMTSLayerImpl)this.layerList.get(i);
            if (layer.getTitle().compareTo(titleLayer) != 0) continue;
            return layer;
        }
        return null;
    }

    public void clear() {
        if (this.layerList != null) {
            this.layerList.clear();
        }
        if (this.tileMatrixSet != null) {
            this.tileMatrixSet.clear();
        }
        this.themes = null;
        this.serviceId = null;
        this.serviceProv = null;
    }
}

