/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.app.wmtsclient.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanel;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wmts.app.wmtsclient.layer.FLyrWMTS;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSServerExplorer;
import org.gvsig.raster.wmts.swing.WMTSSwingLocator;
import org.gvsig.raster.wmts.swing.WMTSWizardListener;
import org.gvsig.raster.wmts.swing.WmtsGUI;

public class WMTSPropsDialog
extends JPanel
implements IWindow,
ButtonsPanelListener {
    private static final long serialVersionUID = 1L;
    private FLyrWMTS fLayer = null;
    private WindowInfo m_ViewInfo = null;
    private ButtonsPanel buttonsPanel = null;
    private WmtsGUI wmtsGUIInterface = null;
    private WMTSServerExplorer explorer = null;

    public WMTSPropsDialog() {
        this.initialize(null);
    }

    public WMTSPropsDialog(FLayer layer) {
        if (layer instanceof FLyrWMTS) {
            this.fLayer = (FLyrWMTS)layer;
            this.initialize(this.fLayer);
        }
    }

    private void initialize(FLyrWMTS layer) {
        HashMap<String, Object> hash = layer != null ? layer.getProperties() : null;
        this.wmtsGUIInterface = this.getParamsPanel(hash);
        this.setLayout(new BorderLayout());
        this.add((Component)this.wmtsGUIInterface, "Center");
        this.add((Component)this.getButtonsPanel(), "South");
    }

    public ButtonsPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new ButtonsPanel();
            this.buttonsPanel.addApply();
            this.buttonsPanel.addAccept();
            this.buttonsPanel.addClose();
            this.buttonsPanel.addButtonPressedListener((ButtonsPanelListener)this);
        }
        return this.buttonsPanel;
    }

    public WmtsGUI getParamsPanel(HashMap<String, Object> info) {
        block7: {
            if (info == null) {
                WmtsGUI toc = WMTSSwingLocator.getSwingManager().createMainWizard((WMTSWizardListener)new WizardListenerImpl());
                return toc;
            }
            try {
                if (this.explorer != null) break block7;
                this.explorer = this.fLayer.getExplorer();
                try {
                    this.explorer.connect((ICancellable)new CancelTaskImpl());
                }
                catch (ConnectException e) {
                    RasterSwingLibrary.messageBoxError((String)"The connection cannot be established", (Object)this, (Exception)((Object)e));
                    return null;
                }
            }
            catch (Exception e) {
                this.explorer = null;
                JOptionPane.showMessageDialog(null, "error_comunicacion_servidor", "Error", 0);
            }
        }
        try {
            WmtsGUI toc = WMTSSwingLocator.getSwingManager().createMainWizard((WMTSWizardListener)new WizardListenerImpl());
            toc.setWizardData(this.explorer);
            toc.updateSelectedInfo(info);
            return toc;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "error_comunicacion_servidor", "Error", 0);
            return null;
        }
    }

    public WindowInfo getWindowInfo() {
        if (this.m_ViewInfo == null) {
            this.m_ViewInfo = new WindowInfo(9);
            this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"fit_WMTS_layer"));
            this.m_ViewInfo.setWidth(500);
            this.m_ViewInfo.setHeight(500);
        }
        return this.m_ViewInfo;
    }

    public void close() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public List<FLyrWMTS> getLayerList(RasterDataParameters[] paramsList) throws LoadLayerException {
        ArrayList<FLyrWMTS> layerList = new ArrayList<FLyrWMTS>();
        for (int i = 0; i < paramsList.length; ++i) {
            FLyrWMTS layer = new FLyrWMTS();
            layer.deleteCache(this.wmtsGUIInterface.getDeleteCache());
            try {
                DataParameters p;
                layer.setParameters((DataStoreParameters)paramsList[i]);
                String title = null;
                if (paramsList[i] instanceof WMTSDataParameters) {
                    title = ((WMTSDataParameters)paramsList[i]).getLayer().getTitle();
                } else if (paramsList[i] instanceof TileDataParameters && (p = ((TileDataParameters)paramsList[i]).getDataParameters()) instanceof WMTSDataParameters) {
                    title = ((WMTSDataParameters)p).getLayer().getTitle();
                }
                layer.setName(title);
                layer.setExplorer(this.explorer);
                layerList.add(layer);
                continue;
            }
            catch (InitializeException e) {
                throw new LoadLayerException("Error initializating layer", (Throwable)e);
            }
        }
        return layerList;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (e.getButton() == 3 || e.getButton() == 1) {
            MapControl mapCtrl = null;
            IWindow[] w = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < w.length; ++i) {
                MapContext mapContext;
                if (!(w[i] instanceof AbstractViewPanel) || (mapContext = ((AbstractViewPanel)w[i]).getMapControl().getMapContext()) != this.fLayer.getMapContext()) continue;
                mapCtrl = ((AbstractViewPanel)w[i]).getMapControl();
            }
            try {
                List<FLyrWMTS> layerList = this.getLayerList(this.wmtsGUIInterface.getDataParameters());
                if (layerList.size() > 0 && layerList.get(0) != null) {
                    for (int i = 0; i < layerList.size(); ++i) {
                        if (!(layerList.get(i) instanceof FLyrWMTS)) continue;
                        mapCtrl.getMapContext().getLayers().removeLayer((FLayer)this.fLayer);
                        mapCtrl.getMapContext().getLayers().addLayer((FLayer)layerList.get(i));
                        this.fLayer = layerList.get(i);
                    }
                }
                mapCtrl.getMapContext().invalidate();
            }
            catch (LoadLayerException exc) {
                exc.printStackTrace();
            }
        }
        if (e.getButton() == 6 || e.getButton() == 1) {
            this.close();
        }
    }

    public class WizardListenerImpl
    implements WMTSWizardListener {
        public void correctlyConfiguredEvent(boolean finishable) {
            WMTSPropsDialog.this.getButtonsPanel().getButton(1).setEnabled(finishable);
            WMTSPropsDialog.this.getButtonsPanel().getButton(3).setEnabled(finishable);
        }

        public void addLayerEvent() {
        }

        public void removeLayerEvent() {
        }
    }
}

