/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.app.wmtsclient.gui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.persistence.serverData.ServerDataPersistence;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.Messages;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wmts.app.wmtsclient.WMTSClientExtension;
import org.gvsig.raster.wmts.app.wmtsclient.layer.FLyrWMTS;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSServerExplorer;
import org.gvsig.raster.wmts.io.WMTSServerExplorerParameters;
import org.gvsig.raster.wmts.ogc.struct.WMTSServiceIdentification;
import org.gvsig.raster.wmts.swing.AddServerPanel;
import org.gvsig.raster.wmts.swing.NextPrevPanel;
import org.gvsig.raster.wmts.swing.WMTSSwingLocator;
import org.gvsig.raster.wmts.swing.WMTSWizardListener;
import org.gvsig.raster.wmts.swing.WmtsGUI;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.utils.swing.jcomboServer.ServerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSWizard
extends WizardPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(WMTSWizard.class);
    private String pluginName = "org.gvsig.raster.wmts.app.wmtsclient";
    private File pluginPersistenceFile = null;
    private File serverPropertiesFile = null;
    private ServerDataPersistence serverDataPersistence = null;
    private String serversPropsFilename = "servers.properties";
    protected int page = 0;
    protected boolean connected = false;
    private AddServerPanel serverPanel = null;
    private NextPrevPanel nextPrevPanel = null;
    protected WmtsGUI wmtsParamsPanel = null;
    private WMTSWizardListenerImpl listenerSupport = null;
    private static Preferences fPrefs = Preferences.userRoot().node("gvsig.wmts-wizard");
    private boolean refreshing = fPrefs.getBoolean("refresh_capabilities", false);
    protected int firstPage = 0;
    private IProjection proj = null;
    private ICancellable cancel = null;
    private WMTSDataParameters storeParams = null;
    private WMTSServerExplorer explorer = null;
    private PluginServices plugin = null;

    public WMTSWizard() {
        IWindow[] windows;
        this.page = this.firstPage = 0;
        this.initialize();
        for (IWindow window : windows = PluginServices.getMDIManager().getAllWindows()) {
            if (!(window instanceof AbstractViewPanel)) continue;
            this.proj = ((AbstractViewPanel)window).getProjection();
        }
        this.cancel = new CancelTaskImpl();
    }

    private void initialize() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        this.plugin = pluginsManager.getPlugin(WMTSClientExtension.class);
        this.setTabName("WMTS");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(2, 12, 10, 12);
        this.setVisible(true);
        this.add((Component)this.getIserverPanel(), gridBagConstraints1);
        gridBagConstraints1.insets = new Insets(2, 0, 10, 0);
        this.add((Component)this.getPanelPage2(), gridBagConstraints1);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getNextPrevPanel(), gridBagConstraints1);
        this.activarVisualizarBotones();
        this.getIserverPanel().getTxtHost().setServerList(this.getServerDataPersistence().getArrayOfServerData());
    }

    public boolean areSettingsValid() {
        return this.getPanelPage2().isCorrectlyConfigured();
    }

    private WMTSWizardListenerImpl getWizardListenerSupport() {
        if (this.listenerSupport == null) {
            this.listenerSupport = new WMTSWizardListenerImpl();
        }
        return this.listenerSupport;
    }

    private boolean checkHostAndNetwork() {
        if (!this.explorer.isHostReachable()) {
            JOptionPane.showMessageDialog(null, Messages.getText((String)"host_unreachable"), Messages.getText((String)"Error"), 0);
            this.getIserverPanel().setTextInfo("Connection closed... \n");
            return false;
        }
        return true;
    }

    private void rellenarControles() {
        try {
            WMTSServiceIdentification id = this.explorer.getOGCClient().getServiceIdentification();
            this.getIserverPanel().setTitle(id.getTitle());
            this.getNextPrevPanel().getJLabelServerTypeValue().setText(id.getServiceType());
            this.getIserverPanel().setTextInfo(id.getAbstract());
            this.getPanelPage2().setWizardData(this.explorer);
            this.connected = true;
            this.activarVisualizarBotones();
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                this.getIserverPanel().setTextInfo(Messages.getText((String)"error"));
            } else {
                this.getIserverPanel().setTextInfo(e.getMessage());
            }
            this.getNextPrevPanel().getBtnNext().setEnabled(false);
            this.getNextPrevPanel().getBtnPrev().setEnabled(true);
        }
        finally {
            this.getIserverPanel().getBtnCancel().setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getIserverPanel().getBtnConnect()) {
            this.getIserverPanel().getBtnCancel().setEnabled(true);
            this.getIserverPanel().setTextInfo("Trying to connect...");
            String host = this.getIserverPanel().getTxtHost().getModel().getSelectedItem().toString();
            try {
                DataManager datamanager = DALLocator.getDataManager();
                WMTSServerExplorerParameters explorerParams = (WMTSServerExplorerParameters)datamanager.createServerExplorerParameters(WMTSServerExplorer.NAME);
                explorerParams.setHost(host);
                explorerParams.setLongitudeFirst(this.getIserverPanel().getChkInvertAxisOrder().isSelected());
                this.explorer = (WMTSServerExplorer)datamanager.createServerExplorer((DataServerExplorerParameters)explorerParams);
                ((CancelTaskImpl)this.cancel).setCanceled(false);
                new ConnectThread(this.cancel, this.explorer, this).start();
            }
            catch (InitializeException e1) {
                this.getIserverPanel().setTextInfo("Error creating WMTS layer");
            }
            catch (ProviderNotRegisteredException e1) {
                this.getIserverPanel().setTextInfo("Provider not registered. I cannot connect.");
            }
            catch (ValidateDataParametersException e1) {
                this.getIserverPanel().setTextInfo("Parameters not valid. I cannot connect.");
            }
        }
        if (e.getSource() == this.getIserverPanel().getBtnCancel()) {
            this.getIserverPanel().setTextInfo("Cancelled...");
            ((CancelTaskImpl)this.cancel).setCanceled(true);
            this.getIserverPanel().getBtnCancel().setEnabled(false);
        }
        if (e.getSource() == this.getNextPrevPanel().getBtnPrev()) {
            --this.page;
            if (this.page > this.firstPage) {
                this.getPanelPage2().setPreviousTab();
                this.page = this.getPanelPage2().currentPage() + 1;
                this.activarVisualizarBotones();
            } else if (this.page == this.firstPage) {
                this.activarVisualizarBotones();
                this.page = this.firstPage + 1;
                this.getIserverPanel().setTitle("-");
                this.getIserverPanel().setTextInfo("");
                this.getPanelPage2().setPreviousTab();
                this.getIserverPanel().setVisible(true);
                this.getPanelPage2().setVisible(false);
                this.getNextPrevPanel().getBtnNext().setEnabled(false);
                this.connected = false;
            }
        }
        if (e.getSource() == this.getNextPrevPanel().getBtnNext()) {
            if (this.page > this.firstPage) {
                this.getPanelPage2().setNextTab();
                this.page = this.getPanelPage2().currentPage();
            }
            ++this.page;
            this.getIserverPanel().setVisible(false);
            this.getPanelPage2().setVisible(true);
            this.activarVisualizarBotones();
        }
    }

    private AddServerPanel getIserverPanel() {
        if (this.serverPanel == null) {
            this.serverPanel = WMTSSwingLocator.getSwingManager().createAddServerPanel();
            this.serverPanel.getBtnCancel().addActionListener(this);
            this.serverPanel.getBtnConnect().addActionListener(this);
        }
        return this.serverPanel;
    }

    public NextPrevPanel getNextPrevPanel() {
        if (this.nextPrevPanel == null) {
            this.nextPrevPanel = WMTSSwingLocator.getSwingManager().createNextPrevPanel();
            this.nextPrevPanel.getBtnNext().addActionListener(this);
            this.nextPrevPanel.getBtnPrev().addActionListener(this);
        }
        return this.nextPrevPanel;
    }

    protected WmtsGUI getPanelPage2() {
        if (this.wmtsParamsPanel == null) {
            this.wmtsParamsPanel = WMTSSwingLocator.getSwingManager().createMainWizard((WMTSWizardListener)this.getWizardListenerSupport(), () -> {
                IWindow wi = PluginServices.getMDIManager().getActiveWindow();
                if (wi instanceof IView) {
                    return ((IView)wi).getMapControl().getMapContext();
                }
                return null;
            });
            this.wmtsParamsPanel.addChangeTabListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WMTSWizard.this.page = WMTSWizard.this.wmtsParamsPanel.currentPage() + 1;
                    WMTSWizard.this.activarVisualizarBotones();
                }
            });
        }
        return this.wmtsParamsPanel;
    }

    protected void activarVisualizarBotones() {
        if (this.page == this.firstPage) {
            this.getNextPrevPanel().getBtnPrev().setEnabled(false);
            if (this.connected) {
                this.getNextPrevPanel().getBtnNext().setEnabled(true);
            } else {
                this.getNextPrevPanel().getBtnNext().setEnabled(false);
            }
        } else if (this.page < this.getPanelPage2().getNumTabs()) {
            this.getNextPrevPanel().getBtnNext().setEnabled(true);
            this.getNextPrevPanel().getBtnPrev().setEnabled(true);
            if (this.getPanelPage2().nextEnabledPage() == -1) {
                this.getNextPrevPanel().getBtnNext().setEnabled(false);
            }
        } else if (this.page == this.getPanelPage2().getNumTabs()) {
            this.getNextPrevPanel().getBtnNext().setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ServerDataPersistence getServerDataPersistence() {
        ServerDataPersistence servers;
        block8: {
            DynObject pluginProperties = this.plugin.getPluginProperties();
            servers = (ServerDataPersistence)pluginProperties.getDynValue("servers");
            if (servers != null && !servers.isEmpty()) break block8;
            if (servers == null) {
                servers = new ServerDataPersistence("WMTS");
                pluginProperties.setDynValue("servers", (Object)servers);
            }
            Properties prop = new Properties();
            File propFile = new File(this.plugin.getPluginDirectory(), this.serversPropsFilename);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                prop.load(fis);
            }
            catch (FileNotFoundException e) {
                logger.info("Properties file '" + propFile.getAbsolutePath() + "' not found", (Throwable)e);
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (IOException e2) {
                logger.info("Error reading properties file '" + propFile.getAbsolutePath() + "'.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
            for (int i = 0; i < prop.size(); ++i) {
                Object value = prop.get("server[" + i + "]");
                servers.addServerData(new ServerData(value.toString(), "WMTS"));
            }
        }
        return servers;
    }

    private void saveServerListFromComboBox() {
        ServerDataPersistence persistence = this.getServerDataPersistence();
        String urlSelected = this.getIserverPanel().getTxtHost().getModel().getSelectedItem().toString();
        boolean isSelectedInModel = false;
        for (int i = 0; i < this.getIserverPanel().getTxtHost().getItemCount(); ++i) {
            String url = this.getIserverPanel().getTxtHost().getItemAt(i).toString();
            persistence.addServerData(new ServerData(url, "WMTS"));
            if (!url.equals(urlSelected)) continue;
            isSelectedInModel = true;
        }
        if (!isSelectedInModel) {
            persistence.addServerData(new ServerData(urlSelected, "WMTS"));
        }
    }

    public URL getHost() {
        try {
            if (this.getIserverPanel().getTxtHost() == null || this.getIserverPanel().getTxtHost().getModel().getSelectedItem() == null) {
                return new URL(this.explorer.getHost());
            }
            return new URL(this.getIserverPanel().getTxtHost().getModel().getSelectedItem().toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void initWizard() {
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
    }

    public void execute() {
        try {
            this.getPanelPage2().setDeleteCache(this.getIserverPanel().getChkCaching().isSelected());
            RasterDataParameters[] paramsList = this.getPanelPage2().getDataParameters();
            List<FLyrWMTS> lyrList = this.getLayerList(paramsList);
            for (int i = 0; i < lyrList.size(); ++i) {
                this.getMapCtrl().getMapContext().getLayers().addLayer((FLayer)lyrList.get(i));
            }
        }
        catch (LoadLayerException e) {
            logger.info("Persistence file not found for WMS plugin", (Throwable)e);
        }
    }

    public List<FLyrWMTS> getLayerList(RasterDataParameters[] paramsList) throws LoadLayerException {
        ArrayList<FLyrWMTS> layerList = new ArrayList<FLyrWMTS>();
        for (RasterDataParameters paramsList1 : paramsList) {
            FLyrWMTS layer = new FLyrWMTS();
            layer.deleteCache(this.getPanelPage2().getDeleteCache());
            try {
                DataParameters p;
                layer.setParameters((DataStoreParameters)paramsList1);
                String title = null;
                if (paramsList1 instanceof WMTSDataParameters) {
                    title = ((WMTSDataParameters)paramsList1).getLayer().getTitle();
                } else if (paramsList1 instanceof TileDataParameters && (p = ((TileDataParameters)paramsList1).getDataParameters()) instanceof WMTSDataParameters) {
                    title = ((WMTSDataParameters)p).getLayer().getTitle();
                }
                layer.setName(title);
                layer.setExplorer(this.explorer);
                layerList.add(layer);
            }
            catch (InitializeException e) {
                throw new LoadLayerException("Error initializating layer", (Throwable)e);
            }
        }
        return layerList;
    }

    public class ConnectThread
    extends Thread {
        private ICancellable cancel = null;
        private WMTSServerExplorer explorer = null;
        private WMTSWizard wizard = null;

        public ConnectThread(ICancellable cancel, WMTSServerExplorer explorer, WMTSWizard wizard) {
            this.cancel = cancel;
            this.explorer = explorer;
            this.wizard = wizard;
        }

        @Override
        public void run() {
            DataParameters p;
            if (!WMTSWizard.this.checkHostAndNetwork()) {
                return;
            }
            try {
                this.explorer.connect(this.cancel);
                WMTSWizard.this.saveServerListFromComboBox();
            }
            catch (ConnectException e) {
                WMTSWizard.this.getIserverPanel().setTextInfo("Connection closed... \n" + e.getMessage());
                JOptionPane.showMessageDialog(null, Messages.getText((String)"wmts_cant_connect"), Messages.getText((String)"Error"), 0);
                return;
            }
            finally {
                ((CancelTaskImpl)this.cancel).setCanceled(false);
            }
            DataStoreParameters parameters = this.explorer.getStoredParameters();
            if (parameters instanceof WMTSDataParameters) {
                WMTSWizard.this.storeParams = (WMTSDataParameters)parameters;
            }
            if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WMTSDataParameters) {
                WMTSWizard.this.storeParams = (WMTSDataParameters)p;
            }
            this.wizard.rellenarControles();
        }
    }

    public class WMTSWizardListenerImpl
    implements WMTSWizardListener {
        public void correctlyConfiguredEvent(boolean finishable) {
            WMTSWizard.this.callStateChanged(finishable);
        }

        public void addLayerEvent() {
            WMTSWizard.this.activarVisualizarBotones();
        }

        public void removeLayerEvent() {
            WMTSWizard.this.activarVisualizarBotones();
        }
    }
}

